/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core;

import com.cedarsoftware.util.io.JsonObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.virtualan.annotation.ApiVirtual;
import io.virtualan.annotation.VirtualService;
import io.virtualan.api.ApiMethod;
import io.virtualan.api.ApiResource;
import io.virtualan.api.ApiType;
import io.virtualan.core.VirtualServiceConstants;
import io.virtualan.core.model.ResourceMapper;
import io.virtualan.core.model.VirtualServiceApiResponse;
import io.virtualan.core.model.VirtualServiceKeyValue;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.util.VirtualanConfiguration;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.jeasy.random.EasyRandom;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public interface VirtualServiceInfo {
    public ApiType getApiType();

    public void setApiType(ApiType var1);

    public ObjectMapper getObjectMapper();

    public void setObjectMapper(ObjectMapper var1);

    public ResourceMapper getResourceParent();

    public void setResourceParent(ResourceMapper var1);

    public Map<String, Map<String, VirtualServiceRequest>> getMockLoadChoice();

    public void setMockLoadChoice(Map<String, Map<String, VirtualServiceRequest>> var1);

    public void buildInput(Method var1, VirtualServiceRequest var2) throws JsonProcessingException, InstantiationException, IllegalAccessException, ClassNotFoundException;

    default public String getResourceDesc(Method method) {
        Operation[] apiOperationAnno = (Operation[])method.getAnnotationsByType(Operation.class);
        if (apiOperationAnno != null && apiOperationAnno.length > 0) {
            return apiOperationAnno[0].description();
        }
        return null;
    }

    default public Map<String, Class> findVirtualServices(ClassLoader context) {
        HashMap<String, Class> virtualInterfaces = new HashMap<String, Class>();
        try {
            Field f = ClassLoader.class.getDeclaredField("classes");
            f.setAccessible(true);
            ClassLoader classLoader = context;
            List classes = (List)f.get(classLoader);
            for (int i = 0; i < classes.size(); ++i) {
                Class classzz = (Class)classes.get(i);
                this.loadClasses(virtualInterfaces, classzz, this.getName(classzz));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            LogHolder.log.error("Unable to load from the class loader {}", (Object)e1.getMessage());
        }
        return virtualInterfaces;
    }

    default public Map<String, Class> findVirtualServices() {
        HashMap<String, Class> virtualInterfaces = new HashMap<String, Class>();
        try {
            Field f = ClassLoader.class.getDeclaredField("classes");
            f.setAccessible(true);
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            List classes = (List)f.get(classLoader);
            for (int i = 0; i < classes.size(); ++i) {
                Class classzz = (Class)classes.get(i);
                this.loadClasses(virtualInterfaces, classzz, this.getName(classzz));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            LogHolder.log.error("Unable to load from the class loader {}", (Object)e1.getMessage());
        }
        return virtualInterfaces;
    }

    default public String getName(Class classzz) {
        String interfaceName = classzz.getTypeName();
        interfaceName = interfaceName.substring(interfaceName.lastIndexOf(46) + 1);
        interfaceName = interfaceName.toLowerCase();
        return interfaceName;
    }

    default public void loadClasses(Map<String, Class> virtualInterfaces, Class classzz, String interfaceName) {
        try {
            if (classzz.isAnnotationPresent(VirtualService.class)) {
                virtualInterfaces.put(interfaceName, classzz);
            }
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    default public Map<String, Map<String, VirtualServiceRequest>> loadVirtualServices(boolean scriptEnabled) throws ClassNotFoundException, JsonProcessingException, InstantiationException, IllegalAccessException {
        Map<String, Map<String, VirtualServiceRequest>> mockLoadChoice = this.getMockLoadChoice();
        mockLoadChoice = new TreeMap<String, Map<String, VirtualServiceRequest>>();
        for (Map.Entry<String, Class> virtualServiceEntry : this.findVirtualServices().entrySet()) {
            Map<String, VirtualServiceRequest> mockAPILoadChoice = this.buildVirtualServiceInfo(scriptEnabled, virtualServiceEntry);
            if (mockAPILoadChoice.isEmpty()) continue;
            Map<String, Map<String, VirtualServiceRequest>> resourceGroup = mockAPILoadChoice.entrySet().stream().filter(x -> !"virtualanendpoint".equalsIgnoreCase((String)x.getKey())).collect(Collectors.groupingBy(f -> ((VirtualServiceRequest)f.getValue()).getResource(), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            mockLoadChoice.putAll(resourceGroup);
        }
        this.setMockLoadChoice(mockLoadChoice);
        return mockLoadChoice;
    }

    default public Map<String, Map<String, VirtualServiceRequest>> loadVirtualServices(boolean scriptEnabled, ClassLoader loader) throws ClassNotFoundException, JsonProcessingException, InstantiationException, IllegalAccessException {
        TreeMap<String, Map<String, VirtualServiceRequest>> mockLoadChoice = new TreeMap<String, Map<String, VirtualServiceRequest>>();
        for (Map.Entry<String, Class> virtualServiceEntry : this.findVirtualServices(loader).entrySet()) {
            Map<String, VirtualServiceRequest> mockAPILoadChoice = this.buildVirtualServiceInfo(scriptEnabled, virtualServiceEntry);
            if (mockAPILoadChoice.isEmpty()) continue;
            Map<String, Map<String, VirtualServiceRequest>> resourceGroup = mockAPILoadChoice.entrySet().stream().filter(x -> !"virtualanendpoint".equalsIgnoreCase((String)x.getKey())).collect(Collectors.groupingBy(f -> ((VirtualServiceRequest)f.getValue()).getResource(), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            mockLoadChoice.putAll(resourceGroup);
        }
        this.setMockLoadChoice(mockLoadChoice);
        VirtualanConfiguration.setVirtualServiceRequestMap(mockLoadChoice);
        return VirtualanConfiguration.getVirtualServiceRequestMap();
    }

    default public Map<String, String> getTypes(boolean scriptEnabled) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("RESPONSE", "Response");
        map.put("PARAMS", "Params");
        if (scriptEnabled) {
            map.put("RULE", "Rule");
            map.put("SCRIPT", "Script");
        }
        return map;
    }

    default public Map<String, VirtualServiceRequest> buildVirtualServiceInfo(boolean scriptEnabled, Map.Entry<String, Class> virtualServiceEntry) throws JsonProcessingException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        LinkedHashMap<String, VirtualServiceRequest> mockAPILoadChoice = new LinkedHashMap<String, VirtualServiceRequest>();
        for (Method method : virtualServiceEntry.getValue().getDeclaredMethods()) {
            VirtualServiceRequest mockReturn;
            ApiVirtual[] annotInstance = (ApiVirtual[])method.getAnnotationsByType(ApiVirtual.class);
            if (annotInstance == null || annotInstance.length <= 0 || (mockReturn = this.buildServiceDetails(scriptEnabled, virtualServiceEntry, method)) == null) continue;
            mockAPILoadChoice.put(method.getName(), mockReturn);
        }
        return mockAPILoadChoice;
    }

    default public boolean isValidJson(String jsonStr) {
        Object json = new JSONTokener(jsonStr).nextValue();
        return json instanceof JSONObject || json instanceof JSONArray;
    }

    default public Class getInputType(VirtualServiceRequest mockTransferInput) {
        Class inputType = null;
        if (mockTransferInput.getResource() == null) {
            mockTransferInput.setResource(ApiResource.getResourceByURL(mockTransferInput.getUrl()));
        }
        if (mockTransferInput.getOperationId() != null && this.getMockLoadChoice().get(mockTransferInput.getResource()) != null) {
            VirtualServiceRequest mockTransferActual = this.getMockLoadChoice().get(mockTransferInput.getResource()).get(mockTransferInput.getOperationId());
            if (mockTransferActual != null) {
                inputType = mockTransferInput.getInput() != null && this.isValidJson(mockTransferInput.getInput().toString()) && mockTransferActual.getInputObjectType().isAssignableFrom(String.class) ? JsonObject.class : mockTransferActual.getInputObjectType();
            }
        } else {
            String resourceUrl = mockTransferInput.getUrl().substring(1);
            LinkedList<String> resouceSplitterList = new LinkedList<String>(Arrays.asList(resourceUrl.split("/")));
            if (!resouceSplitterList.isEmpty()) {
                VirtualServiceRequest mockTransferActual;
                String operationId = this.getOperationId(mockTransferInput.getMethod(), this.getResourceParent(), resouceSplitterList);
                Map<String, VirtualServiceRequest> request = this.getMockLoadChoice().get(mockTransferInput.getResource());
                if (request != null && (mockTransferActual = request.get(operationId)) != null) {
                    inputType = mockTransferActual.getInputObjectType();
                }
            }
        }
        return inputType;
    }

    default public Map<String, VirtualServiceApiResponse> buildOpenAPIResponseType(Method method) {
        HashMap<String, VirtualServiceApiResponse> responseType = new HashMap<String, VirtualServiceApiResponse>();
        ApiResponses[] apiResponsesAnno = (ApiResponses[])method.getAnnotationsByType(ApiResponses.class);
        if (apiResponsesAnno != null) {
            for (ApiResponses apiResponses : apiResponsesAnno) {
                for (ApiResponse apiResponse : apiResponses.value()) {
                    try {
                        if (responseType.containsKey(String.valueOf(apiResponse.responseCode()))) continue;
                        responseType.put(String.valueOf(apiResponse.responseCode()), new VirtualServiceApiResponse(String.valueOf(apiResponse.responseCode()), null, null, apiResponse.description()));
                    }
                    catch (Exception e) {
                        responseType.put(String.valueOf(apiResponse.responseCode()), new VirtualServiceApiResponse(String.valueOf(apiResponse.responseCode()), null, null, apiResponse.description()));
                    }
                }
            }
        }
        return responseType;
    }

    default public String getOperationId(String httpVerb, ResourceMapper resourceParent, List<String> resouceSplitterList) {
        if ((resouceSplitterList == null || resouceSplitterList.isEmpty()) && resourceParent != null) {
            return resourceParent.getOperationId(httpVerb);
        }
        if (resourceParent != null && resouceSplitterList.size() > 0) {
            String resource = resouceSplitterList.get(0);
            ResourceMapper mapper = resourceParent.findResource(resource);
            if (mapper != null) {
                return this.getOperationId(httpVerb, mapper, resouceSplitterList.subList(1, resouceSplitterList.size()));
            }
            return this.getOperationId(httpVerb, resourceParent.findResource("Curly"), resouceSplitterList.subList(1, resouceSplitterList.size()));
        }
        return null;
    }

    default public VirtualServiceRequest getResponseType(VirtualServiceRequest mockTransferInput) {
        if (mockTransferInput != null && mockTransferInput.getUrl() != null) {
            int index;
            int n = index = mockTransferInput.getUrl().indexOf(47, 1) == -1 ? mockTransferInput.getUrl().length() : mockTransferInput.getUrl().indexOf(47, 1);
            if (mockTransferInput.getResource() == null) {
                mockTransferInput.setResource(mockTransferInput.getUrl().substring(1, index));
            }
        }
        if (mockTransferInput != null && mockTransferInput.getOperationId() != null && this.getMockLoadChoice().get(mockTransferInput.getResource()) != null) {
            return this.getMockLoadChoice().get(mockTransferInput.getResource()).get(mockTransferInput.getOperationId());
        }
        return null;
    }

    default public Map<String, String> getHttpStatusMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (HttpStatus status : HttpStatus.values()) {
            map.put(String.valueOf(status.value()), status.name());
        }
        return map;
    }

    default public ResourceMapper loadMapper() {
        LinkedHashSet<ResourceMapper> resourceMapperList = new LinkedHashSet<ResourceMapper>();
        ResourceMapper resourceParent = new ResourceMapper("Parent-Root", resourceMapperList);
        for (Map.Entry<String, Map<String, VirtualServiceRequest>> obj : VirtualanConfiguration.getVirtualServiceRequestMap().entrySet()) {
            for (Map.Entry<String, VirtualServiceRequest> requestMockObject : obj.getValue().entrySet()) {
                String resource = requestMockObject.getValue().getUrl().substring(1);
                LinkedList<String> resouceSplitterList = new LinkedList<String>(Arrays.asList(resource.split("/")));
                if (resouceSplitterList.isEmpty()) continue;
                ResourceMapper mapperChild = this.buildHierarchyObject(requestMockObject.getValue().getMethod(), resourceParent, resouceSplitterList, requestMockObject.getKey());
                resourceParent.addResourceMapper(mapperChild);
            }
        }
        return resourceParent;
    }

    default public ResourceMapper buildHierarchyObject(String httpVerb, ResourceMapper resourceParent, List<String> resouceSplitterList, String operationId) {
        String resource = resouceSplitterList.get(0);
        String actualResource = resouceSplitterList.get(0);
        Matcher matcher = VirtualServiceConstants.pattern.matcher(resouceSplitterList.get(0));
        if (matcher.find()) {
            resource = "Curly";
        }
        if (resouceSplitterList.size() == 1) {
            ResourceMapper resourceMapper = resourceParent.findResource(resource);
            if (resourceMapper == null) {
                resourceMapper = new ResourceMapper(resource);
                resourceMapper.setActualResource(actualResource);
            }
            resourceMapper.setOperationId(httpVerb, operationId);
            return resourceMapper;
        }
        if (resourceParent.findResource(resource) != null) {
            ResourceMapper resourceChild = resourceParent.findResource(resource);
            ResourceMapper resourceMapperReturn = this.buildHierarchyObject(httpVerb, resourceChild, resouceSplitterList.subList(1, resouceSplitterList.size()), operationId);
            resourceChild.addResourceMapper(resourceMapperReturn);
            return resourceChild;
        }
        LinkedHashSet<ResourceMapper> mapperSet = new LinkedHashSet<ResourceMapper>();
        ResourceMapper resourceMapper = new ResourceMapper(resource, mapperSet);
        resourceMapper.setActualResource(actualResource);
        ResourceMapper resourceMapperReturn = this.buildHierarchyObject(httpVerb, resourceMapper, resouceSplitterList.subList(1, resouceSplitterList.size()), operationId);
        resourceMapper.addResourceMapper(resourceMapperReturn);
        return resourceMapper;
    }

    default public Map<String, VirtualServiceApiResponse> buildResponseType(Method method) throws JsonProcessingException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Map<String, VirtualServiceApiResponse> responseType = this.buildOpenAPIResponseType(method);
        if (responseType == null || responseType.isEmpty()) {
            responseType = new HashMap<String, VirtualServiceApiResponse>();
            String defaultResponse = "Default";
            if (method.getGenericReturnType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
                for (Type type : parameterizedType.getActualTypeArguments()) {
                    try {
                        responseType.put(defaultResponse, new VirtualServiceApiResponse(defaultResponse, type.getTypeName(), this.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(new EasyRandom().nextObject(type.getClass())), null));
                    }
                    catch (Exception e) {
                        responseType.put(defaultResponse, new VirtualServiceApiResponse(defaultResponse, null, null, null));
                    }
                }
            }
        }
        return responseType;
    }

    default public VirtualServiceRequest buildServiceDetails(boolean scriptEnabled, Map.Entry<String, Class> virtualServiceEntry, Method method) throws JsonProcessingException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String rootResource = ApiResource.getResourceParent(virtualServiceEntry.getValue());
        VirtualServiceRequest virtualServiceRequest = new VirtualServiceRequest();
        virtualServiceRequest.setDesc(this.getResourceDesc(method));
        virtualServiceRequest.setResponseType(this.buildResponseType(method));
        virtualServiceRequest.setOperationId(method.getName());
        virtualServiceRequest.setTypes(this.getTypes(scriptEnabled));
        virtualServiceRequest.setHttpStatusMap(this.getHttpStatusMap());
        VirtualServiceKeyValue virtualServiceKeyValue = ApiMethod.getApiMethodParamAndURL(method);
        if (rootResource != null) {
            virtualServiceRequest.setUrl("/" + rootResource + virtualServiceKeyValue.getValue());
            virtualServiceRequest.setResource(rootResource);
        } else {
            virtualServiceRequest.setUrl(virtualServiceKeyValue.getValue());
            virtualServiceRequest.setResource(ApiResource.getResourceByURL(virtualServiceKeyValue.getValue()));
        }
        virtualServiceRequest.setMethod(virtualServiceKeyValue.getKey());
        this.buildInput(method, virtualServiceRequest);
        return virtualServiceRequest;
    }

    public static final class LogHolder {
        private static final Logger log = LoggerFactory.getLogger(LogHolder.class);
    }
}

