/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.controller;

import io.virtualan.core.VirtualParameterizedUtil;
import io.virtualan.core.VirtualServiceUtil;
import io.virtualan.core.model.RequestType;
import io.virtualan.core.model.ResponseParam;
import io.virtualan.core.model.ResponseProcessType;
import io.virtualan.core.model.SoapService;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.model.VirtualServiceStatus;
import io.virtualan.core.soap.WSEndpointConfiguration;
import io.virtualan.core.util.Converter;
import io.virtualan.message.core.MessageUtil;
import io.virtualan.service.VirtualService;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="virtualSoapController")
public class VirtualSoapController {
    private static final Logger log = LoggerFactory.getLogger(VirtualSoapController.class);
    Locale locale = LocaleContextHolder.getLocale();
    @Autowired
    private MessageUtil messageUtil;
    @Value(value="${virtualan.script.enabled:false}")
    private boolean scriptEnabled;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private VirtualParameterizedUtil virtualParameterizedUtil;
    @Autowired
    private Converter converter;
    @Autowired
    private VirtualService virtualService;
    @Autowired
    private VirtualServiceUtil virtualServiceUtil;
    @Autowired(required=false)
    private WSEndpointConfiguration wsEndpointConfiguration;

    public ResponseEntity checkIfServiceDataAlreadyExists(VirtualServiceRequest virtualServiceRequest) throws JAXBException, IOException {
        if ("PARAMS".equalsIgnoreCase(virtualServiceRequest.getType())) {
            Map<Integer, ResponseParam> response = this.virtualParameterizedUtil.handleParameterizedRequest(virtualServiceRequest);
            if (!response.isEmpty()) {
                VirtualServiceStatus virtualServiceStatus = new VirtualServiceStatus(this.messageSource.getMessage("VS_PARAMS_DATA_ALREADY_EXISTS", null, this.locale));
                virtualServiceRequest = this.converter.convertAsJson(virtualServiceRequest);
                virtualServiceStatus.setVirtualServiceRequest(virtualServiceRequest);
                virtualServiceStatus.setResponseParam(response);
                return new ResponseEntity((Object)virtualServiceStatus, HttpStatus.BAD_REQUEST);
            }
        } else {
            Long id = this.messageUtil.isMockAlreadyExists(virtualServiceRequest);
            if (id != null && id != 0L) {
                VirtualServiceStatus virtualServiceStatus = new VirtualServiceStatus(this.messageSource.getMessage("VS_DATA_ALREADY_EXISTS", null, this.locale));
                virtualServiceRequest.setId(id);
                virtualServiceStatus.setVirtualServiceRequest(virtualServiceRequest);
                return new ResponseEntity((Object)virtualServiceStatus, HttpStatus.BAD_REQUEST);
            }
        }
        return null;
    }

    @GetMapping(value={"/virtualservices/soap/services"})
    public ResponseEntity<Map<String, List<SoapService>>> listAvailableSoapService() {
        if (this.wsEndpointConfiguration == null) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        Map<String, SoapService> soapServiceMap = this.wsEndpointConfiguration.getWsServiceMockList();
        if (soapServiceMap != null && !soapServiceMap.isEmpty()) {
            Map<String, List<SoapService>> soapServicesByNs = soapServiceMap.values().stream().sorted(Comparator.comparing(SoapService::getMethod)).map(x -> {
                x.setTypes(VirtualSoapController.getTypes(this.scriptEnabled));
                return x;
            }).collect(Collectors.groupingBy(SoapService::getNs));
            return new ResponseEntity(soapServicesByNs, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private static Map<String, String> getTypes(boolean scriptEnabled) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("RESPONSE", "Response");
        map.put("PARAMS", "Params");
        if (scriptEnabled) {
            map.put("RULE", "Rule");
            map.put("SCRIPT", "Script");
        }
        return map;
    }

    @DeleteMapping(value={"/virtualservices/soap/{id}"})
    public ResponseEntity<VirtualServiceRequest> deleteMockRequest(@PathVariable(value="id") long id) {
        VirtualServiceRequest mockLoadRequest = this.virtualService.findById(id);
        if (mockLoadRequest == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.virtualService.deleteMockRequestById(id);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/virtualservices/soap"})
    public ResponseEntity<List<VirtualServiceRequest>> listAllMockMessageLoadRequests() {
        List<VirtualServiceRequest> mockLoadRequests = this.virtualService.findAllMockRequests();
        List mockRestLoadRequests = mockLoadRequests.stream().filter(x -> RequestType.SOAP.toString().equalsIgnoreCase(x.getRequestType()) || x.getRequestType() == null).map(x -> {
            x.setTypes(VirtualSoapController.getTypes(this.scriptEnabled));
            return x;
        }).collect(Collectors.toList());
        if (mockRestLoadRequests.isEmpty()) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(mockRestLoadRequests, HttpStatus.OK);
    }

    @PostMapping(value={"/virtualservices/soap"})
    public ResponseEntity createMockRequest(@RequestBody VirtualServiceRequest virtualServiceRequest) {
        try {
            if (!this.scriptEnabled && virtualServiceRequest.getType() != null && (ResponseProcessType.SCRIPT.toString().equalsIgnoreCase(virtualServiceRequest.getType().toString()) || ResponseProcessType.RULE.toString().equalsIgnoreCase(virtualServiceRequest.getType().toString()))) {
                return new ResponseEntity((Object)("{\"message\":\"" + this.messageSource.getMessage("VS_VALIDATION_FAILURE_REJECT", null, this.locale) + "\"}"), null, HttpStatus.BAD_REQUEST);
            }
            if (virtualServiceRequest.getType() == null) {
                virtualServiceRequest.setType(ResponseProcessType.RESPONSE.toString());
            }
            this.wsEndpointConfiguration.getWsServiceMockList().entrySet().stream().filter(x -> ((SoapService)x.getValue()).getMethod().equalsIgnoreCase(virtualServiceRequest.getMethod()) && ((SoapService)x.getValue()).getNs().equalsIgnoreCase(virtualServiceRequest.getUrl())).forEach(y -> {
                try {
                    Class<?> reqClazzz = Class.forName(((SoapService)y.getValue()).getRequestClassName());
                    virtualServiceRequest.setInputObjectType(reqClazzz);
                    Class<?> resClazzz = Class.forName(((SoapService)y.getValue()).getResponseClassName());
                    virtualServiceRequest.setResponseObjectType(resClazzz);
                }
                catch (ClassNotFoundException e) {
                    log.warn("return Class not found : {}", (Object)e.getMessage());
                }
            });
            if (virtualServiceRequest.getResource() == null) {
                virtualServiceRequest.setResource(virtualServiceRequest.getUrl());
            }
            virtualServiceRequest.setRequestType(RequestType.SOAP.toString());
            ResponseEntity responseEntity = this.checkIfServiceDataAlreadyExists(virtualServiceRequest);
            if (responseEntity != null) {
                return responseEntity;
            }
            VirtualServiceRequest mockTransferObject = this.virtualService.saveMockRequest(virtualServiceRequest);
            mockTransferObject.setMockStatus(new VirtualServiceStatus(this.messageSource.getMessage("VS_SUCCESS", null, this.locale)));
            return new ResponseEntity((Object)mockTransferObject, HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage("VS_UNEXPECTED_ERROR", null, this.locale) + e.getMessage()), HttpStatus.BAD_REQUEST);
        }
    }
}

