/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.api;

import io.virtualan.annotation.VirtualService;
import io.virtualan.api.ApiMethod;
import io.virtualan.api.VirtualServiceType;
import io.virtualan.core.model.VirtualServiceKeyValue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;

@Component
public class ApiType {
    private static final Logger log = LoggerFactory.getLogger(ApiType.class);

    private ApiType() {
    }

    private static VirtualServiceType getType(Class clazz) {
        if (clazz.isAnnotationPresent(RequestMapping.class)) {
            return VirtualServiceType.SPRING;
        }
        if (clazz.isAnnotationPresent(Path.class)) {
            return VirtualServiceType.CXF_JAX_RS;
        }
        return null;
    }

    public static VirtualServiceType findApiType() {
        try {
            Field f = ClassLoader.class.getDeclaredField("classes");
            f.setAccessible(true);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            List classes = (List)f.get(classLoader);
            for (int i = 0; i < classes.size(); ++i) {
                Class classzz = (Class)classes.get(i);
                VirtualServiceType type = ApiType.getVirtualServiceType(classzz);
                if (type == null) continue;
                return type;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            log.error("Unable to load from the class loader " + e1.getMessage());
        }
        log.error("Unable to find Api Type: Service would not meet the Virtualan required criteria!!! ");
        return null;
    }

    public static VirtualServiceType getVirtualServiceType(Class classzz) {
        try {
            VirtualServiceType type = ApiType.getApiType(classzz);
            if (type != null) {
                return type;
            }
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        return null;
    }

    public static VirtualServiceType getApiType(Class classzz) {
        if (classzz.isAnnotationPresent(VirtualService.class)) {
            VirtualServiceType apiType = ApiType.getType(classzz);
            if (apiType == null) {
                for (Method method : classzz.getDeclaredMethods()) {
                    VirtualServiceKeyValue virtualServiceKeyValue = ApiMethod.getApiMethodParamAndURL(method);
                    if (virtualServiceKeyValue == null || virtualServiceKeyValue.getServiceType() == null) continue;
                    log.info(" Virtualan Api Type would be : " + virtualServiceKeyValue.getServiceType().getType());
                    return virtualServiceKeyValue.getServiceType();
                }
            } else {
                log.info(" Virtualan Api Type would be : " + apiType.getType());
                return apiType;
            }
        }
        return null;
    }

    public static List<String> findApis() {
        ArrayList<String> apis = new ArrayList<String>();
        try {
            Field f = ClassLoader.class.getDeclaredField("classes");
            f.setAccessible(true);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            List classes = (List)f.get(classLoader);
            ApiType.addApis(apis, classes);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            log.error("Unable to load from the class loader " + e1.getMessage());
        }
        log.error("Unable to find Api Type: Service would not meet the Virtualan required criteria!!! ");
        return apis;
    }

    public static void addApis(List<String> apis, List<Class> classes) {
        for (int i = 0; i < classes.size(); ++i) {
            Class classzz = classes.get(i);
            try {
                if (!classzz.isAnnotationPresent(VirtualService.class)) continue;
                apis.add(classzz.getPackage().getName());
                continue;
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
    }
}

