/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.message.core.jms;

import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.util.ReturnMockResponse;
import io.virtualan.message.core.MessageObject;
import io.virtualan.message.core.MessageUtil;
import io.virtualan.message.core.jms.JMSMessageSender;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.stereotype.Service;

@ConditionalOnResource(resources={"classpath:conf/jms-config.json"})
@Service
public class JMSListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(JMSListener.class);
    @Autowired
    private MessageUtil messageUtil;

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            try {
                String text = ((TextMessage)message).getText();
                MessageObject messageObject = new MessageObject();
                messageObject.setJsonObject((JSONObject)new JSONTokener(text).nextValue());
                VirtualServiceRequest virtualServiceRequest = new VirtualServiceRequest();
                virtualServiceRequest.setInput(messageObject.getJsonObject().toString());
                String inputTopic = message.getJMSDestination().toString();
                messageObject.setInboundTopic(inputTopic.substring(inputTopic.indexOf(47) + 2));
                virtualServiceRequest.setOperationId(messageObject.getInboundTopic());
                virtualServiceRequest.setResource(messageObject.getInboundTopic());
                ReturnMockResponse response = this.messageUtil.getMatchingRecord(virtualServiceRequest);
                this.processMethod(messageObject, response);
            }
            catch (JSONException e) {
                log.error(" Invalid message : {}", (Object)e.getMessage());
            }
            catch (JMSException e) {
                log.error(" has error posting message : {} : {}", (Object)e.getErrorCode(), (Object)e.getMessage());
            }
            catch (Exception e) {
                log.error(" has error posting message : : {}", (Object)e.getMessage());
            }
        }
    }

    private void processMethod(MessageObject messageObject, ReturnMockResponse response) {
        if (response != null && response.getMockResponse() != null) {
            messageObject.setOutputMessage(response.getMockResponse().getOutput());
            messageObject.setOutboundTopic(response.getMockRequest().getMethod());
            if (messageObject.getOutputMessage() == null || messageObject.getOutboundTopic() == null) {
                log.info("No outputMessage response configured..");
            } else {
                log.info("Response configured.. with ({}) : {}", (Object)messageObject.getOutboundTopic(), (Object)messageObject.getOutputMessage());
                JMSMessageSender.sendMessage(messageObject.getInboundTopic(), messageObject.getOutboundTopic(), messageObject.getOutputMessage());
            }
        } else {
            log.info("No response configured for the given input");
        }
    }
}

