/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.message.core;

import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.util.ReturnMockResponse;
import io.virtualan.message.core.MessageObject;
import io.virtualan.message.core.MessageUtil;
import io.virtualan.message.core.MessagingApplication;
import io.virtualan.message.core.Mqtt;
import io.virtualan.message.core.jms.JMSMessageSender;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.annotation.Transformer;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.integration.mqtt.inbound.MqttPahoMessageDrivenChannelAdapter;
import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.integration.transformer.GenericTransformer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.stereotype.Service;

@ConditionalOnResource(resources={"classpath:conf/mqtt-config.json"})
@Service(value="mqttService")
public class MqttService {
    private static final Logger log = LoggerFactory.getLogger(MqttService.class);
    private String[] brokerUrl;
    private String[] topics;
    private String MQTT_USERNAME;
    private String MQTT_PASSWORD;
    private int COMPLETION_TIMEOUT = 5000;
    private int QOS = 2;
    private boolean retained = true;
    private boolean CLEAN_SESSION = true;
    private int CONNECTION_TIMEOUT = 30;
    private int KEEP_ALIVE_INTERVAL = 60;
    private boolean AUTOMATIC_RECONNECT = true;
    @Autowired
    private MessageUtil messageUtil;

    private JSONObject getMQTTConfiguration() throws IOException {
        InputStream stream = JMSMessageSender.class.getClassLoader().getResourceAsStream("conf/mqtt-config.json");
        String jmsConfigJson = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            jmsConfigJson = br.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return new JSONObject(jmsConfigJson).getJSONArray("MQTT").getJSONObject(0);
    }

    @PostConstruct
    public void init() throws IOException {
        try {
            JSONObject jmsConfigurations = this.getMQTTConfiguration();
            JSONArray brokerUrls = jmsConfigurations.getJSONArray("broker-url");
            if (brokerUrls.length() == 0) {
                log.error(" broker-url parameter is mandatory for MQTT");
                System.exit(0);
            }
            this.brokerUrl = new String[brokerUrls.length()];
            for (int i = 0; i < brokerUrls.length(); ++i) {
                this.brokerUrl[i] = brokerUrls.getString(i);
            }
            JSONArray arryTopics = jmsConfigurations.getJSONArray("receiver-queue");
            this.topics = new String[arryTopics.length()];
            for (int i = 0; i < arryTopics.length(); ++i) {
                this.topics[i] = arryTopics.getString(i);
            }
            if (jmsConfigurations.optString("username").length() > 0) {
                this.MQTT_USERNAME = jmsConfigurations.optString("username");
            }
            if (jmsConfigurations.optString("password").length() > 0) {
                this.MQTT_PASSWORD = jmsConfigurations.optString("password");
            }
            if (jmsConfigurations.optInt("qos") > 0) {
                this.QOS = jmsConfigurations.optInt("qos");
            }
            if (jmsConfigurations.optInt("completionTimeout") > 0) {
                this.COMPLETION_TIMEOUT = jmsConfigurations.optInt("completionTimeout");
            }
            if (!jmsConfigurations.optBoolean("cleanSession")) {
                this.CLEAN_SESSION = jmsConfigurations.optBoolean("cleanSession");
            }
            if (!jmsConfigurations.optBoolean("automaticReconnect")) {
                this.AUTOMATIC_RECONNECT = jmsConfigurations.optBoolean("automaticReconnect");
            }
            if (jmsConfigurations.optInt("connectionTimeout") > 0) {
                this.CONNECTION_TIMEOUT = jmsConfigurations.optInt("connectionTimeout");
            }
            if (jmsConfigurations.optInt("keepAliveInterval") > 0) {
                this.KEEP_ALIVE_INTERVAL = jmsConfigurations.optInt("keepAliveInterval");
            }
        }
        catch (Exception e) {
            log.warn("MQTT conf is not loaded {}", (Object)e.getMessage());
        }
    }

    private MqttConnectOptions connectOptions() {
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        if (this.MQTT_USERNAME != null) {
            mqttConnectOptions.setUserName(this.MQTT_USERNAME);
        }
        if (this.MQTT_PASSWORD != null) {
            mqttConnectOptions.setPassword(this.MQTT_PASSWORD.toCharArray());
        }
        mqttConnectOptions.setCleanSession(this.CLEAN_SESSION);
        mqttConnectOptions.setConnectionTimeout(this.CONNECTION_TIMEOUT);
        mqttConnectOptions.setKeepAliveInterval(this.KEEP_ALIVE_INTERVAL);
        mqttConnectOptions.setAutomaticReconnect(this.AUTOMATIC_RECONNECT);
        mqttConnectOptions.setServerURIs(this.brokerUrl);
        return mqttConnectOptions;
    }

    DefaultMqttPahoClientFactory defaultMqttPahoClientFactory() {
        DefaultMqttPahoClientFactory clientFactory = new DefaultMqttPahoClientFactory();
        clientFactory.setConnectionOptions(this.connectOptions());
        return clientFactory;
    }

    public MqttPahoMessageDrivenChannelAdapter mqttPahoMessageDrivenChannelAdapter() {
        MqttPahoMessageDrivenChannelAdapter mqttPahoMessageDrivenChannelAdapter = new MqttPahoMessageDrivenChannelAdapter(this.brokerUrl[0], UUID.randomUUID().toString(), (MqttPahoClientFactory)this.defaultMqttPahoClientFactory(), this.topics);
        mqttPahoMessageDrivenChannelAdapter.setCompletionTimeout((long)this.COMPLETION_TIMEOUT);
        mqttPahoMessageDrivenChannelAdapter.setConverter((MqttMessageConverter)new DefaultPahoMessageConverter());
        mqttPahoMessageDrivenChannelAdapter.setQos(new int[]{this.QOS});
        return mqttPahoMessageDrivenChannelAdapter;
    }

    @Transformer
    public MessageObject parse(Message<?> message) {
        MessageObject messageObject = new MessageObject();
        try {
            messageObject.setJsonObject((JSONObject)new JSONTokener(message.getPayload().toString()).nextValue());
            messageObject.setInboundTopic(message.getHeaders().get((Object)"mqtt_receivedTopic").toString());
            messageObject.setHeaders(message.getHeaders());
            return messageObject;
        }
        catch (JSONException e) {
            log.warn("parse {}", e.getCause());
            return messageObject;
        }
    }

    private DirectChannel sentToTransformer() {
        return new DirectChannel();
    }

    public GenericTransformer<Message<?>, MessageObject> transformer() {
        return new GenericTransformer<Message<?>, MessageObject>(){

            public MessageObject transform(Message<?> message) {
                return MqttService.this.parse(message);
            }
        };
    }

    @Bean
    private MessagingApplication.ResponseMessage getResponseMessage() {
        return messageObject -> {
            if (messageObject.getJsonObject() != null) {
                VirtualServiceRequest virtualServiceRequest = new VirtualServiceRequest();
                virtualServiceRequest.setInput(messageObject.getJsonObject().toString());
                virtualServiceRequest.setOperationId(messageObject.getInboundTopic());
                virtualServiceRequest.setResource(messageObject.getInboundTopic());
                ReturnMockResponse response = this.messageUtil.getMatchingRecord(virtualServiceRequest);
                if (response != null && response.getMockResponse() != null) {
                    messageObject.setOutputMessage(response.getMockResponse().getOutput());
                    messageObject.setOutboundTopic(response.getMockRequest().getMethod());
                    if (messageObject.getOutputMessage() == null || messageObject.getOutboundTopic() == null) {
                        log.info("No outputMessage response configured..");
                        return null;
                    }
                    log.info("Response configured.. with ({}) : {}", (Object)messageObject.getOutboundTopic(), (Object)messageObject.getOutputMessage());
                    return messageObject;
                }
            }
            log.info("No response configured for the given input");
            return null;
        };
    }

    @Bean
    private MessagingApplication.SendMessage postMessage() {
        return messageObject -> {
            if (messageObject.getOutboundTopic() != null) {
                MqttMessage mqttMessage = new MqttMessage();
                mqttMessage.setPayload(messageObject.getOutputMessage().getBytes());
                mqttMessage.setQos(this.QOS);
                mqttMessage.setRetained(this.retained);
                Mqtt.getInstance(UUID.randomUUID().toString(), this.brokerUrl[0], this.connectOptions()).publish(messageObject.getOutboundTopic(), mqttMessage);
            }
            return null;
        };
    }

    @Bean
    public IntegrationFlow mqttInbound() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((MessageProducerSupport)this.mqttPahoMessageDrivenChannelAdapter()).channel((MessageChannel)this.sentToTransformer())).transform(this.transformer())).handle((Object)this.getResponseMessage())).handle((Object)this.postMessage())).get();
    }
}

