/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.virtualan.annotation.VirtualService;
import io.virtualan.autoconfig.ApplicationContextProvider;
import io.virtualan.core.VirtualServiceInfo;
import io.virtualan.core.VirtualServiceUtil;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.util.MyClassloader;
import io.virtualan.core.util.OpenApiGenerator;
import io.virtualan.core.util.VirtualanConfiguration;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.languages.SpringCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class OpenApiGeneratorUtil {
    @Value(value="${virtualan.script.enabled:false}")
    private boolean scriptEnabled;
    private static Logger logger = LoggerFactory.getLogger(OpenApiGeneratorUtil.class);
    private File srcFolder = VirtualanConfiguration.getSrcPath();
    private File dependencyFolder = VirtualanConfiguration.getDependencyPath();
    private File yamlFolder = VirtualanConfiguration.getYamlPath();
    @Autowired
    private ApplicationContextProvider applicationContext;
    @Autowired
    private ApplicationContext appContext;
    @Autowired
    private VirtualServiceUtil virtualServiceUtil;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    private static void deleteFolder(File file) {
        if (file != null && file.listFiles().length > 0) {
            for (File subFile : file.listFiles()) {
                if (subFile.isDirectory()) {
                    OpenApiGeneratorUtil.deleteFolder(subFile);
                    subFile.delete();
                    continue;
                }
                subFile.delete();
            }
        }
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void loadInitialYamlFiles() throws MalformedURLException, IntrospectionException {
        File file = VirtualanConfiguration.getYamlPath();
        this.getYaml(file);
    }

    public void getYaml(File file) {
        if (file != null && file.listFiles() != null && file.listFiles().length > 0) {
            for (File subFile : file.listFiles()) {
                if (subFile.isDirectory()) {
                    this.getYaml(subFile);
                    continue;
                }
                try {
                    this.generateRestApi(this.scriptEnabled, subFile.getName(), null, this.appContext.getClassLoader());
                }
                catch (Exception e) {
                    logger.warn("Unable to process : " + e.getMessage());
                }
            }
        }
    }

    private void compile(File src, File dest) throws IOException {
        File[] listOfFiles;
        StringBuilder sb = new StringBuilder();
        for (File file : listOfFiles = this.dependencyFolder.listFiles()) {
            if (!file.isFile()) continue;
            sb.append(file.getAbsoluteFile()).append(":");
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, StandardCharsets.UTF_8);
        List<File> fileList = Arrays.asList(dest);
        fileManager.setLocation(StandardLocation.CLASS_PATH, Arrays.asList(listOfFiles));
        fileManager.setLocation(StandardLocation.CLASS_OUTPUT, fileList);
        Collection allFiles = FileUtils.listFiles((File)src, (String[])new String[]{"java"}, (boolean)true);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(allFiles);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, compilationUnits);
        boolean status = task.call();
        if (!status) {
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                logger.warn("Error on line {} in {}" + diagnostic.getLineNumber() + diagnostic);
            }
        }
        fileManager.close();
    }

    private void collectFiles(File file, List<String> list, String fileName) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.collectFiles(child, list, fileName);
            }
        } else if (file.getName().endsWith(fileName)) {
            list.add(file.getAbsolutePath());
        }
    }

    private void openApiGenerator(String apiFile, VirtualServiceRequest request) throws IOException {
        OpenAPI openAPI = null;
        String fileName = null;
        if (apiFile != null) {
            fileName = apiFile.substring(0, apiFile.lastIndexOf("."));
            openAPI = new OpenAPIParser().readLocation(this.yamlFolder.getAbsolutePath() + File.separator + fileName + File.separator + apiFile, null, new ParseOptions()).getOpenAPI();
        } else {
            openAPI = OpenApiGenerator.generateAPI(request);
            fileName = OpenApiGenerator.getResource(request);
        }
        File newFile = new File(this.srcFolder.getAbsolutePath() + File.separator + fileName);
        if (!newFile.exists()) {
            newFile.mkdir();
        } else {
            OpenApiGeneratorUtil.deleteFolder(newFile);
        }
        SpringCodegen codegen = new SpringCodegen();
        codegen.setOutputDir(newFile.getAbsolutePath());
        ClientOptInput input = new ClientOptInput();
        DefaultGenerator generator = new DefaultGenerator();
        generator.setGeneratorPropertyDefault("models", "true");
        generator.setGeneratorPropertyDefault("modelTests", "false");
        generator.setGeneratorPropertyDefault("modelDocs", "false");
        generator.setGeneratorPropertyDefault("apis", "true");
        generator.setGeneratorPropertyDefault("supportingFiles", "true");
        Random rand = new Random();
        int upperbound = 5000;
        int int_random = rand.nextInt(upperbound);
        codegen.setApiPackage("io.virtualan.api." + fileName + int_random);
        codegen.setModelPackage("io.virtualan.model." + fileName + int_random);
        codegen.additionalProperties().put("virtualService", true);
        codegen.additionalProperties().put("java8", true);
        codegen.additionalProperties().put("skipDefaultInterface", false);
        GlobalSettings.setProperty((String)"supportingFiles", (String)"ApiUtil.java");
        input.openAPI(openAPI);
        input.config((CodegenConfig)codegen);
        generator.opts(input).generate();
    }

    public Map<String, Map<String, VirtualServiceRequest>> removeRestApi(boolean scriptEnabled, String yamlFile, VirtualServiceRequest request, ClassLoader contextLoader) throws Exception {
        ArrayList<String> beans = new ArrayList<String>();
        try {
            ArrayList<String> fileNames = new ArrayList<String>();
            ArrayList<String> fileNameAll = new ArrayList<String>();
            File destFile = null;
            destFile = new File(VirtualanConfiguration.getDestPath().getAbsolutePath() + File.separator + yamlFile);
            MyClassloader myClassloader = new MyClassloader(new URL[]{destFile.toURI().toURL()}, this.applicationContext.getClassLoader().getParent());
            this.applicationContext.classLoader(myClassloader);
            if (destFile.exists()) {
                this.collectFiles(destFile, fileNameAll, ".class");
                this.collectFiles(VirtualanConfiguration.getDestPath(), fileNames, ".class");
                for (String classNameRaw : fileNames) {
                    String className = classNameRaw.replace(VirtualanConfiguration.getDestPath().getAbsolutePath(), "");
                    className = className.substring(className.indexOf(File.separator, 1) + 1);
                    className = className.replaceAll("/", ".");
                    className = className.replaceAll("\\\\", ".");
                    className = className.substring(0, className.lastIndexOf("."));
                    Object name = className;
                    name = ((String)name).substring(((String)name).lastIndexOf(46) + 1);
                    name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
                    Class<?> myController = this.applicationContext.getClassLoader().loadClass(className);
                    if (!fileNameAll.contains(classNameRaw) || !((String)name).endsWith("Controller")) continue;
                    GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                    beanDefinition.setBeanClass(myController);
                    beanDefinition.setAutowireCandidate(true);
                    beanDefinition.setLazyInit(false);
                    beanDefinition.setAbstract(false);
                    for (Class<?> classssss : myController.getInterfaces()) {
                        if (!classssss.isAnnotationPresent(VirtualService.class) || !this.applicationContext.containsBean((String)name)) continue;
                        this.removeMapping(classssss);
                        this.applicationContext.removeBean((String)name);
                        beans.add((String)name);
                    }
                }
                OpenApiGeneratorUtil.deleteFolder(destFile);
                destFile.delete();
                File srcFile = new File(VirtualanConfiguration.getSrcPath().getAbsolutePath() + File.separator + yamlFile);
                OpenApiGeneratorUtil.deleteFolder(srcFile);
                srcFile.delete();
                File yaml = new File(VirtualanConfiguration.getYamlPath().getAbsolutePath() + File.separator + yamlFile);
                OpenApiGeneratorUtil.deleteFolder(yaml);
                yaml.delete();
                return this.getActiveServices(scriptEnabled, beans);
            }
            throw new Exception("This resource does not exists");
        }
        catch (Exception e) {
            logger.warn("Unable to process :" + e.getMessage());
            this.getActiveServices(scriptEnabled, beans);
            if (e.getMessage() != null) {
                throw new Exception(e.getMessage());
            }
            throw new Exception("Unexpected error Check the logs");
        }
    }

    private Map<String, Map<String, VirtualServiceRequest>> getActiveServices(boolean scriptEnabled, List<String> list) throws ClassNotFoundException, JsonProcessingException, InstantiationException, IllegalAccessException {
        Map<String, Map<String, VirtualServiceRequest>> map = this.getVirtualServiceInfo().loadVirtualServices(scriptEnabled, this.applicationContext.getClassLoader().getParent());
        this.getVirtualServiceInfo().setResourceParent(this.getVirtualServiceInfo().loadMapper());
        HashMap<String, Map<String, VirtualServiceRequest>> response = new HashMap<String, Map<String, VirtualServiceRequest>>();
        for (String beans : list) {
            String bean = beans.replace("ApiController", "");
            if (!map.containsKey(bean)) continue;
            response.put(bean, map.get(bean));
        }
        map.entrySet().removeIf(entry -> !this.applicationContext.containsBean((String)entry.getKey() + "ApiController"));
        return response;
    }

    private Resource[] getCatalogList(String path) throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.applicationContext.getClassLoader().getParent().getParent());
        return resolver.getResources(path);
    }

    public Map<String, Map<String, VirtualServiceRequest>> generateRestApi(boolean scriptEnabled, String yamlFile, VirtualServiceRequest request, ClassLoader contextLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, JsonProcessingException {
        ArrayList<String> addedBeans = new ArrayList<String>();
        try {
            this.openApiGenerator(yamlFile, request);
            ArrayList<String> fileNames = new ArrayList<String>();
            ArrayList<String> fileNameAll = new ArrayList<String>();
            File destFile = null;
            File srcFile = null;
            if (yamlFile != null) {
                destFile = new File(VirtualanConfiguration.getDestPath().getAbsolutePath() + File.separator + yamlFile.substring(0, yamlFile.lastIndexOf(".")));
                srcFile = new File(VirtualanConfiguration.getSrcPath().getAbsolutePath() + File.separator + yamlFile.substring(0, yamlFile.lastIndexOf(".")));
            } else {
                destFile = new File(VirtualanConfiguration.getDestPath().getAbsolutePath() + File.separator + OpenApiGenerator.getResource(request));
                srcFile = new File(VirtualanConfiguration.getSrcPath().getAbsolutePath() + File.separator + OpenApiGenerator.getResource(request));
            }
            if (!destFile.exists()) {
                destFile.mkdir();
            } else {
                OpenApiGeneratorUtil.deleteFolder(destFile);
            }
            this.compile(srcFile, destFile);
            this.collectFiles(destFile, fileNameAll, ".class");
            this.collectFiles(destFile, fileNames, ".class");
            MyClassloader myClassloader = new MyClassloader(new URL[]{destFile.toURI().toURL()}, this.applicationContext.getClassLoader().getParent());
            this.applicationContext.classLoader(myClassloader);
            for (String classNameRaw : fileNames) {
                String className = classNameRaw.replace(VirtualanConfiguration.getDestPath().getAbsolutePath(), "");
                className = className.substring(className.indexOf(File.separator, 1) + 1);
                className = className.replaceAll("/", ".");
                className = className.replaceAll("\\\\", ".");
                className = className.substring(0, className.lastIndexOf("."));
                Object name = className;
                name = ((String)name).substring(((String)name).lastIndexOf(46) + 1);
                name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
                Class<?> myController = this.applicationContext.getClassLoader().loadClass(className);
                if (!fileNameAll.contains(classNameRaw) || !((String)name).endsWith("Controller")) continue;
                GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                beanDefinition.setBeanClass(myController);
                beanDefinition.setAutowireCandidate(true);
                beanDefinition.setLazyInit(false);
                beanDefinition.setAbstract(false);
                for (Class<?> classssss : myController.getInterfaces()) {
                    if (!classssss.isAnnotationPresent(VirtualService.class)) continue;
                    if (this.applicationContext.containsBean((String)name)) {
                        this.removeMapping(classssss);
                        this.applicationContext.removeBean((String)name);
                    }
                    this.applicationContext.addBean((String)name, beanDefinition);
                    this.addMapping((String)name, classssss);
                    addedBeans.add((String)name);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unable to process :" + e.getMessage());
        }
        return this.getActiveServices(scriptEnabled, addedBeans);
    }

    private void removeMapping(Class myControllerClzzz) throws IOException, ClassNotFoundException {
        for (Method method : myControllerClzzz.getDeclaredMethods()) {
            boolean isDelete;
            boolean isPut;
            boolean isGet;
            boolean isPost = method.isAnnotationPresent(PostMapping.class);
            if (isPost) {
                PostMapping annotation = method.getAnnotation(PostMapping.class);
                RequestMappingInfo.Builder requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{annotation.value()[0]}).methods(new RequestMethod[]{RequestMethod.POST});
                if (annotation.consumes().length > 0) {
                    requestMappingInfo = requestMappingInfo.consumes(new String[]{annotation.consumes()[0]});
                }
                if (annotation.produces().length > 0) {
                    requestMappingInfo = requestMappingInfo.produces(new String[]{annotation.produces()[0]});
                }
                this.requestMappingHandlerMapping.unregisterMapping((Object)requestMappingInfo.build());
                logger.info("Unregistered: " + requestMappingInfo.build());
            }
            if (isGet = method.isAnnotationPresent(GetMapping.class)) {
                GetMapping annotation = method.getAnnotation(GetMapping.class);
                RequestMappingInfo.Builder requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{annotation.value()[0]}).methods(new RequestMethod[]{RequestMethod.GET});
                if (annotation.produces().length > 0) {
                    requestMappingInfo = requestMappingInfo.produces(new String[]{annotation.produces()[0]});
                }
                this.requestMappingHandlerMapping.unregisterMapping((Object)requestMappingInfo.build());
                logger.info("Unregistered: " + requestMappingInfo.build());
            }
            if (isPut = method.isAnnotationPresent(PutMapping.class)) {
                PutMapping annotation = method.getAnnotation(PutMapping.class);
                RequestMappingInfo.Builder requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{annotation.value()[0]}).methods(new RequestMethod[]{RequestMethod.PUT});
                if (annotation.produces().length > 0) {
                    requestMappingInfo = requestMappingInfo.produces(new String[]{annotation.produces()[0]});
                }
                if (annotation.consumes().length > 0) {
                    requestMappingInfo = requestMappingInfo.consumes(new String[]{annotation.consumes()[0]});
                }
                this.requestMappingHandlerMapping.unregisterMapping((Object)requestMappingInfo.build());
                logger.info("Unregistered: " + requestMappingInfo.build());
            }
            if (!(isDelete = method.isAnnotationPresent(DeleteMapping.class))) continue;
            DeleteMapping annotation = method.getAnnotation(DeleteMapping.class);
            RequestMappingInfo.Builder requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{annotation.value()[0]}).methods(new RequestMethod[]{RequestMethod.DELETE});
            if (annotation.produces().length > 0) {
                requestMappingInfo = requestMappingInfo.produces(new String[]{annotation.produces()[0]});
            }
            this.requestMappingHandlerMapping.unregisterMapping((Object)requestMappingInfo.build());
            logger.info("Unregistered: " + requestMappingInfo.build());
        }
    }

    private void addMapping(String name, Class myControllerClzzz) throws IOException, ClassNotFoundException {
        for (Method method : myControllerClzzz.getDeclaredMethods()) {
            boolean isDelete;
            boolean isPut;
            boolean isGet;
            boolean isPost = method.isAnnotationPresent(PostMapping.class);
            if (isPost) {
                PostMapping annotation = method.getAnnotation(PostMapping.class);
                RequestMappingInfo.Builder requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{annotation.value()[0]}).methods(new RequestMethod[]{RequestMethod.POST});
                if (annotation.consumes().length > 0) {
                    requestMappingInfo = requestMappingInfo.consumes(new String[]{annotation.consumes()[0]});
                }
                if (annotation.produces().length > 0) {
                    requestMappingInfo = requestMappingInfo.produces(new String[]{annotation.produces()[0]});
                }
                this.requestMappingHandlerMapping.registerMapping(requestMappingInfo.build(), (Object)name, method);
                logger.info("Registered: " + requestMappingInfo.build().toString());
            }
            if (isGet = method.isAnnotationPresent(GetMapping.class)) {
                GetMapping annotation = method.getAnnotation(GetMapping.class);
                RequestMappingInfo.Builder requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{annotation.value()[0]}).methods(new RequestMethod[]{RequestMethod.GET});
                if (annotation.produces().length > 0) {
                    requestMappingInfo = requestMappingInfo.produces(new String[]{annotation.produces()[0]});
                }
                this.requestMappingHandlerMapping.registerMapping(requestMappingInfo.build(), (Object)name, method);
                logger.info("Registered: " + requestMappingInfo.build().toString());
            }
            if (isPut = method.isAnnotationPresent(PutMapping.class)) {
                PutMapping annotation = method.getAnnotation(PutMapping.class);
                RequestMappingInfo.Builder requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{annotation.value()[0]}).methods(new RequestMethod[]{RequestMethod.PUT});
                if (annotation.produces().length > 0) {
                    requestMappingInfo = requestMappingInfo.produces(new String[]{annotation.produces()[0]});
                }
                if (annotation.consumes().length > 0) {
                    requestMappingInfo = requestMappingInfo.consumes(new String[]{annotation.consumes()[0]});
                }
                this.requestMappingHandlerMapping.registerMapping(requestMappingInfo.build(), (Object)name, method);
                logger.info("Registered: " + requestMappingInfo.build().toString());
            }
            if (!(isDelete = method.isAnnotationPresent(DeleteMapping.class))) continue;
            DeleteMapping annotation = method.getAnnotation(DeleteMapping.class);
            RequestMappingInfo.Builder requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{annotation.value()[0]}).methods(new RequestMethod[]{RequestMethod.DELETE});
            if (annotation.produces().length > 0) {
                requestMappingInfo = requestMappingInfo.produces(new String[]{annotation.produces()[0]});
            }
            this.requestMappingHandlerMapping.registerMapping(requestMappingInfo.build(), (Object)name, method);
            logger.info("Registered: " + requestMappingInfo.build().toString());
        }
    }

    private String getName(Class classzz) {
        String interfaceName = classzz.getTypeName();
        interfaceName = interfaceName.substring(interfaceName.lastIndexOf(46) + 1);
        interfaceName = interfaceName.toLowerCase();
        return interfaceName;
    }

    private VirtualServiceInfo getVirtualServiceInfo() {
        return this.virtualServiceUtil.getVirtualServiceInfo();
    }
}

