/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.controller;

import com.cedarsoftware.util.io.JsonObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiParam;
import io.virtualan.autoconfig.ApplicationContextProvider;
import io.virtualan.core.InvalidMockResponseException;
import io.virtualan.core.VirtualParameterizedUtil;
import io.virtualan.core.VirtualServiceInfo;
import io.virtualan.core.VirtualServiceUtil;
import io.virtualan.core.model.MockResponse;
import io.virtualan.core.model.MockServiceRequest;
import io.virtualan.core.model.RequestType;
import io.virtualan.core.model.ResponseParam;
import io.virtualan.core.model.ResponseProcessType;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.model.VirtualServiceStatus;
import io.virtualan.core.util.Converter;
import io.virtualan.core.util.OpenApiGeneratorUtil;
import io.virtualan.core.util.VirtualanConfiguration;
import io.virtualan.core.util.rule.RuleEvaluator;
import io.virtualan.core.util.rule.ScriptExecutor;
import io.virtualan.requestbody.RequestBody;
import io.virtualan.requestbody.RequestBodyTypes;
import io.virtualan.service.VirtualService;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="virtualServiceController")
public class VirtualServiceController {
    private static final Logger log = LoggerFactory.getLogger(VirtualServiceController.class);
    public static final String VS_REQUEST_BODY_MISMATCH = "VS_REQUEST_BODY_MISMATCH";
    @Autowired
    private static ConfigurableApplicationContext context;
    Locale locale = LocaleContextHolder.getLocale();
    @Autowired
    private RuleEvaluator ruleEvaluator;
    @Autowired
    private ScriptExecutor scriptExecutor;
    @Autowired
    private Converter converter;
    @Autowired
    private VirtualService virtualService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private VirtualServiceUtil virtualServiceUtil;
    @Value(value="${virtualan.application.name:Mock Service}")
    private String applicationName;
    @Autowired
    private ApplicationContextProvider applicationContext;
    private File yamlFolder = VirtualanConfiguration.getYamlPath();
    @Autowired
    private OpenApiGeneratorUtil openApiGeneratorUtil;
    @Autowired
    private VirtualParameterizedUtil virtualParameterizedUtil;
    @Value(value="${virtualan.script.enabled:false}")
    private boolean scriptEnabled;

    private ObjectMapper getObjectMapper() {
        this.objectMapper.findAndRegisterModules();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return this.objectMapper.enable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    public VirtualService getVirtualService() {
        return this.virtualService;
    }

    public void setVirtualService(VirtualService virtualService) {
        this.virtualService = virtualService;
    }

    public VirtualServiceInfo getVirtualServiceInfo() {
        return this.virtualServiceUtil.getVirtualServiceInfo();
    }

    @GetMapping(value={"/virtualservices/app-name"})
    public String applicationName() {
        return "{\"appName\":\"" + this.applicationName + "\"}";
    }

    @GetMapping(value={"/virtualservices/load"})
    public Map<String, Map<String, VirtualServiceRequest>> listAllMockLoadRequest() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        return VirtualanConfiguration.getVirtualServiceRequestMap();
    }

    @GetMapping(value={"/virtualservices"})
    public ResponseEntity<List<VirtualServiceRequest>> listAllMockLoadRequests() {
        List<VirtualServiceRequest> mockRestLoadRequests = this.virtualService.findAllMockRequests();
        if (mockRestLoadRequests.isEmpty()) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        List response = mockRestLoadRequests.stream().map(x -> this.converter.convertAsJson((VirtualServiceRequest)x)).collect(Collectors.toList());
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @GetMapping(value={"/virtualservices/{id}"}, produces={"application/json"})
    public ResponseEntity<VirtualServiceRequest> getMockLoadRequest(@PathVariable(value="id") long id) {
        VirtualServiceRequest mockLoadRequest = this.virtualService.findById(id);
        if (mockLoadRequest == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        mockLoadRequest = this.converter.convertAsJson(mockLoadRequest);
        return new ResponseEntity((Object)mockLoadRequest, HttpStatus.OK);
    }

    @PostMapping(value={"/virtualservices/apis"})
    public ResponseEntity<Map<String, Map<String, VirtualServiceRequest>>> createVirtualanApis(@ApiParam(value="") @Valid @RequestPart(value="openApiUrl", required=true) MultipartFile openApiUrl, @ApiParam(value="Skip the  validation of yaml.", defaultValue="true") @Valid @RequestPart(value="skipValidation", required=false) String skipValidation) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String dataload = openApiUrl.getOriginalFilename();
        String fileName = dataload.substring(0, dataload.lastIndexOf("."));
        File newFile = new File(this.yamlFolder + File.separator + fileName);
        if (!newFile.exists()) {
            newFile.mkdir();
        }
        VirtualanConfiguration.writeYaml(newFile + File.separator + dataload, openApiUrl.getInputStream());
        return new ResponseEntity(this.openApiGeneratorUtil.generateRestApi(this.scriptEnabled, dataload, null, this.applicationContext.getClassLoader().getParent()), HttpStatus.OK);
    }

    @DeleteMapping(value={"/virtualservices/apis"})
    public ResponseEntity deleteVirtualanApis(@Valid @RequestParam(value="apiName", required=false) String apiName) throws Exception {
        return new ResponseEntity(this.openApiGeneratorUtil.removeRestApi(this.scriptEnabled, apiName, null, this.applicationContext.getClassLoader().getParent()), HttpStatus.OK);
    }

    @PostMapping(value={"/virtualservices"})
    public ResponseEntity createMockRequest(@org.springframework.web.bind.annotation.RequestBody VirtualServiceRequest virtualServiceRequest) {
        try {
            if (!this.scriptEnabled && virtualServiceRequest.getType() != null && (ResponseProcessType.SCRIPT.toString().equalsIgnoreCase(virtualServiceRequest.getType().toString()) || ResponseProcessType.RULE.toString().equalsIgnoreCase(virtualServiceRequest.getType().toString()))) {
                return new ResponseEntity((Object)("{\"message\":\"" + this.messageSource.getMessage("VS_VALIDATION_FAILURE_REJECT", null, this.locale) + "\"}"), null, HttpStatus.BAD_REQUEST);
            }
            if (virtualServiceRequest.getType() == null) {
                virtualServiceRequest.setType(ResponseProcessType.RESPONSE.toString());
            }
            this.converter.convertJsonAsString(virtualServiceRequest);
            virtualServiceRequest.setRequestType(RequestType.REST.toString());
            this.validateExpectedInput(virtualServiceRequest);
            this.virtualServiceUtil.findOperationIdForService(virtualServiceRequest);
            if ("PARAMS".equalsIgnoreCase(virtualServiceRequest.getType())) {
                Map<Integer, ResponseParam> response = this.virtualParameterizedUtil.handleParameterizedRequest(virtualServiceRequest);
                if (!response.isEmpty()) {
                    VirtualServiceStatus virtualServiceStatus = new VirtualServiceStatus(this.messageSource.getMessage("VS_PARAMS_DATA_ALREADY_EXISTS", null, this.locale));
                    virtualServiceRequest = this.converter.convertAsJson(virtualServiceRequest);
                    virtualServiceStatus.setVirtualServiceRequest(virtualServiceRequest);
                    virtualServiceStatus.setResponseParam(response);
                    return new ResponseEntity((Object)virtualServiceStatus, HttpStatus.BAD_REQUEST);
                }
            } else {
                ResponseEntity responseEntity = this.validateRequestBody(virtualServiceRequest);
                if (responseEntity != null) {
                    return responseEntity;
                }
                responseEntity = this.validateResponseBody(virtualServiceRequest);
                if (responseEntity != null) {
                    return responseEntity;
                }
                responseEntity = this.virtualServiceUtil.checkIfServiceDataAlreadyExists(virtualServiceRequest);
                if (responseEntity != null) {
                    return responseEntity;
                }
            }
            VirtualServiceRequest mockTransferObject = this.virtualService.saveMockRequest(virtualServiceRequest);
            mockTransferObject = this.converter.convertAsJson(mockTransferObject);
            mockTransferObject.setMockStatus(new VirtualServiceStatus(this.messageSource.getMessage("VS_SUCCESS", null, this.locale)));
            return new ResponseEntity((Object)mockTransferObject, HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage("VS_UNEXPECTED_ERROR", null, this.locale) + e.getMessage()), HttpStatus.BAD_REQUEST);
        }
    }

    private ResponseEntity validateResponseBody(VirtualServiceRequest mockLoadRequest) {
        try {
            this.virtualServiceUtil.isMockResponseBodyValid(mockLoadRequest);
        }
        catch (InvalidMockResponseException | NoSuchMessageException e) {
            return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage("VS_RESPONSE_BODY_MISMATCH", null, this.locale) + e.getMessage()), HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    private ResponseEntity validateRequestBody(VirtualServiceRequest virtualServiceRequest) {
        if (this.virtualServiceUtil.getVirtualServiceInfo() != null) {
            Class<JsonObject> inputObjectType = this.virtualServiceUtil.getVirtualServiceInfo().getInputType(virtualServiceRequest);
            if (virtualServiceRequest.getInput() != null && VirtualanConfiguration.isValidJson(virtualServiceRequest.getInput().toString()) && (inputObjectType == null || inputObjectType.isAssignableFrom(String.class))) {
                virtualServiceRequest.setInputObjectType(JsonObject.class);
                inputObjectType = JsonObject.class;
            }
            if (inputObjectType == null && (virtualServiceRequest.getInput() == null || virtualServiceRequest.getInput().toString().length() == 0)) {
                return null;
            }
            if (virtualServiceRequest.getInput() != null && virtualServiceRequest.getInput().toString().length() > 0 && inputObjectType != null) {
                return this.getResponseEntity(virtualServiceRequest, inputObjectType);
            }
        }
        return null;
    }

    private ResponseEntity getResponseEntity(VirtualServiceRequest virtualServiceRequest, Class inputObjectType) {
        RequestBody requestBody = new RequestBody();
        requestBody.setObjectMapper(this.getObjectMapper());
        requestBody.setInputRequest(virtualServiceRequest.getInput().toString());
        requestBody.setInputObjectType(inputObjectType);
        Object object = this.getInputObject(inputObjectType, requestBody);
        if (object == null) {
            return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage(VS_REQUEST_BODY_MISMATCH, null, this.locale)), HttpStatus.BAD_REQUEST);
        }
        if ("RULE".equalsIgnoreCase(virtualServiceRequest.getType())) {
            return this.getRuleEntity(virtualServiceRequest, inputObjectType, requestBody);
        }
        if ("SCRIPT".equalsIgnoreCase(virtualServiceRequest.getType())) {
            return this.getScriptResponseEntity(virtualServiceRequest, inputObjectType, requestBody);
        }
        return null;
    }

    private ResponseEntity getScriptResponseEntity(VirtualServiceRequest virtualServiceRequest, Class inputObjectType, RequestBody requestBody) {
        try {
            MockServiceRequest mockServiceRequest = new MockServiceRequest();
            Object inputObject = this.getInputObject(inputObjectType, requestBody);
            mockServiceRequest.setInput(inputObject);
            mockServiceRequest.setParams(Converter.converter(virtualServiceRequest.getAvailableParams()));
            MockResponse mockResponse = new MockResponse();
            mockResponse = this.scriptExecutor.executeScript(mockServiceRequest, mockResponse, virtualServiceRequest.getRule());
            if (mockResponse == null) {
                return new ResponseEntity((Object)new VirtualServiceStatus("Its not a valid mock response setup!!! Verify the script? ", this.messageSource.getMessage(VS_REQUEST_BODY_MISMATCH, null, this.locale)), HttpStatus.BAD_REQUEST);
            }
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new VirtualServiceStatus(e.getMessage(), this.messageSource.getMessage(VS_REQUEST_BODY_MISMATCH, null, this.locale)), HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    private ResponseEntity getRuleEntity(VirtualServiceRequest virtualServiceRequest, Class inputObjectType, RequestBody requestBody) {
        try {
            MockServiceRequest mockServiceRequest = new MockServiceRequest();
            Object object = this.getInputObject(inputObjectType, requestBody);
            mockServiceRequest.setInput(object);
            mockServiceRequest.setParams(Converter.converter(virtualServiceRequest.getAvailableParams()));
            this.ruleEvaluator.expressionEvaluatorForMockCreation(mockServiceRequest, virtualServiceRequest.getRule());
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new VirtualServiceStatus(e.getMessage(), this.messageSource.getMessage(VS_REQUEST_BODY_MISMATCH, null, this.locale)), HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    private Object getInputObject(Class inputObjectType, RequestBody requestBody) {
        Object object;
        try {
            object = RequestBodyTypes.fromString(inputObjectType.getTypeName()).getValidMockRequestBody(requestBody);
        }
        catch (IOException | NoSuchMessageException e) {
            object = null;
        }
        return object;
    }

    private ResponseEntity validateExpectedInput(VirtualServiceRequest mockLoadRequest) {
        if (mockLoadRequest.getHttpStatusCode() == null || mockLoadRequest.getMethod() == null || mockLoadRequest.getType() == null || mockLoadRequest.getUrl() == null) {
            return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage("VS_CREATE_MISSING_INFO", null, this.locale)), HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    @PutMapping(value={"/virtualservices/{id}"})
    public ResponseEntity<VirtualServiceRequest> updateMockRequest(@PathVariable(value="id") long id, @org.springframework.web.bind.annotation.RequestBody VirtualServiceRequest mockLoadRequest) throws ClassNotFoundException, InstantiationException, IllegalAccessException, JsonProcessingException {
        VirtualServiceRequest currentMockLoadRequest = this.virtualService.findById(id);
        if (currentMockLoadRequest == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.virtualServiceUtil.findOperationIdForService(mockLoadRequest);
        currentMockLoadRequest.setInput(mockLoadRequest.getInput());
        currentMockLoadRequest.setOutput(mockLoadRequest.getOutput());
        currentMockLoadRequest.setOperationId(mockLoadRequest.getOperationId());
        this.virtualService.updateMockRequest(currentMockLoadRequest);
        return new ResponseEntity((Object)currentMockLoadRequest, HttpStatus.OK);
    }

    @DeleteMapping(value={"/virtualservices/{id}"})
    public ResponseEntity<VirtualServiceRequest> deleteMockRequest(@PathVariable(value="id") long id) {
        VirtualServiceRequest mockLoadRequest = this.virtualService.findById(id);
        if (mockLoadRequest == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.virtualService.deleteMockRequestById(id);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/api-catalogs"})
    public ResponseEntity<List<String>> readCatalog() {
        HashSet<String> fileList = new HashSet<String>();
        List<String> lists = Arrays.asList("classpath:META-INF/resources/yaml/*", "classpath:META-INF/resources/wsdl/*", "classpath:yaml/*");
        for (String pathName : lists) {
            try {
                Resource[] resources;
                for (Resource file : resources = this.getCatalogList(pathName)) {
                    fileList.add(file.getFilename());
                }
            }
            catch (Exception e) {
                log.error("api-catalogs : {}", (Object)e.getMessage());
            }
        }
        if (fileList.isEmpty()) {
            log.error("Api-catalogs List was not available : ");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(new LinkedList(fileList.stream().sorted().collect(Collectors.toList())), HttpStatus.OK);
    }

    @GetMapping(value={"/api-catalogs/{name}"})
    public ResponseEntity<List<String>> readCatalog(@PathVariable(value="name") String name) {
        LinkedList<String> fileList = new LinkedList<String>();
        try {
            for (Resource file : this.getCatalogs(name)) {
                fileList.add(file.getFilename());
            }
        }
        catch (IOException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        if (fileList.isEmpty()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(fileList, HttpStatus.OK);
    }

    private Resource[] getCatalogs(String name) throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.applicationContext.getClassLoader().getParent().getParent());
        Resource[] resources = null;
        try {
            resources = resolver.getResources("classpath:META-INF/resources/**/" + name + "/*.*");
        }
        catch (Exception e) {
            resources = resolver.getResources("classpath:yaml/" + name + "/*.*");
        }
        return resources;
    }

    private Resource[] getCatalogList(String path) throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.applicationContext.getClassLoader().getParent().getParent());
        return resolver.getResources(path);
    }
}

