/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.autoconfig;

import io.virtualan.core.VirtualServiceInfoFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ServiceLocatorFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@EnableAsync
@ComponentScan(basePackages={"io.virtualan"})
@Order(value=-2147483648)
public class VirtualServiceConfig {
    @Value(value="${virtualan.task.pool.size:5}")
    private int poolSize;
    @Value(value="${virtualan.queue.capacity:10}")
    private int queueCapacity;

    @Bean
    public ServiceLocatorFactoryBean myFactoryServiceLocatorFactoryBean() {
        ServiceLocatorFactoryBean bean = new ServiceLocatorFactoryBean();
        bean.setServiceLocatorInterface(VirtualServiceInfoFactory.class);
        return bean;
    }

    @Bean(name={"asyncWorkExecutor"})
    public TaskExecutor taskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setMaxPoolSize(this.poolSize);
        taskExecutor.setQueueCapacity(this.queueCapacity);
        taskExecutor.setThreadNamePrefix("vUsage-");
        taskExecutor.afterPropertiesSet();
        return taskExecutor;
    }
}

