/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import io.virtualan.core.model.VirtualServiceRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualanConfiguration {
    private static final Logger log = LoggerFactory.getLogger(VirtualanConfiguration.class);
    private static Properties properties = new Properties();
    private static Map<String, Map<String, VirtualServiceRequest>> virtualServiceRequestMap;

    public static Map<String, Map<String, VirtualServiceRequest>> getVirtualServiceRequestMap() {
        return virtualServiceRequestMap;
    }

    public static void setVirtualServiceRequestMap(Map<String, Map<String, VirtualServiceRequest>> virtualServiceRequestMap1) {
        virtualServiceRequestMap = virtualServiceRequestMap1;
    }

    public static boolean isValidJson(String jsonStr) {
        try {
            Object json = new JSONTokener(jsonStr).nextValue();
            return json instanceof JSONObject || json instanceof JSONArray;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void writeYaml(String filename, InputStream in) throws IOException {
        File targetFile = new File(filename);
        InputStream initialStream = in;
        Files.copy(initialStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        initialStream.close();
    }

    public static void reload() {
        String profile = System.getenv("spring.profiles.active");
        profile = profile == null ? System.getenv("SPRING_PROFILES_ACTIVE") : profile;
        Object fileName = profile != null ? "virtualan-" + profile + ".properties" : "virtualan.properties";
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream((String)fileName);
            if (stream == null) {
                stream = VirtualanConfiguration.class.getClassLoader().getResourceAsStream((String)fileName);
            }
            properties.load(stream);
        }
        catch (Exception e) {
            log.warn((String)fileName + " is missing");
        }
    }

    public static Map<String, String> getProperties() {
        return properties;
    }

    public static String getProperty(String keyName) {
        return properties.getProperty(keyName);
    }

    public static File getPath() {
        return VirtualanConfiguration.getPath("default-path", "/conf");
    }

    public static File getSrcPath() {
        return VirtualanConfiguration.getDefaultPath("source");
    }

    public static File getDestPath() {
        return VirtualanConfiguration.getDefaultPath("classes");
    }

    public static File getDefaultPath(String defaultPath) {
        File file = new File(VirtualanConfiguration.getPath() + File.separator + defaultPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(VirtualanConfiguration.getPath() + File.separator + defaultPath);
    }

    public static File getDependencyPath() {
        return VirtualanConfiguration.getPath("dependencyFolder", "/openapi/virtualan/lib");
    }

    public static File getYamlPath() {
        return VirtualanConfiguration.getDefaultPath("yaml");
    }

    public static File getPath(String keyName, String defaultPath) {
        return properties != null && properties.getProperty(keyName) != null ? new File(properties.getProperty(keyName)) : new File(defaultPath);
    }

    static {
        VirtualanConfiguration.reload();
        virtualServiceRequestMap = new HashMap<String, Map<String, VirtualServiceRequest>>();
    }
}

