/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import io.virtualan.core.util.VirtualanConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualanClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(VirtualanClassLoader.class);

    public VirtualanClassLoader(ClassLoader parent) {
        super(parent);
    }

    private File isGeneratedFile(File file, String fileName) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                File file1 = this.isGeneratedFile(child, fileName);
                if (file1 == null) continue;
                return file1;
            }
        } else if (file.getAbsolutePath().replace(File.separator, ".").endsWith(fileName + ".class")) {
            return file;
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        File file = this.isGeneratedFile(VirtualanConfiguration.getDestPath(), name);
        if (file != null) {
            try {
                URL myUrl = file.toURI().toURL();
                URLConnection connection = myUrl.openConnection();
                InputStream input = connection.getInputStream();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                int data = input.read();
                while (data != -1) {
                    buffer.write(data);
                    data = input.read();
                }
                input.close();
                byte[] classData = buffer.toByteArray();
                try {
                    return super.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return this.defineClass(name, classData, 0, classData.length);
                }
            }
            catch (MalformedURLException e) {
                log.warn("MYClassloader : " + e.getMessage());
            }
            catch (IOException e) {
                log.warn("MYClassloader : " + e.getMessage());
            }
        }
        return super.loadClass(name);
    }
}

