/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.soap;

import io.virtualan.core.model.SoapService;
import io.virtualan.core.soap.SoapEndpointCodeGenerator;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javax.annotation.PostConstruct;
import javax.jws.WebParam;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component
@Configuration
@ConditionalOnProperty(name={"virtualan.soap.package"}, matchIfMissing=false)
public class WSEndpointConfiguration
implements BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(WSEndpointConfiguration.class);
    static final Map<String, SoapService> wsServiceMockList = new HashMap<String, SoapService>();
    @Autowired
    private SoapEndpointCodeGenerator soapEndpointCodeGenerator;
    private BeanFactory beanFactory;
    @Value(value="${virtualan.soap.package:io.virtualan.ws.domain}")
    private String soapPackage;

    public Map<String, SoapService> getWsServiceMockList() {
        return wsServiceMockList;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @PostConstruct
    public void loadSoapWSservice() throws SAXException, ParserConfigurationException, XPathExpressionException, IOException, CannotCompileException {
        DefaultListableBeanFactory beanRegistry = (DefaultListableBeanFactory)this.beanFactory;
        Map<String, String> documentations = this.getDocumentations();
        Arrays.stream(this.soapPackage.split(";")).forEach(packageName -> {
            List<Class> portTypeList = this.soapEndpointCodeGenerator.findMyTypes((String)packageName);
            for (Class clazz : portTypeList) {
                Method[] methods = clazz.getDeclaredMethods();
                Arrays.stream(methods).forEach(method -> this.loadParameters((Method)method, (String)documentations.get(method.getName())));
            }
        });
        GenericBeanDefinition virtualanSOAPWS = new GenericBeanDefinition();
        virtualanSOAPWS.setBeanClass(SoapEndpointCodeGenerator.buildEndpointClass(wsServiceMockList));
        beanRegistry.registerBeanDefinition("virtualanSOAPWS", (BeanDefinition)virtualanSOAPWS);
    }

    public static void main(String[] args) throws SAXException, ParserConfigurationException, XPathExpressionException, IOException {
        new WSEndpointConfiguration().getDocumentations();
    }

    private Map<String, String> getDocumentations() throws IOException, SAXException, ParserConfigurationException, XPathExpressionException {
        HashMap<String, String> documentations = new HashMap<String, String>();
        ArrayList<NodeList> nodeList = new ArrayList<NodeList>();
        List<String> lists = Arrays.asList("classpath:META-INF/resources/wsdl/*/*.wsdl");
        for (String pathName : lists) {
            Resource[] resources;
            for (Resource file : resources = this.getCatalogList(pathName)) {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document xmlDocument = builder.parse(file.getURI().toString());
                NodeList nl = this.eval(xmlDocument);
                nodeList.add(nl);
            }
        }
        nodeList.stream().forEach(x -> {
            for (int i = 0; i < x.getLength(); ++i) {
                if (documentations.containsKey(x.item(i).getAttributes().getNamedItem("name").getNodeValue())) continue;
                documentations.put(x.item(i).getAttributes().getNamedItem("name").getNodeValue(), x.item(i).getTextContent().trim());
            }
        });
        return documentations;
    }

    private Resource[] getCatalogList(String path) throws IOException {
        ClassLoader classLoader = MethodHandles.lookup().getClass().getClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        return resolver.getResources(path);
    }

    public NodeList eval(Document doc) throws XPathExpressionException {
        String pathStr = "//operation";
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile(pathStr);
        return (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
    }

    public void loadParameters(Method method, String desc) {
        RequestWrapper requestWrapper = (RequestWrapper)AnnotationUtils.findAnnotation((Method)method, RequestWrapper.class);
        if (requestWrapper != null) {
            SoapService soapService = new SoapService();
            soapService.setNs(requestWrapper.targetNamespace());
            soapService.setMethod(method.getName());
            soapService.setLocalPart(requestWrapper.localName());
            soapService.setRequestClassName(requestWrapper.className());
            soapService.setDescription(desc);
            ResponseWrapper responseWrapper = (ResponseWrapper)AnnotationUtils.findAnnotation((Method)method, ResponseWrapper.class);
            soapService.setResponseClassName(responseWrapper.className());
            wsServiceMockList.put(soapService.getNs() + "_" + soapService.getMethod(), soapService);
        } else {
            Annotation[][] annotations;
            Annotation[][] annotationArray = annotations = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotationRow;
                for (Annotation annotation : annotationRow = annotationArray[i]) {
                    if (!(annotation instanceof WebParam)) continue;
                    WebParam clzzz = (WebParam)annotation;
                    SoapService soapService = new SoapService();
                    soapService.setNs(clzzz.targetNamespace());
                    soapService.setMethod(method.getName());
                    soapService.setLocalPart(clzzz.name());
                    soapService.setRequestClassName(method.getParameters()[0].getType().getCanonicalName());
                    soapService.setResponseClassName(method.getReturnType().getTypeName());
                    wsServiceMockList.put(soapService.getNs() + "_" + soapService.getMethod(), soapService);
                    return;
                }
            }
        }
    }
}

