/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.controller;

import io.virtualan.core.model.RequestType;
import io.virtualan.core.model.ResponseProcessType;
import io.virtualan.core.model.VirtualServiceMessageRequest;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.model.VirtualServiceStatus;
import io.virtualan.core.util.Converter;
import io.virtualan.message.core.MessageUtil;
import io.virtualan.service.VirtualService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="virtualMessageController")
public class VirtualMessageController {
    private static final Logger log = LoggerFactory.getLogger(VirtualMessageController.class);
    Locale locale = LocaleContextHolder.getLocale();
    @Autowired
    private MessageUtil messageUtil;
    @Value(value="${virtualan.script.enabled:false}")
    private boolean scriptEnabled;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private VirtualService virtualService;
    @Autowired
    private Converter converter;

    @GetMapping(value={"/virtualservices/load-topics"})
    public ResponseEntity<String> listAllTopics() throws IOException {
        JSONArray array = this.getAvailableQueues();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)array.toString());
    }

    public ResponseEntity checkIfServiceDataAlreadyExists(VirtualServiceRequest virtualServiceRequest) throws JAXBException, IOException {
        Long id = this.messageUtil.isMockAlreadyExists(virtualServiceRequest);
        if (id != null && id != 0L) {
            VirtualServiceStatus virtualServiceStatus = new VirtualServiceStatus(this.messageSource.getMessage("VS_DATA_ALREADY_EXISTS", null, this.locale));
            virtualServiceRequest.setId(id);
            virtualServiceRequest = this.converter.convertAsJson(virtualServiceRequest);
            VirtualServiceMessageRequest virtualServiceMessageRequest = new VirtualServiceMessageRequest();
            BeanUtils.copyProperties((Object)virtualServiceRequest, (Object)virtualServiceMessageRequest);
            virtualServiceMessageRequest.setBrokerUrl(virtualServiceRequest.getUrl());
            virtualServiceMessageRequest.setResponseTopicOrQueueName(virtualServiceRequest.getMethod());
            virtualServiceMessageRequest.setRequestTopicOrQueueName(virtualServiceRequest.getOperationId());
            virtualServiceStatus.setVirtualServiceMessageRequest(virtualServiceMessageRequest);
            return new ResponseEntity((Object)virtualServiceStatus, HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    @DeleteMapping(value={"/virtualservices/message/{id}"})
    public ResponseEntity<VirtualServiceRequest> deleteMockRequest(@PathVariable(value="id") long id) {
        VirtualServiceRequest mockLoadRequest = this.virtualService.findById(id);
        if (mockLoadRequest == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.virtualService.deleteMockRequestById(id);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/virtualservices/message"})
    public ResponseEntity<List<VirtualServiceMessageRequest>> listAllMockMessageLoadRequests() {
        List<VirtualServiceRequest> mockLoadRequests = this.virtualService.findAllMockRequests();
        ArrayList<VirtualServiceMessageRequest> msgList = new ArrayList<VirtualServiceMessageRequest>();
        for (VirtualServiceRequest request : mockLoadRequests) {
            VirtualServiceMessageRequest virtualServiceMessageRequest = new VirtualServiceMessageRequest();
            request = this.converter.convertAsJson(request);
            if (!RequestType.KAFKA.name().equalsIgnoreCase(request.getRequestType()) && !RequestType.AMQ.name().equalsIgnoreCase(request.getRequestType()) && !RequestType.MQTT.name().equalsIgnoreCase(request.getRequestType())) continue;
            BeanUtils.copyProperties((Object)request, (Object)virtualServiceMessageRequest);
            virtualServiceMessageRequest.setBrokerUrl(request.getUrl());
            virtualServiceMessageRequest.setResponseTopicOrQueueName(request.getMethod());
            virtualServiceMessageRequest.setRequestTopicOrQueueName(request.getOperationId());
            virtualServiceMessageRequest.setInput(request.getInput() != null ? request.getInput().toString() : null);
            virtualServiceMessageRequest.setOutput(request.getOutput() != null ? request.getOutput().toString() : null);
            msgList.add(virtualServiceMessageRequest);
        }
        if (msgList.isEmpty()) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(msgList, HttpStatus.OK);
    }

    @PostMapping(value={"/virtualservices/message"})
    public ResponseEntity createMockRequest(@RequestBody VirtualServiceMessageRequest virtualServiceMessageRequest) {
        try {
            if (!this.scriptEnabled && virtualServiceMessageRequest.getType() != null && (ResponseProcessType.SCRIPT.toString().equalsIgnoreCase(virtualServiceMessageRequest.getType().toString()) || ResponseProcessType.RULE.toString().equalsIgnoreCase(virtualServiceMessageRequest.getType().toString()))) {
                return new ResponseEntity((Object)("{\"message\":\"" + this.messageSource.getMessage("VS_VALIDATION_FAILURE_REJECT", null, this.locale) + "\"}"), null, HttpStatus.BAD_REQUEST);
            }
            VirtualServiceRequest request = new VirtualServiceRequest();
            BeanUtils.copyProperties((Object)virtualServiceMessageRequest, (Object)request);
            this.converter.convertJsonAsString(request);
            request.setUrl(virtualServiceMessageRequest.getBrokerUrl());
            request.setMethod(virtualServiceMessageRequest.getResponseTopicOrQueueName());
            request.setOperationId(virtualServiceMessageRequest.getRequestTopicOrQueueName());
            if (request.getMethod().equalsIgnoreCase(request.getOperationId())) {
                return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage("VS_INVALID_TOPIC_ERROR", null, this.locale)), HttpStatus.BAD_REQUEST);
            }
            if (virtualServiceMessageRequest.getRequestType() == null) {
                request.setRequestType(RequestType.KAFKA.toString());
            } else {
                request.setRequestType(virtualServiceMessageRequest.getRequestType());
            }
            ResponseEntity responseEntity = this.checkIfServiceDataAlreadyExists(request);
            if (responseEntity != null) {
                return responseEntity;
            }
            VirtualServiceRequest mockTransferObject = this.virtualService.saveMockRequest(request);
            mockTransferObject = this.converter.convertAsJson(mockTransferObject);
            VirtualServiceMessageRequest virtualServiceMessageRequestResponse = new VirtualServiceMessageRequest();
            BeanUtils.copyProperties((Object)mockTransferObject, (Object)virtualServiceMessageRequestResponse);
            virtualServiceMessageRequestResponse.setBrokerUrl(mockTransferObject.getUrl());
            virtualServiceMessageRequestResponse.setResponseTopicOrQueueName(mockTransferObject.getMethod());
            virtualServiceMessageRequestResponse.setRequestTopicOrQueueName(mockTransferObject.getOperationId());
            virtualServiceMessageRequestResponse.setMockStatus(new VirtualServiceStatus(this.messageSource.getMessage("VS_SUCCESS", null, this.locale)));
            return new ResponseEntity((Object)virtualServiceMessageRequestResponse, HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage("VS_UNEXPECTED_ERROR", null, this.locale) + e.getMessage()), HttpStatus.BAD_REQUEST);
        }
    }

    private JSONArray getAvailableQueues() throws IOException {
        JSONObject jmsObject;
        JSONObject expected;
        JSONArray jmsArray;
        String key;
        Iterator keys;
        JSONObject jsonObject;
        String jmsConfigJson;
        InputStream stream = VirtualMessageController.class.getClassLoader().getResourceAsStream("conf/kafka.json");
        JSONArray messageServiceInfos = new JSONArray();
        if (stream != null) {
            jmsConfigJson = this.readString(stream);
            jsonObject = new JSONObject(jmsConfigJson);
            messageServiceInfos = jsonObject.optJSONArray("Kafka");
        }
        if ((stream = VirtualMessageController.class.getClassLoader().getResourceAsStream("conf/mqtt-config.json")) != null) {
            jmsConfigJson = this.readString(stream);
            jsonObject = new JSONObject(jmsConfigJson);
            keys = jsonObject.keys();
            while (keys.hasNext()) {
                key = (String)keys.next();
                jmsArray = jsonObject.getJSONArray(key);
                if (jmsArray == null || jmsArray.length() <= 0) continue;
                expected = jmsArray.optJSONObject(0);
                jmsObject = new JSONObject();
                jmsObject.put("broker", (Object)(key + " : " + expected.getJSONArray("broker-url").getString(0)));
                jmsObject.put("topics", (Object)expected.getJSONArray("receiver-queue"));
                messageServiceInfos.put((Object)jmsObject);
            }
        }
        if ((stream = VirtualMessageController.class.getClassLoader().getResourceAsStream("conf/jms-config.json")) != null) {
            jmsConfigJson = this.readString(stream);
            jsonObject = new JSONObject(jmsConfigJson);
            keys = jsonObject.keys();
            while (keys.hasNext()) {
                key = (String)keys.next();
                jmsArray = jsonObject.getJSONArray(key);
                if (jmsArray == null || jmsArray.length() <= 0) continue;
                expected = jmsArray.optJSONObject(0);
                jmsObject = new JSONObject();
                if ("IBMMQ".equalsIgnoreCase(key)) {
                    StringBuilder messageIndentifier = new StringBuilder();
                    messageIndentifier.append(expected.getString("host"));
                    messageIndentifier.append("(");
                    messageIndentifier.append(expected.getInt("port"));
                    messageIndentifier.append(")- ");
                    messageIndentifier.append(expected.getString("channel"));
                    messageIndentifier.append(" - ");
                    messageIndentifier.append(expected.getString("queue-mgr"));
                    jmsObject.put("broker", (Object)(key + " : " + messageIndentifier.toString()));
                } else {
                    jmsObject.put("broker", (Object)(key + " : " + expected.getString("broker-url")));
                }
                jmsObject.put("topics", (Object)expected.optJSONArray("receiver-queue"));
                messageServiceInfos.put((Object)jmsObject);
            }
        }
        return messageServiceInfos;
    }

    public String readString(InputStream inputStream) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String string = br.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public JSONArray getArray(String[] stringArray) {
        JSONArray array = new JSONArray();
        for (String name : stringArray) {
            array.put((Object)name);
        }
        return array;
    }
}

