/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import io.virtualan.core.util.VirtualanClassLoader;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Helper {
    public static boolean isValidJson(String jsonStr) {
        try {
            Object json = new JSONTokener(jsonStr).nextValue();
            return json instanceof JSONObject || json instanceof JSONArray;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void addURLToClassLoader(URL url, ClassLoader classLoader) throws IntrospectionException {
        URLClassLoader systemClassLoader = null;
        systemClassLoader = classLoader instanceof VirtualanClassLoader ? new URLClassLoader(new URL[]{url}, classLoader) : (URLClassLoader)classLoader;
        Class<URLClassLoader> classLoaderClass = URLClassLoader.class;
        try {
            Method method = classLoaderClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)systemClassLoader, url);
        }
        catch (Throwable t) {
            throw new IntrospectionException("Error when adding url to system ClassLoader ");
        }
    }

    public static void writeYaml(String filename, InputStream in) throws IOException {
        File targetFile = new File(filename);
        InputStream initialStream = in;
        Files.copy(initialStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        initialStream.close();
    }
}

