/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FragmentContentHandler
extends DefaultHandler {
    private String xPath = "/";
    private XMLReader xmlReader;
    private FragmentContentHandler parent;
    private StringBuilder characters = new StringBuilder();
    private Map<String, Integer> elementNameCount = new HashMap<String, Integer>();
    private List<String> xPaths;

    public FragmentContentHandler(List<String> xPaths, XMLReader xmlReader) {
        this.xmlReader = xmlReader;
        this.xPaths = xPaths;
    }

    private FragmentContentHandler(List<String> xPaths, String xPath, XMLReader xmlReader, FragmentContentHandler parent) {
        this(xPaths, xmlReader);
        this.xPath = xPath;
        this.parent = parent;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Integer count = this.elementNameCount.get(qName);
        if (null == count) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.elementNameCount.put(qName, count);
        String childXPath = this.xPath + '/' + qName + '[' + count + ']';
        int attsLength = atts.getLength();
        for (int x = 0; x < attsLength; ++x) {
            this.xPaths.add(childXPath + "[@" + atts.getQName(x) + "='" + atts.getValue(x) + ']');
        }
        FragmentContentHandler child = new FragmentContentHandler(this.xPaths, childXPath, this.xmlReader, this);
        this.xmlReader.setContentHandler(child);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value = this.characters.toString().trim();
        if (value.length() > 0) {
            this.xPaths.add(this.xPath + "='" + this.characters.toString() + "'");
        }
        this.xmlReader.setContentHandler(this.parent);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }
}

