/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.virtualan.core.model.ContentType;
import io.virtualan.core.model.VirtualServiceApiResponse;
import io.virtualan.core.model.VirtualServiceKeyValue;
import io.virtualan.core.model.VirtualServiceStatus;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VirtualServiceRequest {
    private long id;
    private String operationId;
    private String httpStatusCode;
    private String url;
    private String type;
    private String requestType;
    private long usageCount;
    private int priority;
    private String method;
    private Class inputObjectType;
    private Class responseObjectType;
    private String outputObjectType;
    private Object input;
    private String rule;
    private Object output;
    private List<VirtualServiceKeyValue> availableParams = new ArrayList<VirtualServiceKeyValue>();
    private List<VirtualServiceKeyValue> headerParams = new ArrayList<VirtualServiceKeyValue>();
    private Map<String, VirtualServiceApiResponse> responseType;
    private String excludeList;
    private String resource;
    private String desc;
    private VirtualServiceStatus mockStatus;
    private Calendar lastUsedDateTime;
    private ContentType contentType;
    private Map<String, String> types;
    private Map<String, String> httpStatusMap;

    public Object getHeaderParam(String param) {
        return this.headerParams.stream().filter(x -> x.getKey().equalsIgnoreCase(param)).map(VirtualServiceKeyValue::getValue);
    }

    public Object getAvailableParam(String param) {
        return this.availableParams.stream().filter(x -> x.getKey().equalsIgnoreCase(param)).map(VirtualServiceKeyValue::getValue);
    }

    public String groovyTemplateObj() {
        return " def executeScript(mockServiceRequest, responseObject) { \n     int age = getAge(mockServiceRequest.getInput().getBirthday()); \n    String postalCode = mockServiceRequest.getInput().getPostalCode(); \n    int riskFactor = computeRiskFactor(age, postalCode); \n    responseObject.setHttpStatusCode('200'); \n    responseObject.setOutput(String.valueOf(riskFactor)); \n    return responseObject.builder();\n }} \n";
    }

    public VirtualServiceRequest(long id, String operationId, String input, String output) {
        this.id = id;
        this.operationId = operationId;
        this.input = input;
        this.output = output;
    }

    public VirtualServiceRequest() {
    }

    public String toString() {
        return "VirtualServiceRequest{id=" + this.id + ", operationId='" + this.operationId + '\'' + ", httpStatusCode='" + this.httpStatusCode + '\'' + ", url='" + this.url + '\'' + ", type='" + this.type + '\'' + ", requestType='" + this.requestType + '\'' + ", usageCount=" + this.usageCount + ", priority=" + this.priority + ", method='" + this.method + '\'' + ", inputObjectType=" + this.inputObjectType + ", outputObjectType='" + this.outputObjectType + '\'' + ", input='" + this.input + '\'' + ", rule='" + this.rule + '\'' + ", output='" + this.output + '\'' + ", availableParams=" + this.availableParams + ", headerParams=" + this.headerParams + ", responseType=" + this.responseType + ", excludeList='" + this.excludeList + '\'' + ", resource='" + this.resource + '\'' + ", desc='" + this.desc + '\'' + ", mockStatus=" + this.mockStatus + ", lastUsedDateTime=" + this.lastUsedDateTime + ", contentType=" + (Object)((Object)this.contentType) + ", httpStatusMap=" + this.httpStatusMap + '}';
    }

    public long getId() {
        return this.id;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getUrl() {
        return this.url;
    }

    public String getType() {
        return this.type;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public long getUsageCount() {
        return this.usageCount;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getMethod() {
        return this.method;
    }

    public Class getInputObjectType() {
        return this.inputObjectType;
    }

    public Class getResponseObjectType() {
        return this.responseObjectType;
    }

    public String getOutputObjectType() {
        return this.outputObjectType;
    }

    public Object getInput() {
        return this.input;
    }

    public String getRule() {
        return this.rule;
    }

    public Object getOutput() {
        return this.output;
    }

    public List<VirtualServiceKeyValue> getAvailableParams() {
        return this.availableParams;
    }

    public List<VirtualServiceKeyValue> getHeaderParams() {
        return this.headerParams;
    }

    public Map<String, VirtualServiceApiResponse> getResponseType() {
        return this.responseType;
    }

    public String getExcludeList() {
        return this.excludeList;
    }

    public String getResource() {
        return this.resource;
    }

    public String getDesc() {
        return this.desc;
    }

    public VirtualServiceStatus getMockStatus() {
        return this.mockStatus;
    }

    public Calendar getLastUsedDateTime() {
        return this.lastUsedDateTime;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public Map<String, String> getTypes() {
        return this.types;
    }

    public Map<String, String> getHttpStatusMap() {
        return this.httpStatusMap;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public void setHttpStatusCode(String httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public void setUsageCount(long usageCount) {
        this.usageCount = usageCount;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setInputObjectType(Class inputObjectType) {
        this.inputObjectType = inputObjectType;
    }

    public void setResponseObjectType(Class responseObjectType) {
        this.responseObjectType = responseObjectType;
    }

    public void setOutputObjectType(String outputObjectType) {
        this.outputObjectType = outputObjectType;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public void setOutput(Object output) {
        this.output = output;
    }

    public void setAvailableParams(List<VirtualServiceKeyValue> availableParams) {
        this.availableParams = availableParams;
    }

    public void setHeaderParams(List<VirtualServiceKeyValue> headerParams) {
        this.headerParams = headerParams;
    }

    public void setResponseType(Map<String, VirtualServiceApiResponse> responseType) {
        this.responseType = responseType;
    }

    public void setExcludeList(String excludeList) {
        this.excludeList = excludeList;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setMockStatus(VirtualServiceStatus mockStatus) {
        this.mockStatus = mockStatus;
    }

    public void setLastUsedDateTime(Calendar lastUsedDateTime) {
        this.lastUsedDateTime = lastUsedDateTime;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setTypes(Map<String, String> types) {
        this.types = types;
    }

    public void setHttpStatusMap(Map<String, String> httpStatusMap) {
        this.httpStatusMap = httpStatusMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualServiceRequest)) {
            return false;
        }
        VirtualServiceRequest other = (VirtualServiceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getUsageCount() != other.getUsageCount()) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        String this$operationId = this.getOperationId();
        String other$operationId = other.getOperationId();
        if (this$operationId == null ? other$operationId != null : !this$operationId.equals(other$operationId)) {
            return false;
        }
        String this$httpStatusCode = this.getHttpStatusCode();
        String other$httpStatusCode = other.getHttpStatusCode();
        if (this$httpStatusCode == null ? other$httpStatusCode != null : !this$httpStatusCode.equals(other$httpStatusCode)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$requestType = this.getRequestType();
        String other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Class this$inputObjectType = this.getInputObjectType();
        Class other$inputObjectType = other.getInputObjectType();
        if (this$inputObjectType == null ? other$inputObjectType != null : !this$inputObjectType.equals(other$inputObjectType)) {
            return false;
        }
        Class this$responseObjectType = this.getResponseObjectType();
        Class other$responseObjectType = other.getResponseObjectType();
        if (this$responseObjectType == null ? other$responseObjectType != null : !this$responseObjectType.equals(other$responseObjectType)) {
            return false;
        }
        String this$outputObjectType = this.getOutputObjectType();
        String other$outputObjectType = other.getOutputObjectType();
        if (this$outputObjectType == null ? other$outputObjectType != null : !this$outputObjectType.equals(other$outputObjectType)) {
            return false;
        }
        Object this$input = this.getInput();
        Object other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        String this$rule = this.getRule();
        String other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        Object this$output = this.getOutput();
        Object other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        List<VirtualServiceKeyValue> this$availableParams = this.getAvailableParams();
        List<VirtualServiceKeyValue> other$availableParams = other.getAvailableParams();
        if (this$availableParams == null ? other$availableParams != null : !((Object)this$availableParams).equals(other$availableParams)) {
            return false;
        }
        List<VirtualServiceKeyValue> this$headerParams = this.getHeaderParams();
        List<VirtualServiceKeyValue> other$headerParams = other.getHeaderParams();
        if (this$headerParams == null ? other$headerParams != null : !((Object)this$headerParams).equals(other$headerParams)) {
            return false;
        }
        Map<String, VirtualServiceApiResponse> this$responseType = this.getResponseType();
        Map<String, VirtualServiceApiResponse> other$responseType = other.getResponseType();
        if (this$responseType == null ? other$responseType != null : !((Object)this$responseType).equals(other$responseType)) {
            return false;
        }
        String this$excludeList = this.getExcludeList();
        String other$excludeList = other.getExcludeList();
        if (this$excludeList == null ? other$excludeList != null : !this$excludeList.equals(other$excludeList)) {
            return false;
        }
        String this$resource = this.getResource();
        String other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        VirtualServiceStatus this$mockStatus = this.getMockStatus();
        VirtualServiceStatus other$mockStatus = other.getMockStatus();
        if (this$mockStatus == null ? other$mockStatus != null : !((Object)this$mockStatus).equals(other$mockStatus)) {
            return false;
        }
        Calendar this$lastUsedDateTime = this.getLastUsedDateTime();
        Calendar other$lastUsedDateTime = other.getLastUsedDateTime();
        if (this$lastUsedDateTime == null ? other$lastUsedDateTime != null : !((Object)this$lastUsedDateTime).equals(other$lastUsedDateTime)) {
            return false;
        }
        ContentType this$contentType = this.getContentType();
        ContentType other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)((Object)this$contentType)).equals((Object)other$contentType)) {
            return false;
        }
        Map<String, String> this$types = this.getTypes();
        Map<String, String> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        Map<String, String> this$httpStatusMap = this.getHttpStatusMap();
        Map<String, String> other$httpStatusMap = other.getHttpStatusMap();
        return !(this$httpStatusMap == null ? other$httpStatusMap != null : !((Object)this$httpStatusMap).equals(other$httpStatusMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VirtualServiceRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $usageCount = this.getUsageCount();
        result = result * 59 + (int)($usageCount >>> 32 ^ $usageCount);
        result = result * 59 + this.getPriority();
        String $operationId = this.getOperationId();
        result = result * 59 + ($operationId == null ? 43 : $operationId.hashCode());
        String $httpStatusCode = this.getHttpStatusCode();
        result = result * 59 + ($httpStatusCode == null ? 43 : $httpStatusCode.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : $requestType.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Class $inputObjectType = this.getInputObjectType();
        result = result * 59 + ($inputObjectType == null ? 43 : $inputObjectType.hashCode());
        Class $responseObjectType = this.getResponseObjectType();
        result = result * 59 + ($responseObjectType == null ? 43 : $responseObjectType.hashCode());
        String $outputObjectType = this.getOutputObjectType();
        result = result * 59 + ($outputObjectType == null ? 43 : $outputObjectType.hashCode());
        Object $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        String $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        Object $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        List<VirtualServiceKeyValue> $availableParams = this.getAvailableParams();
        result = result * 59 + ($availableParams == null ? 43 : ((Object)$availableParams).hashCode());
        List<VirtualServiceKeyValue> $headerParams = this.getHeaderParams();
        result = result * 59 + ($headerParams == null ? 43 : ((Object)$headerParams).hashCode());
        Map<String, VirtualServiceApiResponse> $responseType = this.getResponseType();
        result = result * 59 + ($responseType == null ? 43 : ((Object)$responseType).hashCode());
        String $excludeList = this.getExcludeList();
        result = result * 59 + ($excludeList == null ? 43 : $excludeList.hashCode());
        String $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        VirtualServiceStatus $mockStatus = this.getMockStatus();
        result = result * 59 + ($mockStatus == null ? 43 : ((Object)$mockStatus).hashCode());
        Calendar $lastUsedDateTime = this.getLastUsedDateTime();
        result = result * 59 + ($lastUsedDateTime == null ? 43 : ((Object)$lastUsedDateTime).hashCode());
        ContentType $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)((Object)$contentType)).hashCode());
        Map<String, String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        Map<String, String> $httpStatusMap = this.getHttpStatusMap();
        result = result * 59 + ($httpStatusMap == null ? 43 : ((Object)$httpStatusMap).hashCode());
        return result;
    }
}

