/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.message.core.jms;

import io.virtualan.message.core.jms.JMSConfigurationDomain;
import io.virtualan.message.core.jms.JMSListener;
import io.virtualan.message.core.jms.JMSTemplateLookup;
import io.virtualan.message.core.jms.VirtualanJMSConnectionFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnResource(resources={"classpath:conf/jms-config.json"})
public class JMSMessageSender {
    private static final Logger log = LoggerFactory.getLogger(JMSMessageSender.class);
    List<VirtualanJMSConnectionFactory> virtualanJMSConnectionFactory;
    @Autowired
    private BeanFactory beanFactory;

    static void sendMessage(String inboundTopic, String outboudTopic, final String message) {
        log.info(JMSTemplateLookup.getJmsTemplateMap().toString());
        log.info("sending:{} ", (Object)message);
        JMSTemplateLookup.getJmsTemplate(inboundTopic).send(outboudTopic, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return session.createTextMessage(message);
            }
        });
    }

    @Autowired
    private void allVirtualanJMSConnectionFactory(List<VirtualanJMSConnectionFactory> virtualanJMSConnectionFactory) {
        this.virtualanJMSConnectionFactory = virtualanJMSConnectionFactory;
    }

    private ConnectionFactory connectionFactory(JMSConfigurationDomain conf) throws JMSException {
        for (VirtualanJMSConnectionFactory virtualanJMSConnection : this.virtualanJMSConnectionFactory) {
            if (!conf.getJmsType().equalsIgnoreCase(virtualanJMSConnection.getJMSType())) continue;
            return virtualanJMSConnection.connectionFactory(conf);
        }
        log.warn("JMS Conf JMSType {} :: {} ", (Object)conf.getJmsType(), (Object)conf);
        throw new JMSException("JMS Conf JMSType is not found" + conf.getJmsType());
    }

    private String readString(InputStream inputStream) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String string = br.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    @PostConstruct
    public void init() throws IOException {
        try {
            JSONObject jmsConfigurations = this.getJMSConfiguration();
            Iterator keys = jmsConfigurations.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONArray array = jmsConfigurations.getJSONArray(key);
                if (array == null || array.length() <= 0) continue;
                this.buildJMSListener(array, key);
            }
        }
        catch (Exception e) {
            log.error("JMS conf is not loaded {}", (Object)e.getMessage());
        }
    }

    private void buildJMSListener(JSONArray array, String jmsType) {
        for (int i = 0; i < array.length(); ++i) {
            JSONObject object = array.optJSONObject(i);
            JMSConfigurationDomain conf = this.getJmsConfigurationDomain(object, jmsType);
            if (conf.getReceiverQueueName().contains(conf.getSenderQueueName())) {
                log.info("JMS conf is not valid to be loaded : {} ", (Object)conf);
                continue;
            }
            if (conf.getReceiverQueueName() != null) {
                this.registerListenerBeans(conf);
            }
            if (conf.getSenderQueueName() != null) {
                try {
                    JmsTemplate jmsTemplate = new JmsTemplate(this.connectionFactory(conf));
                    for (String queue : conf.getReceiverQueueName()) {
                        JMSTemplateLookup.loadTemplate(queue, jmsTemplate);
                    }
                    log.info(JMSTemplateLookup.getJmsTemplateMap().toString());
                }
                catch (JMSException e) {
                    log.warn("JMS Exception error : {} : conf : {}", (Object)e.getMessage(), (Object)conf);
                }
            }
            log.info("JMS conf loaded : {} ", (Object)conf);
        }
    }

    private JSONObject getJMSConfiguration() throws IOException {
        InputStream stream = JMSMessageSender.class.getClassLoader().getResourceAsStream("conf/jms-config.json");
        String jmsConfigJson = this.readString(stream);
        return new JSONObject(jmsConfigJson);
    }

    private List<String> getReceiverQueues(JSONObject object) {
        ArrayList<String> receiverQueue = new ArrayList<String>();
        for (int i = 0; i < object.getJSONArray("receiver-queue").length(); ++i) {
            receiverQueue.add((String)object.getJSONArray("receiver-queue").get(i));
        }
        return receiverQueue;
    }

    private JMSConfigurationDomain getJmsConfigurationDomain(JSONObject object, String jmsType) {
        JMSConfigurationDomain conf = new JMSConfigurationDomain();
        conf.setJmsType(jmsType);
        if ("IBMMQ".equalsIgnoreCase(jmsType)) {
            conf.setSystem(object.getString("systemName"));
            conf.setHost(object.getString("host"));
            conf.setPort(object.getInt("port"));
            conf.setQueueMgr(object.getString("queue-mgr"));
            conf.setChannel(object.getString("channel"));
            conf.setUserName(object.optString("username"));
            conf.setPassword(object.optString("password"));
            conf.setReceiverQueueName(this.getReceiverQueues(object));
            conf.setSenderQueueName(object.optString("response-queue"));
        } else {
            conf.setSystem(object.getString("systemName"));
            conf.setBrokerUrl(object.getString("broker-url"));
            conf.setUserName(object.optString("user"));
            conf.setPassword(object.optString("password"));
            conf.setReceiverQueueName(this.getReceiverQueues(object));
            conf.setSenderQueueName(object.optString("response-queue"));
        }
        return conf;
    }

    private void registerListenerBeans(JMSConfigurationDomain conf) {
        for (String queue : conf.getReceiverQueueName()) {
            try {
                GenericBeanDefinition jmsBean = new GenericBeanDefinition();
                jmsBean.setBeanClass(JMSListener.class);
                BeanDefinitionBuilder bean = BeanDefinitionBuilder.rootBeanDefinition(DefaultMessageListenerContainer.class).addPropertyValue("connectionFactory", (Object)this.connectionFactory(conf)).addPropertyValue("destinationName", (Object)queue).addPropertyValue("messageListener", (Object)jmsBean);
                DefaultListableBeanFactory beanRegistry = (DefaultListableBeanFactory)this.beanFactory;
                beanRegistry.registerBeanDefinition(conf.getSystem().concat(queue), (BeanDefinition)bean.getBeanDefinition());
                DefaultMessageListenerContainer messageListenerContainer = (DefaultMessageListenerContainer)this.beanFactory.getBean(conf.getSystem().concat(queue), DefaultMessageListenerContainer.class);
                if (messageListenerContainer.isRunning()) continue;
                log.info("{} bean registered successfully.. and Started JmsListenerContainer", (Object)conf.getSystem());
                messageListenerContainer.start();
            }
            catch (JMSException e) {
                log.warn("JMS  Listener register Exception error : {} : conf : {}", (Object)e.getMessage(), (Object)conf);
            }
        }
    }
}

