/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.virtualan.api.ApiType;
import io.virtualan.core.VirtualServiceInfo;
import io.virtualan.core.model.ResourceMapper;
import io.virtualan.core.model.VirtualServiceKeyValue;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.requestbody.RequestBody;
import io.virtualan.requestbody.RequestBodyTypes;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="springVirtualServiceInfo")
public class SpringVirtualServiceInfo
implements VirtualServiceInfo {
    private static final Logger log = LoggerFactory.getLogger(SpringVirtualServiceInfo.class);
    @Autowired
    private ObjectMapper objectMapper;
    ResourceMapper resourceParent;
    Map<String, Map<String, VirtualServiceRequest>> mockLoadChoice;
    @Autowired
    private ApiType apiType;

    @Override
    public ApiType getApiType() {
        return this.apiType;
    }

    @Override
    public void setApiType(ApiType apiType) {
        this.apiType = apiType;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public ResourceMapper getResourceParent() {
        return this.resourceParent;
    }

    @Override
    public void setResourceParent(ResourceMapper resourceParent) {
        this.resourceParent = resourceParent;
    }

    @Override
    public Map<String, Map<String, VirtualServiceRequest>> getMockLoadChoice() {
        return this.mockLoadChoice;
    }

    @Override
    public void setMockLoadChoice(Map<String, Map<String, VirtualServiceRequest>> mockLoadChoice) {
        this.mockLoadChoice = mockLoadChoice;
    }

    @Override
    public void buildInput(Method method, VirtualServiceRequest mockLoadRequest) throws ClassNotFoundException {
        int i = 0;
        ArrayList<VirtualServiceKeyValue> availableParams = new ArrayList<VirtualServiceKeyValue>();
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (Annotation[] anns : annotations) {
            Class<?> parameterType = parameterTypes[i++];
            for (Annotation paramAnnotation : anns) {
                if (paramAnnotation.annotationType().equals(RequestParam.class)) {
                    RequestParam requestParam = (RequestParam)paramAnnotation;
                    availableParams.add(new VirtualServiceKeyValue(requestParam.value(), null, "QUERY_PARAM"));
                    continue;
                }
                if (paramAnnotation.annotationType().equals(PathVariable.class)) {
                    PathVariable pathVariable = (PathVariable)paramAnnotation;
                    availableParams.add(new VirtualServiceKeyValue(pathVariable.value(), null, "PATH_PARAM"));
                    continue;
                }
                if (!paramAnnotation.annotationType().equals(org.springframework.web.bind.annotation.RequestBody.class)) continue;
                RequestBody requestBody = new RequestBody();
                requestBody.setInputObjectTypeName(Class.forName(parameterType.getName()).getTypeName());
                requestBody.setInputObjectType(parameterType);
                requestBody.setObjectMapper(this.objectMapper);
                mockLoadRequest.setInputObjectType(Class.forName(parameterType.getName()));
                try {
                    mockLoadRequest.setInput(RequestBodyTypes.fromString(requestBody.getInputObjectTypeName()).getDefaultMessageBody(requestBody));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        mockLoadRequest.setAvailableParams(availableParams);
    }
}

