/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.custom.message;

import io.virtualan.custom.message.ApiError;
import io.virtualan.custom.message.ResponseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Order(value=0x7FFFFFFF)
@ControllerAdvice
public class SpringResponseEntityExceptionHandler
extends ResponseEntityExceptionHandler {
    public static final String VS_VALIDATION_FAILURE1 = "VS_VALIDATION_FAILURE";
    public static final String VS_VALIDATION_FAILURE = "VS_VALIDATION_FAILURE";
    @Autowired
    private MessageSource messageSource;
    Locale locale = LocaleContextHolder.getLocale();

    @ExceptionHandler(value={ResponseException.class})
    protected ResponseEntity handleExceptionInternal(HttpServletRequest req, Exception ex) {
        this.logger.info((Object)("No Details: " + ex.getClass().getName()));
        ArrayList<String> errors = new ArrayList<String>();
        errors.add(ex.getMessage());
        return ((ResponseException)ex).getResponseEntity();
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        ArrayList<String> errors = new ArrayList<String>();
        errors.add(ex.getMessage());
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), errors);
        return this.handleExceptionInternal((Exception)ex, apiError, headers, apiError.getStatus(), request);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        ArrayList<String> errors = new ArrayList<String>();
        for (FieldError error : ex.getBindingResult().getFieldErrors()) {
            errors.add(error.getField() + ": " + error.getDefaultMessage());
        }
        for (FieldError error : ex.getBindingResult().getGlobalErrors()) {
            errors.add(error.getObjectName() + ": " + error.getDefaultMessage());
        }
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), errors);
        return this.handleExceptionInternal((Exception)ex, apiError, headers, apiError.getStatus(), request);
    }

    protected ResponseEntity<Object> handleBindException(BindException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        ArrayList<String> errors = new ArrayList<String>();
        for (FieldError error : ex.getBindingResult().getFieldErrors()) {
            errors.add(error.getField() + ": " + error.getDefaultMessage());
        }
        for (FieldError error : ex.getBindingResult().getGlobalErrors()) {
            errors.add(error.getObjectName() + ": " + error.getDefaultMessage());
        }
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), ex.getLocalizedMessage(), errors);
        return this.handleExceptionInternal((Exception)ex, apiError, headers, apiError.getStatus(), request);
    }

    protected ResponseEntity<Object> handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        String error = ex.getValue() + " value for " + ex.getPropertyName() + " should be of type " + ex.getRequiredType();
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), ex.getLocalizedMessage(), error);
        return new ResponseEntity((Object)apiError, (MultiValueMap)new HttpHeaders(), apiError.getStatus());
    }

    protected ResponseEntity<Object> handleMissingServletRequestPart(MissingServletRequestPartException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        String error = ex.getRequestPartName() + " part is missing";
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), ex.getLocalizedMessage(), error);
        return new ResponseEntity((Object)apiError, (MultiValueMap)new HttpHeaders(), apiError.getStatus());
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        String error = ex.getParameterName() + " parameter is missing";
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), ex.getLocalizedMessage(), error);
        return new ResponseEntity((Object)apiError, (MultiValueMap)new HttpHeaders(), apiError.getStatus());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException ex, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        String error = ex.getName() + " should be of type " + ex.getRequiredType().getName();
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), ex.getLocalizedMessage(), error);
        return new ResponseEntity((Object)apiError, (MultiValueMap)new HttpHeaders(), apiError.getStatus());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException ex, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        ArrayList<String> errors = new ArrayList<String>();
        for (ConstraintViolation violation : ex.getConstraintViolations()) {
            errors.add(violation.getRootBeanClass().getName() + " " + violation.getPropertyPath() + ": " + violation.getMessage());
        }
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), ex.getLocalizedMessage(), errors);
        return new ResponseEntity((Object)apiError, (MultiValueMap)new HttpHeaders(), apiError.getStatus());
    }

    protected ResponseEntity<Object> handleNoHandlerFoundException(NoHandlerFoundException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        String error = "No handler found for " + ex.getHttpMethod() + " " + ex.getRequestURL();
        ApiError apiError = new ApiError(HttpStatus.NOT_FOUND, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), ex.getLocalizedMessage(), error);
        return new ResponseEntity((Object)apiError, (MultiValueMap)new HttpHeaders(), apiError.getStatus());
    }

    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        StringBuilder builder = new StringBuilder();
        builder.append(ex.getMethod());
        builder.append(" method is not supported for this request. Supported methods are ");
        ex.getSupportedHttpMethods().forEach(t -> builder.append(t + " "));
        ApiError apiError = new ApiError(HttpStatus.METHOD_NOT_ALLOWED, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), ex.getLocalizedMessage(), builder.toString());
        return new ResponseEntity((Object)apiError, (MultiValueMap)new HttpHeaders(), apiError.getStatus());
    }

    protected ResponseEntity<Object> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        StringBuilder builder = new StringBuilder();
        builder.append(ex.getContentType());
        builder.append(" media type is not supported. Supported media types are ");
        ex.getSupportedMediaTypes().forEach(t -> builder.append(t + " "));
        ApiError apiError = new ApiError(HttpStatus.UNSUPPORTED_MEDIA_TYPE, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), ex.getLocalizedMessage(), builder.substring(0, builder.length() - 2));
        return new ResponseEntity((Object)apiError, (MultiValueMap)new HttpHeaders(), apiError.getStatus());
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleAll(Exception ex, WebRequest request) {
        this.logger.info((Object)ex.getClass().getName());
        this.logger.error((Object)"error", (Throwable)ex);
        ApiError apiError = new ApiError(HttpStatus.INTERNAL_SERVER_ERROR, this.messageSource.getMessage("VS_VALIDATION_FAILURE", null, this.locale), ex.getLocalizedMessage(), "error occurred");
        return new ResponseEntity((Object)apiError, (MultiValueMap)new HttpHeaders(), apiError.getStatus());
    }
}

