/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.soap;

import io.virtualan.core.model.SoapService;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.jws.WebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

@Configuration
@Component
@ConditionalOnProperty(name={"virtualan.soap.package"}, matchIfMissing=true)
public class SoapEndpointCodeGenerator {
    static Logger log = LoggerFactory.getLogger(SoapEndpointCodeGenerator.class);

    public static Class buildEndpointClass(Map<String, SoapService> soapWsServices) throws CannotCompileException, IOException {
        ClassPool pool = ClassPool.getDefault();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        pool.insertClassPath((ClassPath)new LoaderClassPath(cl));
        CtClass cc = pool.makeClass("io.virtualan.VirtualanEndpoint");
        SoapEndpointCodeGenerator.addClassAnnotation(cc);
        for (Map.Entry<String, SoapService> soapWsServiceEntry : soapWsServices.entrySet()) {
            SoapService soapService = soapWsServiceEntry.getValue();
            String methodSignature = SoapEndpointCodeGenerator.generateMethod(soapService);
            CtMethod method = CtMethod.make((String)methodSignature, (CtClass)cc);
            SoapEndpointCodeGenerator.addParameterAnnotation(cc, method);
            SoapEndpointCodeGenerator.addMethodAnnotation(cc, soapService, method);
        }
        if (log.isDebugEnabled()) {
            cc.getClassFile().write(new DataOutputStream(new FileOutputStream("VirtualanEndpoint.java")));
        }
        return cc.toClass();
    }

    private static void addMethodAnnotation(CtClass cc, SoapService soapService, CtMethod method) {
        HashMap<String, String> keyValue = new HashMap<String, String>();
        keyValue.put("namespace", soapService.getNs());
        keyValue.put("localPart", soapService.getLocalPart());
        ConstPool cpool = cc.getClassFile().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(cpool, "RuntimeVisibleAnnotations");
        Annotation annot = new Annotation("org.springframework.ws.server.endpoint.annotation.ResponsePayload", cpool);
        attr.addAnnotation(annot);
        Annotation annot1 = new Annotation("io.virtualan.annotation.ApiVirtual", cpool);
        attr.addAnnotation(annot1);
        Annotation annot2 = new Annotation("org.springframework.ws.server.endpoint.annotation.PayloadRoot", cpool);
        keyValue.entrySet().stream().forEach(x -> annot2.addMemberValue((String)x.getKey(), (MemberValue)new StringMemberValue((String)x.getValue(), cpool)));
        attr.addAnnotation(annot2);
        method.getMethodInfo().addAttribute((AttributeInfo)attr);
    }

    private static void addParameterAnnotation(CtClass cc, CtMethod method) throws DuplicateMemberException {
        ParameterAnnotationsAttribute oldAns = new ParameterAnnotationsAttribute(cc.getClassFile().getConstPool(), "RuntimeVisibleParameterAnnotations");
        Annotation[][] anAr = new Annotation[1][1];
        anAr[0] = new Annotation[1];
        anAr[0][0] = SoapEndpointCodeGenerator.constructAnnotation(cc.getClassFile().getConstPool(), "org.springframework.ws.server.endpoint.annotation.RequestPayload");
        oldAns.setAnnotations(anAr);
        MethodInfo methodInfo = method.getMethodInfo2();
        methodInfo.addAttribute((AttributeInfo)oldAns);
        cc.getClassFile().addMethod(methodInfo);
    }

    private static Annotation constructAnnotation(ConstPool cp, String annotationName) {
        return new Annotation(annotationName, cp);
    }

    private static String generateMethod(SoapService soapService) {
        StringBuilder sb = new StringBuilder();
        sb.append("public  ").append(soapService.getResponseClassName()).append(" ").append(soapService.getMethod()).append("( " + soapService.getRequestClassName() + " request  )").append("{ return null; }");
        return sb.toString();
    }

    public static void addClassAnnotation(CtClass clazz) {
        ClassFile cfile = clazz.getClassFile();
        ConstPool cpool = cfile.getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(cpool, "RuntimeVisibleAnnotations");
        Annotation annot = SoapEndpointCodeGenerator.constructAnnotation(cpool, "org.springframework.ws.server.endpoint.annotation.Endpoint");
        Annotation annot2 = SoapEndpointCodeGenerator.constructAnnotation(cpool, "io.virtualan.annotation.VirtualService");
        Annotation annot3 = SoapEndpointCodeGenerator.constructAnnotation(cpool, "org.springframework.context.annotation.EnableAspectJAutoProxy");
        attr.addAnnotation(annot2);
        attr.addAnnotation(annot3);
        attr.addAnnotation(annot);
        cfile.addAttribute((AttributeInfo)attr);
    }

    protected List<Class> findMyTypes(String basePackage) {
        ArrayList<Class> candidates = new ArrayList<Class>();
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            String packageSearchPath = "classpath*:" + this.resolveBasePackage(basePackage) + "/**/*.class";
            for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
                MetadataReader metadataReader;
                if (!resource.isReadable() || !this.isCandidate(metadataReader = metadataReaderFactory.getMetadataReader(resource))) continue;
                candidates.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
            }
        }
        catch (IOException | ClassNotFoundException e) {
            log.warn("Unable to load the package : {}", (Object)basePackage);
        }
        return candidates;
    }

    private String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }

    private boolean isCandidate(MetadataReader metadataReader) throws ClassNotFoundException {
        try {
            Class<?> c = Class.forName(metadataReader.getClassMetadata().getClassName());
            if (c.getAnnotation(WebService.class) != null) {
                return true;
            }
        }
        catch (Exception e) {
            log.warn(" isCandidate unexpected error {}", (Object)e.getMessage());
        }
        return false;
    }
}

