/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.virtualan.core.InvalidMockResponseException;
import io.virtualan.core.VirtualServiceUtil;
import io.virtualan.core.model.ContentType;
import io.virtualan.core.model.MockRequest;
import io.virtualan.core.model.MockResponse;
import io.virtualan.core.model.MockServiceRequest;
import io.virtualan.core.model.ResponseParam;
import io.virtualan.core.model.ResponseProcessType;
import io.virtualan.core.model.VirtualServiceKeyValue;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.util.ReturnMockResponse;
import io.virtualan.core.util.VirtualServiceValidRequest;
import io.virtualan.core.util.VirtualXPaths;
import io.virtualan.core.util.XMLConverter;
import io.virtualan.mapson.Mapson;
import io.virtualan.params.Param;
import io.virtualan.params.ParamTypes;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirtualParameterizedUtil {
    private static final Logger log = LoggerFactory.getLogger(VirtualParameterizedUtil.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private VirtualServiceValidRequest virtualServiceValidRequest;
    @Autowired
    private VirtualServiceUtil virtualServiceUtil;

    public Map<Integer, ResponseParam> handleParameterizedRequest(VirtualServiceRequest mockTransferObject) {
        MockServiceRequest mockServiceRequest = this.virtualServiceUtil.buildMockServiceRequest(mockTransferObject);
        Map<MockRequest, MockResponse> mockDataSetupMap = this.virtualServiceUtil.readDynamicResponse(mockServiceRequest.getResource(), mockServiceRequest.getOperationId());
        return this.handleParameterizedRequest(mockDataSetupMap, mockServiceRequest);
    }

    public static void populateMapParams(Map<String, String> paramMap, Map<String, Object> contextObject) {
        for (Map.Entry<String, String> param : paramMap.entrySet()) {
            paramMap.put(param.getKey(), VirtualParameterizedUtil.getActualValueForAll(VirtualParameterizedUtil.getDelimiter(ContentType.JSON), param.getValue(), contextObject).toString());
        }
    }

    public Map<Integer, ReturnMockResponse> getParameterizedResponse(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) {
        Map<Integer, ReturnMockResponse> matchResponse = null;
        for (Map.Entry<MockRequest, MockResponse> entry : mockDataSetupMap.entrySet()) {
            Map map = this.processParamComparison(entry, mockServiceRequest);
            if (map == null) continue;
            return map;
        }
        return matchResponse;
    }

    private Map processParamComparison(Map.Entry<MockRequest, MockResponse> entry, MockServiceRequest mockServiceRequest) {
        if (ResponseProcessType.PARAMS.name().equalsIgnoreCase(entry.getKey().getType())) {
            JSONArray paramArray = new JSONArray(entry.getKey().getRule());
            for (int i = 0; i < paramArray.length(); ++i) {
                try {
                    HashMap context = (HashMap)new ObjectMapper().readValue(paramArray.getJSONObject(i).toString(), HashMap.class);
                    if (this.isAnyMatchPresent(mockServiceRequest, entry, context)) {
                        return this.getMatchingResponse(mockServiceRequest, entry, context);
                    }
                    continue;
                }
                catch (Exception e) {
                    log.warn(" {}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    private boolean isAnyMatchPresent(MockServiceRequest mockServiceRequest, Map.Entry<MockRequest, MockResponse> entry, HashMap context) throws JsonProcessingException {
        if (mockServiceRequest.getParams() != null && mockServiceRequest.getInput() == null && this.matchParameters(mockServiceRequest, entry, context)) {
            return true;
        }
        return this.performParameterized(mockServiceRequest, entry, context);
    }

    private boolean performParameterized(MockServiceRequest mockServiceRequest, Map.Entry<MockRequest, MockResponse> entry, HashMap context) throws JsonProcessingException {
        if (mockServiceRequest.getParameters() != null && !mockServiceRequest.getParameters().isEmpty() && mockServiceRequest.getInput() == null && this.matchParameters(mockServiceRequest, entry, context)) {
            return true;
        }
        if (mockServiceRequest.getParameters() != null && mockServiceRequest.getInput() != null && this.matchParameters(mockServiceRequest, entry, context) && this.getMatchByInput(mockServiceRequest, entry, context)) {
            return true;
        }
        return (mockServiceRequest.getParameters() == null || mockServiceRequest.getParameters().isEmpty()) && mockServiceRequest.getInput() != null && this.getMatchByInput(mockServiceRequest, entry, context);
    }

    private static AbstractMap.SimpleEntry<String, String> getDelimiter(ContentType contentType) {
        String start_param = "<";
        String end_param = ">";
        if (ContentType.XML.equals((Object)contentType)) {
            start_param = "{";
            end_param = "}";
        }
        return new AbstractMap.SimpleEntry<String, String>(start_param, end_param);
    }

    private boolean getMatchByInput(MockServiceRequest mockServiceRequest, Map.Entry<MockRequest, MockResponse> entry, Map<String, Object> context) throws JsonProcessingException {
        Map requestObjectMap = null;
        Map requestActualValueParam = null;
        Map replacedValueMap = null;
        AbstractMap.SimpleEntry<String, String> delimiter = VirtualParameterizedUtil.getDelimiter(entry.getKey().getContentType());
        if (ContentType.XML.equals((Object)entry.getKey().getContentType())) {
            List<String> existingPaths = VirtualXPaths.readXPaths(entry.getKey().getInput());
            List<String> input = null;
            input = mockServiceRequest.getInput().toString().contains("</") ? VirtualXPaths.readXPaths(mockServiceRequest.getInput().toString()) : VirtualXPaths.readXPaths(XMLConverter.objectToXML(mockServiceRequest.getInputObjectType(), mockServiceRequest.getInput()));
            List filterList = existingPaths.stream().filter(x -> x.contains("{") && x.contains("}")).map(x -> x.substring(x.lastIndexOf(58), x.lastIndexOf(61))).collect(Collectors.toList());
            List filteredListWithValue = existingPaths.stream().filter(x -> x.contains("{") && x.contains("}")).map(x -> x.substring(x.lastIndexOf(58))).map(x -> VirtualParameterizedUtil.getActualValueForAll(delimiter, x, context).toString()).collect(Collectors.toList());
            List matches = input.stream().filter(x -> x.lastIndexOf(58) < x.lastIndexOf(61)).filter(x -> filterList.contains(x.substring(x.lastIndexOf(58), x.lastIndexOf(61)))).map(x -> x.substring(x.lastIndexOf(58))).collect(Collectors.toList());
            return matches.containsAll(filteredListWithValue);
        }
        requestObjectMap = Mapson.buildMAPsonFromJson((String)entry.getKey().getInput());
        requestActualValueParam = this.isJSONValid(mockServiceRequest.getInput().toString()) ? Mapson.buildMAPsonFromJson((String)mockServiceRequest.getInput().toString()) : Mapson.buildMAPsonFromJson((String)this.objectMapper.writeValueAsString(mockServiceRequest.getInput()));
        replacedValueMap = Mapson.buildMAPsonFromJson((String)VirtualParameterizedUtil.getActualValueForAll(delimiter, entry.getKey().getInput(), context).toString());
        List parameters = requestObjectMap.entrySet().stream().filter(x -> ((String)x.getValue()).startsWith((String)delimiter.getKey()) && ((String)x.getValue()).endsWith((String)delimiter.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        Map<String, String> matches = replacedValueMap.entrySet().stream().filter(x -> parameters.contains(x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return requestActualValueParam.entrySet().containsAll(matches.entrySet());
    }

    private boolean isJSONValid(String test) {
        try {
            new JSONObject(test);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(test);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public Map<Integer, ReturnMockResponse> getMatchingResponse(MockServiceRequest mockServiceRequest, Map.Entry<MockRequest, MockResponse> entry, Map<String, Object> context) {
        HashMap<Integer, ReturnMockResponse> matchResponse = new HashMap<Integer, ReturnMockResponse>();
        if (entry.getValue().getOutput() != null) {
            entry.getValue().setOutput(VirtualParameterizedUtil.getActualValueForAll(VirtualParameterizedUtil.getDelimiter(entry.getKey().getContentType()), entry.getValue().getOutput(), context).toString());
        }
        ReturnMockResponse returnMockResponse = this.virtualServiceValidRequest.returnMockResponse(mockServiceRequest, entry, 1);
        returnMockResponse.setExactMatch(true);
        matchResponse.put(1, returnMockResponse);
        return matchResponse;
    }

    public static Object getActualValueForAll(Map.Entry<String, String> delimiter, Object object, Map<String, Object> contextObject) {
        String key = object.toString();
        if (key.indexOf(delimiter.getKey()) != -1 && key.indexOf(delimiter.getValue()) != -1) {
            String idkey = key.substring(key.indexOf(delimiter.getKey()) + 1, key.indexOf(delimiter.getValue()));
            if (contextObject.containsKey(idkey)) {
                String prefix = delimiter.getKey().contains("{") ? "\\" : "";
                String replaceValue = key.replaceAll(prefix + key.substring(key.indexOf(delimiter.getKey()), key.indexOf(delimiter.getValue()) + 1), contextObject.get(idkey).toString());
                if (replaceValue.indexOf(delimiter.getKey()) != -1 && replaceValue.indexOf(delimiter.getValue()) != -1) {
                    return VirtualParameterizedUtil.getActualValueForAll(delimiter, replaceValue, contextObject);
                }
                return replaceValue;
            }
            log.error("id key :" + idkey);
        }
        return object;
    }

    public boolean matchParameters(MockServiceRequest mockServiceRequest, Map.Entry<MockRequest, MockResponse> entry, Map<String, Object> context) {
        AbstractMap.SimpleEntry<String, String> delimiter = VirtualParameterizedUtil.getDelimiter(entry.getKey().getContentType());
        List requestMatchingParam = entry.getKey().getAvailableParams().stream().filter(x -> x.getValue().startsWith((String)delimiter.getKey()) && x.getValue().endsWith((String)delimiter.getValue())).map(VirtualServiceKeyValue::getKey).collect(Collectors.toList());
        ArrayList<VirtualServiceKeyValue> replacedParamMap = new ArrayList<VirtualServiceKeyValue>();
        for (VirtualServiceKeyValue param : entry.getKey().getAvailableParams()) {
            replacedParamMap.add(new VirtualServiceKeyValue(param.getKey(), VirtualParameterizedUtil.getActualValueForAll(delimiter, param.getValue(), context).toString()));
        }
        boolean matches = replacedParamMap.stream().filter(x -> requestMatchingParam.contains(x.getKey())).allMatch(y -> this.getObjectValue(mockServiceRequest.getParams().get(y.getKey()), y.getValue()));
        return !requestMatchingParam.isEmpty() && matches;
    }

    public boolean getObjectValue(Object actual, Object object) {
        try {
            Param param = new Param();
            param.setType(actual.getClass());
            param.setActualValue(actual.toString());
            param.setExpectedValue(object.toString());
            return ParamTypes.fromString(object.getClass().getCanonicalName()).compareParam(param);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public Map<Integer, ResponseParam> handleParameterizedRequest(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) {
        HashMap<Integer, ResponseParam> responseMap = new HashMap<Integer, ResponseParam>();
        if (mockServiceRequest.getRule() != null) {
            JSONArray paramArray = new JSONArray(mockServiceRequest.getRule().toString());
            for (int i = 0; i < paramArray.length(); ++i) {
                ResponseParam response = new ResponseParam();
                try {
                    JSONObject map = paramArray.getJSONObject(i);
                    Map context = map.toMap();
                    this.checkRequest(mockDataSetupMap, mockServiceRequest, response, context);
                    this.checkResponse(mockServiceRequest, response, context);
                }
                catch (Exception e) {
                    response.getRecords().put("error", e.getMessage());
                }
                if (response.getRecords().isEmpty()) continue;
                responseMap.put(i, response);
            }
        } else {
            ResponseParam response = new ResponseParam();
            response.getRecords().put("error", "rule data is missing");
            responseMap.put(0, response);
        }
        return responseMap;
    }

    public void checkResponse(MockServiceRequest mockServiceRequest, ResponseParam response, Map<String, Object> context) throws InvalidMockResponseException {
        if (mockServiceRequest.getOutput() != null) {
            mockServiceRequest.setOutput(VirtualParameterizedUtil.getActualValueForAll(VirtualParameterizedUtil.getDelimiter(mockServiceRequest.getContentType()), mockServiceRequest.getOutput(), context));
            VirtualServiceRequest request = new VirtualServiceRequest();
            BeanUtils.copyProperties((Object)mockServiceRequest, (Object)request);
            boolean isValidResponse = this.virtualServiceUtil.isMockResponseBodyValid(request);
            if (!isValidResponse) {
                response.getRecords().put("response", "Invalid response!");
            }
        }
    }

    public Map<Integer, ReturnMockResponse> checkRequest(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest, ResponseParam response, Map<String, Object> context) throws IOException, JAXBException {
        Map<Integer, ReturnMockResponse> returnMockResponseMap = new HashMap<Integer, ReturnMockResponse>();
        boolean checkIfExists = false;
        if (mockServiceRequest.getParams() != null && mockServiceRequest.getInput() == null) {
            VirtualParameterizedUtil.populateMapParams(mockServiceRequest.getParams(), context);
            returnMockResponseMap = this.virtualServiceValidRequest.validForParam(mockDataSetupMap, mockServiceRequest);
            boolean bl = checkIfExists = returnMockResponseMap == null || returnMockResponseMap.isEmpty();
        }
        if (mockServiceRequest.getInput() != null) {
            mockServiceRequest.setInput(VirtualParameterizedUtil.getActualValueForAll(VirtualParameterizedUtil.getDelimiter(mockServiceRequest.getContentType()), mockServiceRequest.getInput(), context));
            returnMockResponseMap = this.virtualServiceValidRequest.validObject(mockDataSetupMap, mockServiceRequest);
            boolean bl = checkIfExists = returnMockResponseMap == null || returnMockResponseMap.isEmpty();
        }
        if (checkIfExists && mockDataSetupMap.entrySet().stream().anyMatch(x -> ResponseProcessType.PARAMS.name().equalsIgnoreCase(((MockRequest)x.getKey()).getType().toLowerCase()))) {
            returnMockResponseMap = this.getParameterizedResponse(mockDataSetupMap, mockServiceRequest);
        }
        if (returnMockResponseMap != null && !returnMockResponseMap.isEmpty()) {
            response.getRecords().put("request", "Mock already Present!");
        }
        return returnMockResponseMap;
    }
}

