/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.api;

import io.virtualan.api.VirtualServiceType;
import io.virtualan.core.model.VirtualServiceKeyValue;
import java.lang.reflect.Method;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

public class ApiMethod {
    private ApiMethod() {
    }

    public static String getApiMethodParam(Method method) {
        return ApiMethod.getApiMethodParamAndURL(method).getKey();
    }

    public static VirtualServiceKeyValue getApiMethodParamAndURL(Method method) {
        VirtualServiceKeyValue virtualServiceKeyValue = ApiMethod.getSpringMethod(method);
        if (virtualServiceKeyValue != null) {
            return virtualServiceKeyValue;
        }
        virtualServiceKeyValue = ApiMethod.getGetMethod(method);
        if (virtualServiceKeyValue != null) {
            return virtualServiceKeyValue;
        }
        virtualServiceKeyValue = ApiMethod.getDeleteMethod(method);
        if (virtualServiceKeyValue != null) {
            return virtualServiceKeyValue;
        }
        virtualServiceKeyValue = ApiMethod.getPutMethod(method);
        if (virtualServiceKeyValue != null) {
            return virtualServiceKeyValue;
        }
        virtualServiceKeyValue = ApiMethod.getPostMethod(method);
        if (virtualServiceKeyValue != null) {
            return virtualServiceKeyValue;
        }
        return new VirtualServiceKeyValue("GET", null);
    }

    private static VirtualServiceKeyValue getSpringMethod(Method method) {
        VirtualServiceKeyValue virtualServiceKeyValue = null;
        RequestMapping[] annotInstance = (RequestMapping[])method.getAnnotationsByType(RequestMapping.class);
        if (annotInstance != null && annotInstance.length > 0) {
            RequestMapping requestMapping = annotInstance[0];
            virtualServiceKeyValue = new VirtualServiceKeyValue();
            virtualServiceKeyValue.setServiceType(VirtualServiceType.SPRING);
            if (requestMapping.method().length > 0) {
                virtualServiceKeyValue.setKey(requestMapping.method()[0].name());
            }
            if (requestMapping.value().length > 0) {
                virtualServiceKeyValue.setValue(requestMapping.value()[0]);
            }
        }
        return virtualServiceKeyValue;
    }

    private static VirtualServiceKeyValue getPutMethod(Method method) {
        String key = "PUT";
        VirtualServiceKeyValue virtualServiceKeyValue = null;
        PUT[] annotInstance = (PUT[])method.getAnnotationsByType(PUT.class);
        if (annotInstance != null && annotInstance.length > 0) {
            virtualServiceKeyValue = new VirtualServiceKeyValue();
            virtualServiceKeyValue.setKey(key);
            virtualServiceKeyValue.setValue(ApiMethod.getURL(method));
            virtualServiceKeyValue.setServiceType(VirtualServiceType.CXF_JAX_RS);
        } else {
            PutMapping[] annotInstanceMapping = (PutMapping[])method.getAnnotationsByType(PutMapping.class);
            if (annotInstanceMapping != null && annotInstanceMapping.length > 0) {
                virtualServiceKeyValue = new VirtualServiceKeyValue();
                virtualServiceKeyValue.setKey(key);
                virtualServiceKeyValue.setServiceType(VirtualServiceType.SPRING);
                if (annotInstanceMapping[0].value().length > 0) {
                    virtualServiceKeyValue.setValue(annotInstanceMapping[0].value()[0]);
                }
            }
        }
        return virtualServiceKeyValue;
    }

    private static VirtualServiceKeyValue getPostMethod(Method method) {
        String key = "POST";
        VirtualServiceKeyValue virtualServiceKeyValue = null;
        POST[] annotInstance = (POST[])method.getAnnotationsByType(POST.class);
        if (annotInstance != null && annotInstance.length > 0) {
            virtualServiceKeyValue = new VirtualServiceKeyValue();
            virtualServiceKeyValue.setKey(key);
            virtualServiceKeyValue.setValue(ApiMethod.getURL(method));
            virtualServiceKeyValue.setServiceType(VirtualServiceType.CXF_JAX_RS);
        } else {
            PostMapping[] annotInstanceMapping = (PostMapping[])method.getAnnotationsByType(PostMapping.class);
            if (annotInstanceMapping != null && annotInstanceMapping.length > 0) {
                virtualServiceKeyValue = new VirtualServiceKeyValue();
                virtualServiceKeyValue.setKey(key);
                virtualServiceKeyValue.setServiceType(VirtualServiceType.SPRING);
                if (annotInstanceMapping[0].value().length > 0) {
                    virtualServiceKeyValue.setValue(annotInstanceMapping[0].value()[0]);
                }
            }
        }
        return virtualServiceKeyValue;
    }

    private static VirtualServiceKeyValue getDeleteMethod(Method method) {
        String key = "DELETE";
        VirtualServiceKeyValue virtualServiceKeyValue = null;
        DELETE[] annotInstance = (DELETE[])method.getAnnotationsByType(DELETE.class);
        if (annotInstance != null && annotInstance.length > 0) {
            virtualServiceKeyValue = new VirtualServiceKeyValue();
            virtualServiceKeyValue.setKey(key);
            virtualServiceKeyValue.setValue(ApiMethod.getURL(method));
            virtualServiceKeyValue.setServiceType(VirtualServiceType.CXF_JAX_RS);
        } else {
            DeleteMapping[] annotInstanceMapping = (DeleteMapping[])method.getAnnotationsByType(DeleteMapping.class);
            if (annotInstanceMapping != null && annotInstanceMapping.length > 0) {
                virtualServiceKeyValue = new VirtualServiceKeyValue();
                virtualServiceKeyValue.setKey(key);
                virtualServiceKeyValue.setServiceType(VirtualServiceType.SPRING);
                if (annotInstanceMapping[0].value().length > 0) {
                    virtualServiceKeyValue.setValue(annotInstanceMapping[0].value()[0]);
                }
            }
        }
        return virtualServiceKeyValue;
    }

    private static VirtualServiceKeyValue getGetMethod(Method method) {
        String key = "GET";
        VirtualServiceKeyValue virtualServiceKeyValue = null;
        GET[] annotInstance = (GET[])method.getAnnotationsByType(GET.class);
        if (annotInstance != null && annotInstance.length > 0) {
            virtualServiceKeyValue = new VirtualServiceKeyValue();
            virtualServiceKeyValue.setKey(key);
            virtualServiceKeyValue.setValue(ApiMethod.getURL(method));
            virtualServiceKeyValue.setServiceType(VirtualServiceType.CXF_JAX_RS);
        } else {
            GetMapping[] annotInstanceMapping = (GetMapping[])method.getAnnotationsByType(GetMapping.class);
            if (annotInstanceMapping != null && annotInstanceMapping.length > 0) {
                virtualServiceKeyValue = new VirtualServiceKeyValue();
                virtualServiceKeyValue.setKey(key);
                virtualServiceKeyValue.setServiceType(VirtualServiceType.SPRING);
                if (annotInstanceMapping[0].value().length > 0) {
                    virtualServiceKeyValue.setValue(annotInstanceMapping[0].value()[0]);
                }
            }
        }
        return virtualServiceKeyValue;
    }

    public static String getURL(Method method) {
        Path[] annotPathInstance = (Path[])method.getAnnotationsByType(Path.class);
        if (annotPathInstance != null && annotPathInstance.length > 0) {
            Path path = annotPathInstance[0];
            return path.value();
        }
        return null;
    }
}

