/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.requestbody;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.virtualan.core.model.ContentType;
import io.virtualan.core.util.XMLConverter;
import io.virtualan.requestbody.RequestBody;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.builder.EqualsBuilder;

public enum RequestBodyTypes {
    NO_REQUEST_PARAM("NO_REQUEST_PARAM"){

        @Override
        public Object getValidMockRequestBody(RequestBody requestBody) {
            return null;
        }

        @Override
        public String getDefaultMessageBody(RequestBody requestBody) {
            return null;
        }

        @Override
        public boolean compareRequestBody(RequestBody requestBody) {
            return requestBody.getExpectedInput() == null && requestBody.getActualInput() == null;
        }
    }
    ,
    BOOLEAN("java.lang.Boolean"){

        @Override
        public Object getValidMockRequestBody(RequestBody requestBody) {
            return new Boolean(requestBody.getInputRequest());
        }

        @Override
        public String getDefaultMessageBody(RequestBody requestBody) {
            return "true/false";
        }

        @Override
        public boolean compareRequestBody(RequestBody requestBody) {
            return Boolean.parseBoolean(requestBody.getExpectedInput()) == (Boolean)requestBody.getActualInput();
        }
    }
    ,
    STRING("java.lang.String"){

        @Override
        public Object getValidMockRequestBody(RequestBody requestBody) {
            return requestBody.getInputRequest();
        }

        @Override
        public String getDefaultMessageBody(RequestBody requestBody) {
            return "Enter your data";
        }

        @Override
        public boolean compareRequestBody(RequestBody requestBody) {
            return requestBody.getExpectedInput().equals(requestBody.getActualInput());
        }
    }
    ,
    BIGDECIMAL("java.math.BigDecimal"){

        @Override
        public Object getValidMockRequestBody(RequestBody requestBody) {
            return new BigDecimal(requestBody.getInputRequest());
        }

        @Override
        public String getDefaultMessageBody(RequestBody requestBody) {
            return "0.0";
        }

        @Override
        public boolean compareRequestBody(RequestBody requestBody) {
            return new BigDecimal(requestBody.getExpectedInput()).compareTo((BigDecimal)requestBody.getActualInput()) == 0;
        }
    }
    ,
    MAP("java.util.Map"){

        @Override
        public Object getValidMockRequestBody(RequestBody requestBody) throws IOException {
            return requestBody.getObjectMapper().readValue(requestBody.getInputRequest(), HashMap.class);
        }

        @Override
        public String getDefaultMessageBody(RequestBody requestBody) {
            return "{\"additionalProp1\": \"string\",  \"additionalProp2\": \"string\",  \"additionalProp3\": \"string\"}";
        }

        @Override
        public boolean compareRequestBody(RequestBody requestBody) throws IOException {
            Map expectedMap = (Map)new ObjectMapper().readValue(requestBody.getExpectedInput(), HashMap.class);
            for (Map.Entry actualMap : ((Map)requestBody.getActualInput()).entrySet()) {
                if (requestBody.getExcludeList() != null && requestBody.getExcludeList().contains(actualMap.getKey()) || ((String)actualMap.getValue()).equals(expectedMap.get(actualMap.getKey()))) continue;
                return false;
            }
            return true;
        }
    }
    ,
    DEFAULT("Default"){

        @Override
        public Object getValidMockRequestBody(RequestBody requestBody) throws IOException {
            return requestBody.getObjectMapper().readValue(requestBody.getInputRequest(), requestBody.getInputObjectType());
        }

        @Override
        public String getDefaultMessageBody(RequestBody requestBody) throws IOException {
            try {
                return requestBody.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(requestBody.getInputObjectType().newInstance());
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                return null;
            }
        }

        @Override
        public boolean compareRequestBody(RequestBody requestBody) throws IOException, JAXBException {
            if (requestBody.getExpectedInput() == null) {
                return true;
            }
            if (ContentType.XML.equals((Object)requestBody.getContentType())) {
                if (requestBody.getInputRequest() != null) {
                    return EqualsBuilder.reflectionEquals((Object)XMLConverter.xmlToObject(requestBody.getInputObjectType(), requestBody.getExpectedInput()), (Object)XMLConverter.xmlToObject(requestBody.getInputObjectType(), requestBody.getInputRequest()), requestBody.getExcludeList());
                }
                return EqualsBuilder.reflectionEquals((Object)XMLConverter.xmlToObject(requestBody.getInputObjectType(), requestBody.getExpectedInput()), (Object)requestBody.getActualInput(), requestBody.getExcludeList());
            }
            if (requestBody.getInputRequest() != null) {
                return EqualsBuilder.reflectionEquals((Object)requestBody.getObjectMapper().readValue(requestBody.getExpectedInput(), requestBody.getInputObjectType()), (Object)requestBody.getObjectMapper().readValue(requestBody.getInputRequest(), requestBody.getInputObjectType()), requestBody.getExcludeList());
            }
            return EqualsBuilder.reflectionEquals((Object)requestBody.getObjectMapper().readValue(requestBody.getExpectedInput(), requestBody.getInputObjectType()), (Object)requestBody.getActualInput(), requestBody.getExcludeList());
        }
    };

    String type;

    public String getType() {
        return this.type;
    }

    private RequestBodyTypes(String type) {
        this.type = type;
    }

    public abstract Object getValidMockRequestBody(RequestBody var1) throws IOException;

    public abstract String getDefaultMessageBody(RequestBody var1) throws IOException;

    public abstract boolean compareRequestBody(RequestBody var1) throws IOException, JAXBException;

    public static RequestBodyTypes fromString(String requestBodyType) {
        for (RequestBodyTypes currentType : RequestBodyTypes.values()) {
            if (requestBodyType.equals(currentType.getType())) {
                return currentType;
            }
            if (!"java.util.HashMap".equals(currentType.getType()) && !"java.util.LinkedHashMap".equals(currentType.getType())) continue;
            return MAP;
        }
        return DEFAULT;
    }
}

