/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.params;

import io.virtualan.params.Param;
import java.math.BigDecimal;

public enum ParamTypes {
    BOOLEAN("java.lang.Boolean"){

        @Override
        public Object getValidMockRequestBody(Param param) {
            return new Boolean(param.getActualValue());
        }

        @Override
        public String getDefaultMessageBody(Param requestBody) {
            return "true/false";
        }

        @Override
        public boolean compareParam(Param param) {
            return Boolean.parseBoolean(param.actualValue) == Boolean.parseBoolean(param.getExpectedValue());
        }
    }
    ,
    LONG("java.lang.Long"){

        @Override
        public Object getValidMockRequestBody(Param param) {
            return new Long(param.getActualValue());
        }

        @Override
        public String getDefaultMessageBody(Param requestBody) {
            return "0L";
        }

        @Override
        public boolean compareParam(Param param) {
            return Long.parseLong(param.actualValue) == Long.parseLong(param.getExpectedValue());
        }
    }
    ,
    INTEGER("java.lang.Integer"){

        @Override
        public Object getValidMockRequestBody(Param param) {
            return new Integer(param.getActualValue());
        }

        @Override
        public String getDefaultMessageBody(Param requestBody) {
            return "0";
        }

        @Override
        public boolean compareParam(Param param) {
            return Integer.parseInt(param.actualValue) == Integer.parseInt(param.getExpectedValue());
        }
    }
    ,
    BYTE("java.lang.Byte"){

        @Override
        public Object getValidMockRequestBody(Param param) {
            return new Byte(param.getActualValue());
        }

        @Override
        public String getDefaultMessageBody(Param requestBody) {
            return "0";
        }

        @Override
        public boolean compareParam(Param param) {
            return Byte.parseByte(param.actualValue) == Byte.parseByte(param.getExpectedValue());
        }
    }
    ,
    FLOAT("java.lang.Float"){

        @Override
        public Object getValidMockRequestBody(Param param) {
            return new Float(param.getActualValue());
        }

        @Override
        public String getDefaultMessageBody(Param requestBody) {
            return "0.0";
        }

        @Override
        public boolean compareParam(Param param) {
            return Float.parseFloat(param.actualValue) == Float.parseFloat(param.getExpectedValue());
        }
    }
    ,
    DOUBLE("java.lang.Double"){

        @Override
        public Object getValidMockRequestBody(Param param) {
            return new Double(param.getActualValue());
        }

        @Override
        public String getDefaultMessageBody(Param requestBody) {
            return "0.0";
        }

        @Override
        public boolean compareParam(Param param) {
            return Double.parseDouble(param.actualValue) == Double.parseDouble(param.getExpectedValue());
        }
    }
    ,
    BIGDECIMAL("java.math.BigDecimal"){

        @Override
        public Object getValidMockRequestBody(Param param) {
            return new BigDecimal(param.getActualValue());
        }

        @Override
        public String getDefaultMessageBody(Param requestBody) {
            return "0.0";
        }

        @Override
        public boolean compareParam(Param param) {
            return new BigDecimal(param.getExpectedValue()).compareTo(new BigDecimal(param.getActualValue())) == 0;
        }
    }
    ,
    DEFAULT("Default"){

        @Override
        public Object getValidMockRequestBody(Param param) {
            return param.getActualValue();
        }

        @Override
        public String getDefaultMessageBody(Param param) {
            return "Enter your data";
        }

        @Override
        public boolean compareParam(Param param) {
            return param.getExpectedValue().equals(param.getActualValue());
        }
    };

    String type;

    public String getType() {
        return this.type;
    }

    private ParamTypes(String type) {
        this.type = type;
    }

    public abstract Object getValidMockRequestBody(Param var1);

    public abstract String getDefaultMessageBody(Param var1);

    public abstract boolean compareParam(Param var1);

    public static ParamTypes fromString(String paramType) {
        for (ParamTypes currentType : ParamTypes.values()) {
            if (!paramType.equals(currentType.getType())) continue;
            return currentType;
        }
        return DEFAULT;
    }
}

