/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.message.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.virtualan.core.VirtualServiceUtil;
import io.virtualan.core.model.ContentType;
import io.virtualan.core.model.MockRequest;
import io.virtualan.core.model.MockResponse;
import io.virtualan.core.model.MockServiceRequest;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.util.BestMatchComparator;
import io.virtualan.core.util.Converter;
import io.virtualan.core.util.ReturnMockResponse;
import io.virtualan.core.util.VirtualServiceValidRequest;
import io.virtualan.core.util.XMLConverter;
import io.virtualan.core.util.rule.ScriptExecutor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="messageUtil")
public class MessageUtil {
    private static final Logger log = LoggerFactory.getLogger(MessageUtil.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ScriptExecutor scriptExecutor;
    @Autowired
    private VirtualServiceValidRequest virtualServiceValidRequest;
    @Autowired
    private VirtualServiceUtil virtualServiceUtil;

    @PostConstruct
    public void init() {
    }

    public ReturnMockResponse isResponseExists(Map<Integer, ReturnMockResponse> returnMockResponseMap) throws IOException {
        ArrayList<ReturnMockResponse> returnMockResponseList = new ArrayList<ReturnMockResponse>(returnMockResponseMap.values());
        Collections.sort(returnMockResponseList, new BestMatchComparator());
        System.out.println("Sorted list : " + returnMockResponseList);
        ReturnMockResponse rMockResponse = (ReturnMockResponse)returnMockResponseList.iterator().next();
        if (rMockResponse != null && rMockResponse.getHeaderResponse() != null && rMockResponse.isExactMatch()) {
            return rMockResponse;
        }
        return null;
    }

    public ReturnMockResponse getMatchingRecord(VirtualServiceRequest mockTransferObject) {
        try {
            Map<MockRequest, MockResponse> mockDataSetupMap = this.virtualServiceUtil.readDynamicResponse(mockTransferObject.getResource(), mockTransferObject.getOperationId());
            MockServiceRequest mockServiceRequest = new MockServiceRequest();
            mockServiceRequest.setHeaderParams(Converter.converter(mockTransferObject.getHeaderParams()));
            mockServiceRequest.setOperationId(mockTransferObject.getOperationId());
            mockServiceRequest.setParams(Converter.converter(mockTransferObject.getAvailableParams()));
            mockServiceRequest.setResource(mockTransferObject.getResource());
            mockServiceRequest.setInput(mockTransferObject.getInput());
            mockServiceRequest.setContentType(mockTransferObject.getContentType());
            mockServiceRequest.setInputObjectType(mockTransferObject.getInputObjectType());
            Map<Integer, ReturnMockResponse> returnMockResponseMap = this.virtualServiceUtil.validateBusinessRules(mockDataSetupMap, mockServiceRequest);
            if (returnMockResponseMap == null || returnMockResponseMap.isEmpty()) {
                returnMockResponseMap = this.virtualServiceValidRequest.checkScriptResponse(mockDataSetupMap, mockServiceRequest);
            }
            if (returnMockResponseMap == null || returnMockResponseMap.isEmpty()) {
                returnMockResponseMap = this.isResponseExists(mockDataSetupMap, mockServiceRequest);
            }
            if (returnMockResponseMap == null || returnMockResponseMap.isEmpty()) {
                returnMockResponseMap = this.isResponseExists(mockDataSetupMap, mockServiceRequest);
            }
            if (returnMockResponseMap.size() > 0) {
                return this.isResponseExists(returnMockResponseMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("getMatchingRecord :: " + e.getMessage());
        }
        return null;
    }

    private Map<Integer, ReturnMockResponse> isResponseExists(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException, JAXBException {
        return this.virtualServiceValidRequest.validObject(mockDataSetupMap, mockServiceRequest);
    }

    public Long isMockAlreadyExists(VirtualServiceRequest mockTransferObject) throws Exception {
        try {
            Map<MockRequest, MockResponse> mockDataSetupMap = this.virtualServiceUtil.readDynamicResponse(mockTransferObject.getResource(), mockTransferObject.getOperationId());
            MockServiceRequest mockServiceRequest = new MockServiceRequest();
            mockServiceRequest.setHeaderParams(Converter.converter(mockTransferObject.getHeaderParams()));
            mockServiceRequest.setOperationId(mockTransferObject.getOperationId());
            mockServiceRequest.setParams(Converter.converter(mockTransferObject.getAvailableParams()));
            mockServiceRequest.setResource(mockTransferObject.getResource());
            mockServiceRequest.setContentType(mockTransferObject.getContentType());
            mockServiceRequest.setRule(mockTransferObject.getRule());
            if (mockTransferObject.getInputObjectType() != null) {
                if (mockServiceRequest.getRule() != null) {
                    this.scriptExecutor.executeScript(mockServiceRequest, new MockResponse(), mockServiceRequest.getRule().toString());
                }
                if (ContentType.XML.equals((Object)mockTransferObject.getContentType())) {
                    mockServiceRequest.setInput(XMLConverter.xmlToObject(mockTransferObject.getInputObjectType(), mockTransferObject.getInput().toString()));
                } else {
                    mockServiceRequest.setInput(this.objectMapper.readValue(mockTransferObject.getInput().toString(), mockTransferObject.getInputObjectType()));
                }
            } else {
                mockServiceRequest.setInput(mockTransferObject.getInput());
            }
            mockServiceRequest.setContentType(mockTransferObject.getContentType());
            mockServiceRequest.setInputObjectType(mockTransferObject.getInputObjectType());
            Map<Integer, ReturnMockResponse> returnMockResponseMap = this.isResponseExists(mockDataSetupMap, mockServiceRequest);
            if (returnMockResponseMap.size() > 0) {
                return this.isResposeExists(mockTransferObject, mockServiceRequest, returnMockResponseMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("isMockAlreadyExists :: " + e.getMessage());
            throw e;
        }
        return null;
    }

    public long isResposeExists(VirtualServiceRequest mockTransferObject, MockServiceRequest mockServiceRequest, Map<Integer, ReturnMockResponse> returnMockResponseMap) throws IOException {
        ArrayList<ReturnMockResponse> returnMockResponseList = new ArrayList<ReturnMockResponse>(returnMockResponseMap.values());
        Collections.sort(returnMockResponseList, new BestMatchComparator());
        log.debug("Sorted list : " + returnMockResponseList);
        ReturnMockResponse rMockResponse = (ReturnMockResponse)returnMockResponseList.iterator().next();
        if (rMockResponse != null && rMockResponse.getHeaderResponse() != null && rMockResponse.isExactMatch()) {
            return rMockResponse.getMockRequest().getVirtualServiceId();
        }
        return 0L;
    }
}

