/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MimeType;

@Service(value="xmlConverter")
public class XMLConverter {
    private static final Logger log = LoggerFactory.getLogger(XMLConverter.class);
    @Autowired
    private ObjectMapper objectMapper;

    public String returnAsXml(Method method, ResponseEntity responseEntity, String response) {
        String responseOut = null;
        responseOut = !responseEntity.getHeaders().isEmpty() && MediaType.APPLICATION_XML.compareTo((MimeType)responseEntity.getHeaders().getContentType()) == 0 ? this.convertAsXml(method, responseEntity, response) : response;
        return responseOut;
    }

    public static Object xmlToObject(Class type, String xmlString) throws JAXBException {
        StringWriter outWriter = new StringWriter();
        StreamResult result = new StreamResult(outWriter);
        try {
            JAXBContext jxbContext = JAXBContext.newInstance((Class[])new Class[]{type});
            Unmarshaller jaxbUnmarshaller = jxbContext.createUnmarshaller();
            Object object = jaxbUnmarshaller.unmarshal((Reader)new StringReader(xmlString));
            return object;
        }
        catch (JAXBException e) {
            log.error("Unable to convert as xml :" + e.getMessage());
            throw e;
        }
    }

    public static String objectToXML(Class type, Object obj) {
        StringWriter outWriter = new StringWriter();
        StreamResult result = new StreamResult(outWriter);
        try {
            JAXBContext jxbContext = JAXBContext.newInstance((Class[])new Class[]{type});
            JAXBElement jxbElement = new JAXBElement(new QName(type.getSimpleName().toLowerCase()), type, obj);
            outWriter = new StringWriter();
            result = new StreamResult(outWriter);
            Marshaller marshaller = jxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)jxbElement, (Result)result);
        }
        catch (JAXBException e) {
            log.error("Unable to convert as xml :" + e.getMessage());
        }
        return outWriter.toString();
    }

    public String convertAsXml(Method method, ResponseEntity responseEntity, String json) {
        String resposeXML = null;
        Class mySuperclass = null;
        mySuperclass = method.getReturnType();
        Class type = this.getReturnType(method);
        log.info("response type" + type + " : mySuperclass :: " + mySuperclass);
        if ((mySuperclass.equals(ResponseEntity.class) || mySuperclass.equals(Response.class)) && type != null) {
            mySuperclass = type;
        }
        try {
            if (json == null) {
                json = responseEntity.getBody().toString();
            }
            Object object = this.objectMapper.readValue(json, this.objectMapper.constructType((Type)mySuperclass));
            resposeXML = XMLConverter.objectToXML(mySuperclass, object);
        }
        catch (JsonParseException | JsonMappingException e) {
            log.error("Unable to convert as object :" + e.getMessage());
        }
        catch (IOException e) {
            log.error("Unable to convert as object :" + e.getMessage());
        }
        return resposeXML;
    }

    public Class getReturnType(Method method) {
        try {
            return (Class)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            log.warn("Unable to convert as class : " + method.getGenericReturnType());
            return null;
        }
    }
}

