/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.virtualan.core.VirtualServiceUtil;
import io.virtualan.core.model.ContentType;
import io.virtualan.core.model.MockRequest;
import io.virtualan.core.model.MockResponse;
import io.virtualan.core.model.MockServiceRequest;
import io.virtualan.core.model.VirtualServiceApiResponse;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.util.ReturnMockResponse;
import io.virtualan.core.util.ScriptErrorException;
import io.virtualan.core.util.VirtualServiceParamComparator;
import io.virtualan.core.util.XMLConverter;
import io.virtualan.core.util.rule.RuleEvaluator;
import io.virtualan.core.util.rule.ScriptExecutor;
import io.virtualan.mapson.Mapson;
import io.virtualan.requestbody.RequestBody;
import io.virtualan.requestbody.RequestBodyTypes;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="virtualServiceValidRequest")
public class VirtualServiceValidRequest {
    private static final Logger log = LoggerFactory.getLogger(VirtualServiceUtil.class);
    @Autowired
    private RuleEvaluator ruleEvaluator;
    @Autowired
    private VirtualServiceUtil virtualServiceUtil;
    @Autowired
    private ScriptExecutor scriptExecutor;
    @Autowired
    private VirtualServiceParamComparator virtualServiceParamComparator;
    @Autowired
    private ObjectMapper objectMapper;

    private ObjectMapper getObjectMapper() {
        this.objectMapper.findAndRegisterModules();
        return this.objectMapper.enable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    public boolean validResponse(VirtualServiceRequest mockTransferObjectActual, VirtualServiceRequest mockTransferObject) throws ClassNotFoundException, IOException {
        VirtualServiceApiResponse apiResponse = mockTransferObjectActual.getResponseType().get(mockTransferObject.getHttpStatusCode());
        if (apiResponse != null && apiResponse.getObjectType() != null && mockTransferObject.getOutput() != null) {
            this.objectMapper.readValue(mockTransferObject.getOutput().toString(), Class.forName(apiResponse.getObjectType()));
        }
        return true;
    }

    public final Map<Integer, ReturnMockResponse> validForParam(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            this.buildRequestBody(mockServiceRequest, mockRequestResponse);
            int numberAttrMatch = this.virtualServiceParamComparator.compareQueryParams(mockRequestResponse.getKey(), mockServiceRequest);
            if (numberAttrMatch == 0) continue;
            ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, numberAttrMatch);
            System.out.println(numberAttrMatch + " : " + mockRequestResponse.getKey().getAvailableParams().size());
            returnMockResponse.setExactMatch(numberAttrMatch == mockRequestResponse.getKey().getAvailableParams().size());
            matchMap.put(++count, returnMockResponse);
        }
        return matchMap;
    }

    public Map<Integer, ReturnMockResponse> validBusinessRuleForInputObject(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            if (!"RULE".equalsIgnoreCase(mockRequestResponse.getKey().getType())) continue;
            log.debug("Rule key : " + mockRequestResponse.getKey().getRule());
            log.debug("Rule Input : " + mockServiceRequest);
            log.debug("Rule evaluated flag :" + this.ruleEvaluator.expressionEvaluator(mockServiceRequest, mockRequestResponse.getKey().getRule()));
            if (!this.ruleEvaluator.expressionEvaluator(mockServiceRequest, mockRequestResponse.getKey().getRule())) continue;
            ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, 1);
            System.out.println("Successful expression Rule evaluated : ");
            returnMockResponse.setExactMatch(true);
            matchMap.put(count, returnMockResponse);
        }
        System.out.println("Rule evaluated Ended : " + matchMap);
        return matchMap;
    }

    public Map<Integer, ReturnMockResponse> checkScriptResponse(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException, ScriptErrorException {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            if (!"SCRIPT".equalsIgnoreCase(mockRequestResponse.getKey().getType())) continue;
            log.debug("Script : " + mockRequestResponse.getKey().getRule());
            log.debug("Script Input : " + mockServiceRequest);
            try {
                MockResponse mockResponse = new MockResponse();
                mockResponse = this.scriptExecutor.executeScript(mockServiceRequest, mockResponse, mockRequestResponse.getKey().getRule());
                log.debug("Script output expected : " + mockResponse);
                if (mockResponse != null) {
                    ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, 1);
                    returnMockResponse.setMockResponse(mockResponse);
                    System.out.println("Successful expression Rule evaluated : ");
                    returnMockResponse.setExactMatch(true);
                    matchMap.put(count, returnMockResponse);
                }
            }
            catch (Exception e) {
                log.warn("Oh!!! check the groovy script... Script was not working as expected configuration? " + e.getMessage());
                throw new ScriptErrorException("Oh!!! check the groovy script... Script was not working as expected configuration? " + e.getMessage());
            }
            return matchMap;
        }
        System.out.println("Rule evaluated Ended : " + matchMap);
        return matchMap;
    }

    public Map<Integer, ReturnMockResponse> validObject(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException, JAXBException {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        if (ContentType.XML.equals((Object)mockServiceRequest.getContentType())) {
            return this.virtualServiceUtil.isResponseExists(mockDataSetupMap, mockServiceRequest);
        }
        String jsonString = mockServiceRequest.getInputObjectType() != null && mockServiceRequest.getInputObjectType().equals(mockServiceRequest.getInput().getClass()) ? this.getObjectMapper().writeValueAsString(mockServiceRequest.getInput()) : mockServiceRequest.getInput().toString();
        Map actualMap = Mapson.buildMAPsonFromJson((String)jsonString);
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            Map expectedMap;
            RequestBody requestBody = this.buildRequestBody(mockServiceRequest, mockRequestResponse);
            int numberAttrMatch = this.virtualServiceParamComparator.compareQueryParams(mockRequestResponse.getKey(), mockServiceRequest);
            String expectedJSON = null;
            if (ContentType.XML.equals((Object)mockRequestResponse.getKey().getContentType())) {
                Object object = XMLConverter.xmlToObject(mockServiceRequest.getInputObjectType(), mockRequestResponse.getKey().getInput());
                expectedJSON = this.getObjectMapper().writeValueAsString(object);
            } else {
                expectedJSON = mockRequestResponse.getKey().getInput();
            }
            if (!this.areEqual(actualMap, expectedMap = Mapson.buildMAPsonFromJson((String)expectedJSON))) continue;
            ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, numberAttrMatch);
            boolean isMatched = this.virtualServiceParamComparator.isAllParamPresent(mockServiceRequest, returnMockResponse);
            returnMockResponse.setExactMatch(isMatched);
            matchMap.put(++count, returnMockResponse);
        }
        return matchMap;
    }

    private boolean areEqual(Map<String, String> first, Map<String, String> second) {
        if (first.size() != second.size()) {
            return false;
        }
        return first.entrySet().stream().allMatch(e -> ((String)e.getValue()).equals(second.get(e.getKey())));
    }

    public Map<Integer, ReturnMockResponse> validForInputObject(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException, JAXBException {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            ReturnMockResponse returnMockResponse;
            int numberAttrMatch = this.virtualServiceParamComparator.compareQueryParams(mockRequestResponse.getKey(), mockServiceRequest);
            if ("RULE".equalsIgnoreCase(mockServiceRequest.getType()) || "RULE".equalsIgnoreCase(mockRequestResponse.getKey().getType())) {
                if (mockServiceRequest.getRule() == null || !mockServiceRequest.getRule().equals(mockRequestResponse.getKey().getRule())) continue;
                returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, numberAttrMatch);
                returnMockResponse.setExactMatch(true);
                matchMap.put(++count, returnMockResponse);
                return matchMap;
            }
            if ("SCRIPT".equalsIgnoreCase(mockServiceRequest.getType()) || "SCRIPT".equalsIgnoreCase(mockRequestResponse.getKey().getType())) {
                if ((mockServiceRequest.getRule() == null || !mockServiceRequest.getRule().equals(mockRequestResponse.getKey().getRule())) && !"SCRIPT".equalsIgnoreCase(mockRequestResponse.getKey().getType())) continue;
                returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, numberAttrMatch);
                returnMockResponse.setExactMatch(true);
                matchMap.put(++count, returnMockResponse);
                return matchMap;
            }
            if (!"RESPONSE".equalsIgnoreCase(mockRequestResponse.getKey().getType())) continue;
            RequestBody requestBody = this.buildRequestBody(mockServiceRequest, mockRequestResponse);
            if (numberAttrMatch == 0 || !RequestBodyTypes.fromString(mockServiceRequest.getInputObjectType().getTypeName()).compareRequestBody(requestBody)) continue;
            ReturnMockResponse returnMockResponse2 = this.returnMockResponse(mockServiceRequest, mockRequestResponse, numberAttrMatch);
            returnMockResponse2.setExactMatch(mockRequestResponse.getKey().getAvailableParams().size() == 0 ? true : numberAttrMatch == mockRequestResponse.getKey().getAvailableParams().size() && RequestBodyTypes.fromString(mockServiceRequest.getInputObjectType().getTypeName()).compareRequestBody(requestBody));
            matchMap.put(++count, returnMockResponse2);
        }
        return matchMap;
    }

    public Map<Integer, ReturnMockResponse> validForNoParam(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException, JAXBException {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            ReturnMockResponse returnMockResponse;
            int numberAttrMatch;
            RequestBody requestBody = this.buildRequestBody(mockServiceRequest, mockRequestResponse);
            if (RequestBodyTypes.fromString("NO_REQUEST_PARAM").compareRequestBody(requestBody) && (mockServiceRequest.getHeaderParams() == null || mockServiceRequest.getHeaderParams().isEmpty())) {
                if (!mockRequestResponse.getKey().getAvailableParams().isEmpty()) continue;
                numberAttrMatch = 1;
                returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, 1);
                returnMockResponse.setExactMatch(true);
                matchMap.put(++count, returnMockResponse);
                continue;
            }
            numberAttrMatch = this.virtualServiceParamComparator.compareQueryParams(mockRequestResponse.getKey(), mockServiceRequest);
            if (numberAttrMatch == 0) continue;
            returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, numberAttrMatch);
            returnMockResponse.setExactMatch(numberAttrMatch == mockRequestResponse.getKey().getAvailableParams().size());
            matchMap.put(++count, returnMockResponse);
        }
        return matchMap;
    }

    private RequestBody buildRequestBody(MockServiceRequest mockServiceRequest, Map.Entry<MockRequest, MockResponse> mockRequestResponse) {
        RequestBody requestBody = new RequestBody();
        requestBody.setObjectMapper(this.getObjectMapper());
        requestBody.setExcludeList(mockRequestResponse.getKey().getExcludeSet());
        requestBody.setExpectedInput(mockRequestResponse.getKey().getInput());
        requestBody.setInputObjectType(mockServiceRequest.getInputObjectType());
        requestBody.setActualInput(mockServiceRequest.getInput());
        requestBody.setContentType(mockRequestResponse.getKey().getContentType());
        return requestBody;
    }

    public ReturnMockResponse returnMockResponse(MockServiceRequest mockServiceRequest, Map.Entry<MockRequest, MockResponse> mockRequestResponse, int numberAttrMatch) {
        ReturnMockResponse returnMockResponse = new ReturnMockResponse();
        returnMockResponse.setMockResponse(mockRequestResponse.getValue());
        returnMockResponse.setHeaderResponse(mockServiceRequest.getHeaderParams());
        returnMockResponse.setMockRequest(mockRequestResponse.getKey());
        returnMockResponse.setNumberAttrMatch(numberAttrMatch);
        return returnMockResponse;
    }
}

