/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import io.virtualan.core.model.VirtualServiceKeyValue;
import io.virtualan.core.util.ReturnMockResponse;
import java.util.Comparator;

public class BestMatchComparator
implements Comparator<ReturnMockResponse> {
    @Override
    public int compare(ReturnMockResponse returnMockResponse1, ReturnMockResponse returnMockResponse2) {
        if (returnMockResponse2.getNumberAttrMatch() == returnMockResponse1.getNumberAttrMatch() && this.isSame(returnMockResponse1, returnMockResponse2)) {
            return 0;
        }
        if (returnMockResponse2.getNumberAttrMatch() == returnMockResponse1.getNumberAttrMatch() && this.isBestMatch(returnMockResponse1)) {
            return -1;
        }
        if (returnMockResponse2.getNumberAttrMatch() >= returnMockResponse1.getNumberAttrMatch() && this.isBestMatch(returnMockResponse2)) {
            return 1;
        }
        return -1;
    }

    private boolean isBestMatch(ReturnMockResponse returnMockResponse) {
        return returnMockResponse.getMockRequest().getAvailableParams() != null && returnMockResponse.getMockRequest().getAvailableParams().size() == returnMockResponse.getNumberAttrMatch();
    }

    private boolean isSame(ReturnMockResponse returnMockResponse1, ReturnMockResponse returnMockResponse2) {
        boolean isSame = false;
        if (this.isBestMatch(returnMockResponse1) && this.isBestMatch(returnMockResponse2) && returnMockResponse1.getMockRequest().getAvailableParams().size() == returnMockResponse2.getMockRequest().getAvailableParams().size() && returnMockResponse1.getNumberAttrMatch() == returnMockResponse2.getNumberAttrMatch()) {
            isSame = true;
            for (VirtualServiceKeyValue virtualServiceKeyValue1 : returnMockResponse1.getMockRequest().getAvailableParams()) {
                for (VirtualServiceKeyValue virtualServiceKeyValue2 : returnMockResponse2.getMockRequest().getAvailableParams()) {
                    if (virtualServiceKeyValue1.getKey().equals(virtualServiceKeyValue2.getKey()) && virtualServiceKeyValue1.getValue().equals(virtualServiceKeyValue2.getValue())) continue;
                    return false;
                }
            }
        }
        return isSame;
    }
}

