/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.virtualan.api.ApiType;
import io.virtualan.api.VirtualServiceType;
import io.virtualan.api.WSResource;
import io.virtualan.core.InvalidMockResponseException;
import io.virtualan.core.VirtualServiceInfo;
import io.virtualan.core.VirtualServiceInfoFactory;
import io.virtualan.core.model.ContentType;
import io.virtualan.core.model.MockRequest;
import io.virtualan.core.model.MockResponse;
import io.virtualan.core.model.MockServiceRequest;
import io.virtualan.core.model.VirtualServiceKeyValue;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.model.VirtualServiceStatus;
import io.virtualan.core.soap.SoapFaultException;
import io.virtualan.core.util.BestMatchComparator;
import io.virtualan.core.util.Converter;
import io.virtualan.core.util.ReturnMockResponse;
import io.virtualan.core.util.ScriptErrorException;
import io.virtualan.core.util.VirtualServiceParamComparator;
import io.virtualan.core.util.VirtualServiceValidRequest;
import io.virtualan.core.util.XMLConverter;
import io.virtualan.core.util.rule.ScriptExecutor;
import io.virtualan.custom.message.ResponseException;
import io.virtualan.requestbody.RequestBody;
import io.virtualan.requestbody.RequestBodyTypes;
import io.virtualan.service.VirtualService;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service(value="virtualServiceUtil")
public class VirtualServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(VirtualServiceUtil.class);
    @Autowired
    private VirtualServiceValidRequest virtualServiceValidRequest;
    @Autowired
    private VirtualService virtualService;
    @Autowired
    private ScriptExecutor scriptExecutor;
    @Autowired
    private Converter converter;
    @Autowired
    private MessageSource messageSource;
    private final Locale locale = LocaleContextHolder.getLocale();
    @Autowired
    private VirtualServiceParamComparator virtualServiceParamComparator;
    @Autowired
    private XMLConverter xmlConverter;
    @Autowired
    private ObjectMapper objectMapper;
    private VirtualServiceType virtualServiceType;
    @Autowired
    private VirtualServiceInfoFactory virtualServiceInfoFactory;
    private VirtualServiceInfo virtualServiceInfo;

    public VirtualServiceType getVirtualServiceType() {
        return this.virtualServiceType;
    }

    public void setVirtualServiceType(VirtualServiceType virtualServiceType) {
        if (virtualServiceType != null) {
            this.setVirtualServiceInfo(this.virtualServiceInfoFactory.getVirtualServiceInfo(virtualServiceType.getType()));
            this.virtualServiceType = virtualServiceType;
        }
    }

    @PostConstruct
    @Order(value=1)
    public void init() throws ClassNotFoundException, JsonProcessingException, InstantiationException, IllegalAccessException {
        this.setVirtualServiceType(ApiType.findApiType());
        if (this.getVirtualServiceType() != null) {
            this.virtualServiceInfo = this.getVirtualServiceInfo();
            this.virtualServiceInfo.loadVirtualServices();
            this.virtualServiceInfo.setResourceParent(this.virtualServiceInfo.loadMapper());
        } else if (this.getVirtualServiceType() == null) {
            this.setVirtualServiceType(VirtualServiceType.NON_REST);
            this.virtualServiceInfo = this.getVirtualServiceInfo();
        }
    }

    public VirtualServiceInfo getVirtualServiceInfo() {
        return this.virtualServiceInfo;
    }

    private void setVirtualServiceInfo(VirtualServiceInfo virtualServiceInfo) {
        this.virtualServiceInfo = virtualServiceInfo;
    }

    private ObjectMapper getObjectMapper() {
        this.objectMapper.findAndRegisterModules();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return this.objectMapper.enable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    public Map<String, String> getHttpStatusMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (HttpStatus status : HttpStatus.values()) {
            map.put(String.valueOf(status.value()), status.name());
        }
        return map;
    }

    public Map<MockRequest, MockResponse> readDynamicResponse(String resource, String operationId) {
        HashMap<MockRequest, MockResponse> mockResponseMap = new HashMap<MockRequest, MockResponse>();
        try {
            List<VirtualServiceRequest> mockTransferObjectList = this.virtualService.readByOperationId(resource, operationId);
            for (VirtualServiceRequest mockTransferObject : mockTransferObjectList) {
                String input = mockTransferObject.getInput() != null ? mockTransferObject.getInput().toString() : null;
                String output = mockTransferObject.getOutput() != null ? mockTransferObject.getOutput().toString() : null;
                HashSet<String> excludeSet = null;
                if (mockTransferObject.getExcludeList() != null) {
                    excludeSet = new HashSet<String>(Arrays.asList(mockTransferObject.getExcludeList().split(",")));
                }
                MockRequest mockRequest = new MockRequest();
                mockRequest.setVirtualServiceId(mockTransferObject.getId());
                mockRequest.setUsageCount(mockTransferObject.getUsageCount());
                mockRequest.setInput(input);
                mockRequest.setContentType(mockTransferObject.getContentType());
                mockRequest.setRule(mockTransferObject.getRule());
                mockRequest.setType(mockTransferObject.getType());
                mockRequest.setExcludeSet(excludeSet);
                mockRequest.setAvailableParams(mockTransferObject.getAvailableParams());
                mockRequest.setMethod(mockTransferObject.getMethod());
                MockResponse mockResponse = new MockResponse(output, mockTransferObject.getHttpStatusCode());
                mockResponse.setHeaderParams(mockTransferObject.getHeaderParams());
                mockResponseMap.put(mockRequest, mockResponse);
            }
        }
        catch (Exception e) {
            log.error("Rest Mock API Response for " + operationId + " has not loaded : " + e.getMessage());
        }
        return mockResponseMap;
    }

    public void findOperationIdForService(VirtualServiceRequest mockLoadRequest) {
        String resourceUrl;
        LinkedList<String> resouceSplitterList;
        if (mockLoadRequest.getOperationId() == null && this.virtualServiceInfo != null && (resouceSplitterList = new LinkedList<String>(Arrays.asList((resourceUrl = mockLoadRequest.getUrl().substring(1)).split("/")))).size() > 0) {
            String operationId = this.virtualServiceInfo.getOperationId(mockLoadRequest.getMethod(), this.virtualServiceInfo.getResourceParent(), resouceSplitterList);
            mockLoadRequest.setOperationId(operationId);
            mockLoadRequest.setResource((String)resouceSplitterList.get(0));
        }
    }

    public ResponseEntity checkIfServiceDataAlreadyExists(VirtualServiceRequest virtualServiceRequest) throws IOException, JAXBException {
        Long id = this.isMockAlreadyExists(virtualServiceRequest);
        if (id != null && id != 0L) {
            VirtualServiceStatus virtualServiceStatus = new VirtualServiceStatus(this.messageSource.getMessage("VS_DATA_ALREADY_EXISTS", null, this.locale));
            virtualServiceRequest.setId(id);
            virtualServiceRequest = this.converter.convertAsJson(virtualServiceRequest);
            virtualServiceStatus.setVirtualServiceRequest(virtualServiceRequest);
            return new ResponseEntity((Object)virtualServiceStatus, HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    public Long isMockAlreadyExists(VirtualServiceRequest mockTransferObject) throws IOException, JAXBException {
        try {
            Map<MockRequest, MockResponse> mockDataSetupMap = this.readDynamicResponse(mockTransferObject.getResource(), mockTransferObject.getOperationId());
            MockServiceRequest mockServiceRequest = new MockServiceRequest();
            Class inputObjectType = this.getVirtualServiceInfo().getInputType(mockTransferObject);
            mockServiceRequest.setHeaderParams(Converter.converter(mockTransferObject.getHeaderParams()));
            mockServiceRequest.setOperationId(mockTransferObject.getOperationId());
            mockServiceRequest.setInputObjectType(inputObjectType);
            mockServiceRequest.setType(mockTransferObject.getType());
            mockServiceRequest.setRule(mockTransferObject.getRule());
            mockServiceRequest.setParams(Converter.converter(mockTransferObject.getAvailableParams()));
            mockServiceRequest.setResource(mockTransferObject.getResource());
            if (mockServiceRequest.getRule() != null) {
                this.scriptExecutor.executeScript(mockServiceRequest, new MockResponse(), mockServiceRequest.getRule().toString());
            }
            if (inputObjectType != null && mockTransferObject.getInput() != null) {
                mockServiceRequest.setInput(this.getObjectMapper().readValue(mockTransferObject.getInput().toString(), inputObjectType));
            } else if (mockTransferObject.getInput() != null) {
                mockServiceRequest.setInput(mockTransferObject.getInput().toString());
            }
            Map<Integer, ReturnMockResponse> returnMockResponseMap = this.isResponseExists(mockDataSetupMap, mockServiceRequest);
            if (returnMockResponseMap.size() > 0) {
                return this.isResposeExists(mockTransferObject, inputObjectType, mockServiceRequest, returnMockResponseMap);
            }
        }
        catch (Exception e) {
            log.error("isMockAlreadyExists :: " + e.getMessage());
            throw e;
        }
        return null;
    }

    private long isResposeExists(VirtualServiceRequest mockTransferObject, Class inputObjectType, MockServiceRequest mockServiceRequest, Map<Integer, ReturnMockResponse> returnMockResponseMap) throws IOException, JAXBException {
        ArrayList<ReturnMockResponse> returnMockResponseList = new ArrayList<ReturnMockResponse>(returnMockResponseMap.values());
        Collections.sort(returnMockResponseList, new BestMatchComparator());
        log.debug("Sorted list : " + returnMockResponseList);
        ReturnMockResponse rMockResponse = (ReturnMockResponse)returnMockResponseList.iterator().next();
        if (rMockResponse != null && rMockResponse.getHeaderResponse() != null) {
            RequestBody requestBody = this.buildRequestBody(mockTransferObject, inputObjectType, mockServiceRequest, rMockResponse);
            boolean isBodyMatch = false;
            if (inputObjectType != null) {
                isBodyMatch = RequestBodyTypes.fromString(inputObjectType.getTypeName()).compareRequestBody(requestBody);
            }
            return this.checkExistsInEachCatagory(mockTransferObject, mockServiceRequest, rMockResponse, isBodyMatch);
        }
        return 0L;
    }

    private RequestBody buildRequestBody(VirtualServiceRequest mockTransferObject, Class inputObjectType, MockServiceRequest mockServiceRequest, ReturnMockResponse rMockResponse) {
        RequestBody requestBody = new RequestBody();
        requestBody.setObjectMapper(this.getObjectMapper());
        requestBody.setExcludeList(rMockResponse.getMockRequest().getExcludeSet());
        requestBody.setExpectedInput(rMockResponse.getMockRequest().getInput());
        requestBody.setInputObjectType(inputObjectType);
        requestBody.setInputRequest(mockTransferObject.getInput() != null ? mockTransferObject.getInput().toString() : null);
        requestBody.setContentType(rMockResponse.getMockRequest().getContentType());
        return requestBody;
    }

    private long checkExistsInEachCatagory(VirtualServiceRequest mockTransferObject, MockServiceRequest mockServiceRequest, ReturnMockResponse rMockResponse, boolean isBodyMatch) {
        if (mockServiceRequest.getParams() == null || mockServiceRequest.getParams().isEmpty()) {
            return this.checkExistsInEachCatagoryForNoParam(mockServiceRequest, rMockResponse);
        }
        if (mockServiceRequest.getParams() != null && mockServiceRequest.getParams().size() > 0 && mockTransferObject.getInput() != null) {
            if (rMockResponse.getMockRequest().getAvailableParams().size() == mockServiceRequest.getParams().size() && isBodyMatch) {
                return this.checkExistsInEachCatagoryForNoParam(mockServiceRequest, rMockResponse);
            }
        } else {
            if (mockServiceRequest.getParams() != null && mockServiceRequest.getParams().size() > 0) {
                return this.checkExistsInEachCatagoryForParam(mockServiceRequest, rMockResponse);
            }
            if (mockTransferObject.getInput() != null && isBodyMatch) {
                return rMockResponse.getMockRequest().getVirtualServiceId();
            }
        }
        return 0L;
    }

    private long checkExistsInEachCatagoryForParam(MockServiceRequest mockServiceRequest, ReturnMockResponse rMockResponse) {
        if (rMockResponse.getMockRequest().getAvailableParams().size() == mockServiceRequest.getParams().size() && this.virtualServiceParamComparator.isAllParamPresent(mockServiceRequest, rMockResponse)) {
            return rMockResponse.getMockRequest().getVirtualServiceId();
        }
        return 0L;
    }

    private long checkExistsInEachCatagoryForNoParam(MockServiceRequest mockServiceRequest, ReturnMockResponse rMockResponse) {
        if (this.virtualServiceParamComparator.isAllParamPresent(mockServiceRequest, rMockResponse)) {
            return rMockResponse.getMockRequest().getVirtualServiceId();
        }
        return 0L;
    }

    public boolean isMockResponseBodyValid(VirtualServiceRequest mockTransferObject) throws InvalidMockResponseException {
        boolean isValid = true;
        try {
            VirtualServiceRequest mockTransferObjectActual = this.virtualServiceInfo.getResponseType(mockTransferObject);
            if (!mockTransferObjectActual.getResponseType().isEmpty() && this.virtualServiceValidRequest.validResponse(mockTransferObjectActual, mockTransferObject)) {
                isValid = true;
            }
        }
        catch (Exception e) {
            throw new InvalidMockResponseException(e);
        }
        return isValid;
    }

    public Map<Integer, ReturnMockResponse> validateBusinessRules(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException {
        return this.virtualServiceValidRequest.validBusinessRuleForInputObject(mockDataSetupMap, mockServiceRequest);
    }

    public Map<Integer, ReturnMockResponse> isResponseExists(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException, JAXBException {
        if ((mockServiceRequest.getParams() == null || mockServiceRequest.getParams().isEmpty()) && mockServiceRequest.getInput() == null) {
            return this.virtualServiceValidRequest.validForNoParam(mockDataSetupMap, mockServiceRequest);
        }
        if ("RULE".equalsIgnoreCase(mockServiceRequest.getType()) || mockServiceRequest.getInput() != null) {
            return this.virtualServiceValidRequest.validForInputObject(mockDataSetupMap, mockServiceRequest);
        }
        if (mockServiceRequest.getParams() != null && mockServiceRequest.getParams().size() > 0) {
            return this.virtualServiceValidRequest.validForParam(mockDataSetupMap, mockServiceRequest);
        }
        return null;
    }

    public Object returnResponse(Method method, MockServiceRequest mockServiceRequest) throws IOException, ResponseException, JSONException, JAXBException {
        log.info(" mockServiceRequest.getResource() : " + mockServiceRequest.getResource());
        Map<MockRequest, MockResponse> mockDataSetupMap = this.readDynamicResponse(mockServiceRequest.getResource(), mockServiceRequest.getOperationId());
        Map<Integer, ReturnMockResponse> returnMockResponseMap = this.validateBusinessRules(mockDataSetupMap, mockServiceRequest);
        if (returnMockResponseMap == null || returnMockResponseMap.isEmpty()) {
            try {
                returnMockResponseMap = this.virtualServiceValidRequest.checkScriptResponse(mockDataSetupMap, mockServiceRequest);
            }
            catch (ScriptErrorException e) {
                log.error("Error  in Script configuration :" + e.getMessage());
            }
        }
        if (returnMockResponseMap == null || returnMockResponseMap.isEmpty()) {
            returnMockResponseMap = this.isResponseExists(mockDataSetupMap, mockServiceRequest);
        }
        log.debug("number of matches : " + returnMockResponseMap.size());
        ResponseEntity responseEntity = null;
        ReturnMockResponse rMockResponse = null;
        if (returnMockResponseMap.size() > 0) {
            ArrayList<ReturnMockResponse> returnMockResponseList = new ArrayList<ReturnMockResponse>(returnMockResponseMap.values());
            Collections.sort(returnMockResponseList, new BestMatchComparator());
            log.debug("Sorted list : " + returnMockResponseList);
            rMockResponse = returnMockResponseList.stream().filter(x -> x.isExactMatch()).findAny().orElse(null);
            if (rMockResponse != null) {
                rMockResponse = (ReturnMockResponse)returnMockResponseList.iterator().next();
                if (WSResource.isExists(method)) {
                    return this.returnSoapResponse(method, rMockResponse);
                }
                responseEntity = rMockResponse.getHeaderResponse() != null ? this.buildResponseEntity(rMockResponse.getMockResponse(), rMockResponse.getHeaderResponse()) : this.buildResponseEntity(rMockResponse.getMockResponse(), null);
                if (responseEntity != null) {
                    this.virtualService.updateUsageTime(rMockResponse.getMockRequest());
                    return this.returnResponse(method, responseEntity, responseEntity.getBody() != null ? responseEntity.getBody().toString() : null);
                }
            }
        } else {
            log.error(" Unable to find matching for the given request >>> " + mockServiceRequest);
        }
        return this.mockResponseNotFoundorSet(method, mockDataSetupMap, mockServiceRequest);
    }

    private Object returnSoapResponse(Method method, ReturnMockResponse rMockResponse) throws JAXBException {
        if (rMockResponse.getMockResponse().getOutput() != null) {
            if (ContentType.XML.equals((Object)rMockResponse.getMockRequest().getContentType())) {
                return XMLConverter.xmlToObject(method.getReturnType(), rMockResponse.getMockResponse().getOutput());
            }
            Type mySuperclass = null;
            try {
                mySuperclass = method.getGenericReturnType();
                return this.objectMapper.readValue(rMockResponse.getMockResponse().getOutput(), this.objectMapper.constructType(mySuperclass));
            }
            catch (Exception ex) {
                log.error(" GenericReturnType  >>> mySuperclass " + mySuperclass);
                throw new SoapFaultException("MOCK NOT FOUND (" + ex.getMessage() + ")  GenericReturnType  >>> mySuperclass " + method.getReturnType());
            }
        }
        throw new SoapFaultException("MOCK NOT FOUND");
    }

    private Object returnResponse(Method method, ResponseEntity responseEntity, String response) throws ResponseException {
        log.debug(" responseEntity.getHeaders() :" + responseEntity.getHeaders());
        if (response != null) {
            String responseOut = this.xmlConverter.returnAsXml(method, responseEntity, response);
            if (method.getReturnType().equals(Response.class)) {
                return Response.status((int)responseEntity.getStatusCode().value()).entity((Object)responseOut).build();
            }
            if (method.getReturnType().equals(ResponseEntity.class)) {
                return new ResponseEntity((Object)responseOut, (MultiValueMap)responseEntity.getHeaders(), responseEntity.getStatusCode());
            }
            Type mySuperclass = null;
            try {
                mySuperclass = method.getGenericReturnType();
                this.objectMapper.readValue(response, this.objectMapper.constructType(mySuperclass));
                return this.objectMapper.readValue(response, this.objectMapper.constructType(mySuperclass));
            }
            catch (Exception e) {
                log.error(" GenericReturnType  >>> mySuperclass " + mySuperclass);
            }
        }
        if (responseEntity != null) {
            if (WSResource.isExists(method)) {
                String faultMsg = "MOC SERVER ERROR";
                if (responseEntity.getBody() != null) {
                    faultMsg = responseEntity.getBody().toString();
                }
                SoapFaultException SoapFaultException2 = new SoapFaultException(faultMsg);
                throw SoapFaultException2;
            }
            ResponseException responseException = new ResponseException();
            if (VirtualServiceType.CXF_JAX_RS.compareTo(this.getVirtualServiceType()) == 0) {
                responseException.setResponse(Response.status((int)responseEntity.getStatusCode().value()).entity(responseEntity.getBody()).build());
                throw new WebApplicationException(responseException.getResponse());
            }
            if (VirtualServiceType.SPRING.compareTo(this.getVirtualServiceType()) == 0) {
                responseException.setResponseEntity(responseEntity);
                throw responseException;
            }
        } else {
            log.error("Response entity is null");
        }
        return null;
    }

    private Object mockResponseNotFoundorSet(Method method, Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws NoSuchMessageException, ResponseException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (mockDataSetupMap.size() > 0) {
            return this.returnResponse(method, new ResponseEntity((Object)this.messageSource.getMessage("VS_RESPONSE_NOT_FOUND", null, this.locale), (MultiValueMap)headers, HttpStatus.INTERNAL_SERVER_ERROR), null);
        }
        log.error("Mock Response was not defined for the given input");
        return this.returnResponse(method, new ResponseEntity((Object)this.messageSource.getMessage("VS_DATA_NOT_SET", null, this.locale), (MultiValueMap)headers, HttpStatus.INTERNAL_SERVER_ERROR), null);
    }

    private ResponseEntity buildResponseEntity(MockResponse mockResponse, Map<String, String> headerMap) {
        HttpHeaders headers = this.buildHeader(mockResponse, headerMap);
        return new ResponseEntity((Object)mockResponse.getOutput(), (MultiValueMap)headers, HttpStatus.valueOf((int)Integer.parseInt(mockResponse.getHttpStatusCode())));
    }

    private HttpHeaders buildHeader(MockResponse mockResponse, Map<String, String> headerMap) {
        HttpHeaders headers = new HttpHeaders();
        try {
            if (MediaType.valueOf((String)headerMap.get("accept")).includes(MediaType.ALL)) {
                headers.setContentType(MediaType.APPLICATION_JSON);
            } else {
                headers.setContentType(MediaType.valueOf((String)headerMap.get("accept")));
            }
            for (VirtualServiceKeyValue keyValuePair : mockResponse.getHeaderParams()) {
                headers.add(keyValuePair.getKey(), keyValuePair.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return headers;
    }
}

