/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.virtualan.annotation.ApiVirtual;
import io.virtualan.annotation.VirtualService;
import io.virtualan.api.ApiMethod;
import io.virtualan.api.ApiResource;
import io.virtualan.api.ApiType;
import io.virtualan.core.model.ResourceMapper;
import io.virtualan.core.model.VirtualServiceApiResponse;
import io.virtualan.core.model.VirtualServiceKeyValue;
import io.virtualan.core.model.VirtualServiceRequest;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public interface VirtualServiceInfo {
    public static final String MATCH_API_TYPE = "[\\sa-zA-Z0-9]Api";
    public static final String API_SUFFIX = "Api";
    public static final String PARENT_ROOT = "Parent-Root";
    public static final String CURLY_PATH = "Curly";
    public static final Logger log = LoggerFactory.getLogger(VirtualServiceInfo.class);
    public static final String rxpCurly = "\\{(.*?)\\}";
    public static final Pattern pattern = Pattern.compile("\\{(.*?)\\}", 8);

    public ApiType getApiType();

    public void setApiType(ApiType var1);

    public ObjectMapper getObjectMapper();

    public void setObjectMapper(ObjectMapper var1);

    public ResourceMapper getResourceParent();

    public void setResourceParent(ResourceMapper var1);

    public Map<String, Map<String, VirtualServiceRequest>> getMockLoadChoice();

    public void setMockLoadChoice(Map<String, Map<String, VirtualServiceRequest>> var1);

    public void buildInput(Method var1, VirtualServiceRequest var2) throws JsonProcessingException, InstantiationException, IllegalAccessException, ClassNotFoundException;

    default public String getResourceDesc(Method method) {
        ApiOperation[] apiOperationAnno = (ApiOperation[])method.getAnnotationsByType(ApiOperation.class);
        if (apiOperationAnno != null && apiOperationAnno.length > 0) {
            return apiOperationAnno[0].notes();
        }
        return null;
    }

    default public Map<String, Class> findVirtualServices() {
        HashMap<String, Class> virtualInterfaces = new HashMap<String, Class>();
        try {
            Field f = ClassLoader.class.getDeclaredField("classes");
            f.setAccessible(true);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            List classes = (List)f.get(classLoader);
            for (int i = 0; i < classes.size(); ++i) {
                Class classzz = (Class)classes.get(i);
                try {
                    if (!classzz.isAnnotationPresent(VirtualService.class)) continue;
                    String interfaceName = classzz.getTypeName();
                    interfaceName = interfaceName.substring(interfaceName.lastIndexOf(".") + 1);
                    interfaceName = interfaceName.toLowerCase();
                    virtualInterfaces.put(interfaceName, classzz);
                    continue;
                }
                catch (ArrayStoreException arrayStoreException) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            log.error("Unable to load from the class loader " + e1.getMessage());
        }
        return virtualInterfaces;
    }

    default public Map<String, Map<String, VirtualServiceRequest>> loadVirtualServices() throws ClassNotFoundException, JsonProcessingException, InstantiationException, IllegalAccessException {
        Map<String, Map<String, VirtualServiceRequest>> mockLoadChoice = this.getMockLoadChoice();
        if (mockLoadChoice == null) {
            mockLoadChoice = new TreeMap<String, Map<String, VirtualServiceRequest>>();
            for (Map.Entry<String, Class> virtualServiceEntry : this.findVirtualServices().entrySet()) {
                Map<String, VirtualServiceRequest> mockAPILoadChoice = this.buildVirtualServiceInfo(virtualServiceEntry);
                if (mockAPILoadChoice.isEmpty()) continue;
                Map<String, Map<String, VirtualServiceRequest>> resourceGroup = mockAPILoadChoice.entrySet().stream().filter(x -> !"virtualanendpoint".equalsIgnoreCase((String)x.getKey())).collect(Collectors.groupingBy(f -> ((VirtualServiceRequest)f.getValue()).getResource(), Collectors.toMap(f -> (String)f.getKey(), f -> (VirtualServiceRequest)f.getValue())));
                mockLoadChoice.putAll(resourceGroup);
            }
        }
        this.setMockLoadChoice(mockLoadChoice);
        return mockLoadChoice;
    }

    default public Map<String, VirtualServiceRequest> buildVirtualServiceInfo(Map.Entry<String, Class> virtualServiceEntry) throws JsonProcessingException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        LinkedHashMap<String, VirtualServiceRequest> mockAPILoadChoice = new LinkedHashMap<String, VirtualServiceRequest>();
        for (Method method : virtualServiceEntry.getValue().getDeclaredMethods()) {
            VirtualServiceRequest mockReturn;
            ApiVirtual[] annotInstance = (ApiVirtual[])method.getAnnotationsByType(ApiVirtual.class);
            if (annotInstance == null || annotInstance.length <= 0 || (mockReturn = this.buildServiceDetails(virtualServiceEntry, method)) == null) continue;
            mockAPILoadChoice.put(method.getName(), mockReturn);
        }
        return mockAPILoadChoice;
    }

    default public Class getInputType(VirtualServiceRequest mockTransferInput) {
        Class inputType = null;
        if (mockTransferInput.getResource() == null) {
            mockTransferInput.setResource(ApiResource.getResourceByURL(mockTransferInput.getUrl()));
        }
        if (mockTransferInput.getOperationId() != null) {
            VirtualServiceRequest mockTransferActual = this.getMockLoadChoice().get(mockTransferInput.getResource()).get(mockTransferInput.getOperationId());
            if (mockTransferActual != null) {
                inputType = mockTransferActual.getInputObjectType();
            }
        } else {
            String resourceUrl = mockTransferInput.getUrl().substring(1);
            LinkedList<String> resouceSplitterList = new LinkedList<String>(Arrays.asList(resourceUrl.split("/")));
            if (!resouceSplitterList.isEmpty()) {
                String operationId = this.getOperationId(mockTransferInput.getMethod(), this.getResourceParent(), resouceSplitterList);
                VirtualServiceRequest mockTransferActual = this.getMockLoadChoice().get(mockTransferInput.getResource()).get(operationId);
                if (mockTransferActual != null) {
                    inputType = mockTransferActual.getInputObjectType();
                }
            }
        }
        return inputType;
    }

    default public Map<String, VirtualServiceApiResponse> buildOpenAPIResponseType(Method method) {
        HashMap<String, VirtualServiceApiResponse> responseType = new HashMap<String, VirtualServiceApiResponse>();
        ApiResponses[] apiResponsesAnno = (ApiResponses[])method.getAnnotationsByType(ApiResponses.class);
        if (apiResponsesAnno != null) {
            for (ApiResponses apiResponses : apiResponsesAnno) {
                for (ApiResponse apiResponse : apiResponses.value()) {
                    try {
                        if (responseType.containsKey(String.valueOf(apiResponse.code()))) continue;
                        responseType.put(String.valueOf(apiResponse.code()), new VirtualServiceApiResponse(String.valueOf(apiResponse.code()), apiResponse.response().getCanonicalName(), this.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(Class.forName(apiResponse.response().getCanonicalName()).newInstance()), apiResponse.message()));
                    }
                    catch (Exception e) {
                        responseType.put(String.valueOf(apiResponse.code()), new VirtualServiceApiResponse(String.valueOf(apiResponse.code()), null, null, apiResponse.message()));
                    }
                }
            }
        }
        return responseType;
    }

    default public String getOperationId(String httpVerb, ResourceMapper resourceParent, List<String> resouceSplitterList) {
        if (resouceSplitterList.size() == 0) {
            return resourceParent.getOperationId(httpVerb);
        }
        String resource = resouceSplitterList.get(0);
        ResourceMapper mapper = resourceParent.findResource(resource);
        if (mapper != null) {
            return this.getOperationId(httpVerb, mapper, resouceSplitterList.subList(1, resouceSplitterList.size()));
        }
        return this.getOperationId(httpVerb, resourceParent.findResource(CURLY_PATH), resouceSplitterList.subList(1, resouceSplitterList.size()));
    }

    default public VirtualServiceRequest getResponseType(VirtualServiceRequest mockTransferInput) {
        if (mockTransferInput != null && mockTransferInput.getUrl() != null) {
            int index;
            int n = index = mockTransferInput.getUrl().indexOf(47, 1) == -1 ? mockTransferInput.getUrl().length() : mockTransferInput.getUrl().indexOf(47, 1);
            if (mockTransferInput.getResource() == null) {
                mockTransferInput.setResource(mockTransferInput.getUrl().substring(1, index));
            }
        }
        if (mockTransferInput.getOperationId() != null) {
            return this.getMockLoadChoice().get(mockTransferInput.getResource()).get(mockTransferInput.getOperationId());
        }
        return null;
    }

    default public Map<String, String> getHttpStatusMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (HttpStatus status : HttpStatus.values()) {
            map.put(String.valueOf(status.value()), status.name());
        }
        return map;
    }

    default public ResourceMapper loadMapper() {
        LinkedHashSet<ResourceMapper> resourceMapperList = new LinkedHashSet<ResourceMapper>();
        ResourceMapper resourceParent = new ResourceMapper(PARENT_ROOT, resourceMapperList);
        for (Map.Entry<String, Map<String, VirtualServiceRequest>> obj : this.getMockLoadChoice().entrySet()) {
            for (Map.Entry<String, VirtualServiceRequest> requestMockObject : obj.getValue().entrySet()) {
                String resource = requestMockObject.getValue().getUrl().substring(1);
                LinkedList<String> resouceSplitterList = new LinkedList<String>(Arrays.asList(resource.split("/")));
                if (resouceSplitterList.isEmpty()) continue;
                ResourceMapper mapperChild = this.buildHierarchyObject(requestMockObject.getValue().getMethod(), resourceParent, resouceSplitterList, requestMockObject.getKey());
                resourceParent.addResourceMapper(mapperChild);
            }
        }
        return resourceParent;
    }

    default public ResourceMapper buildHierarchyObject(String httpVerb, ResourceMapper resourceParent, List<String> resouceSplitterList, String operationId) {
        String resource = resouceSplitterList.get(0);
        String actualResource = resouceSplitterList.get(0);
        Matcher matcher = pattern.matcher(resouceSplitterList.get(0));
        if (matcher.find()) {
            resource = CURLY_PATH;
        }
        if (resouceSplitterList.size() == 1) {
            ResourceMapper resourceMapper = resourceParent.findResource(resource);
            if (resourceMapper == null) {
                resourceMapper = new ResourceMapper(resource);
                resourceMapper.setActualResource(actualResource);
            }
            resourceMapper.setOperationId(httpVerb, operationId);
            return resourceMapper;
        }
        if (resourceParent.findResource(resource) != null) {
            ResourceMapper resourceChild = resourceParent.findResource(resource);
            ResourceMapper resourceMapperReturn = this.buildHierarchyObject(httpVerb, resourceChild, resouceSplitterList.subList(1, resouceSplitterList.size()), operationId);
            resourceChild.addResourceMapper(resourceMapperReturn);
            return resourceChild;
        }
        LinkedHashSet<ResourceMapper> mapperSet = new LinkedHashSet<ResourceMapper>();
        ResourceMapper resourceMapper = new ResourceMapper(resource, mapperSet);
        resourceMapper.setActualResource(actualResource);
        ResourceMapper resourceMapperReturn = this.buildHierarchyObject(httpVerb, resourceMapper, resouceSplitterList.subList(1, resouceSplitterList.size()), operationId);
        resourceMapper.addResourceMapper(resourceMapperReturn);
        return resourceMapper;
    }

    default public Map<String, VirtualServiceApiResponse> buildResponseType(Method method) throws JsonProcessingException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Map<String, VirtualServiceApiResponse> responseType = this.buildOpenAPIResponseType(method);
        if (responseType == null && responseType.isEmpty()) {
            responseType = new HashMap<String, VirtualServiceApiResponse>();
            String defaultResponse = "Default";
            if (method.getGenericReturnType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
                for (Type type : parameterizedType.getActualTypeArguments()) {
                    try {
                        responseType.put(defaultResponse, new VirtualServiceApiResponse(defaultResponse, type.getTypeName(), this.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(Class.forName(type.getTypeName()).newInstance()), null));
                    }
                    catch (Exception e) {
                        responseType.put(defaultResponse, new VirtualServiceApiResponse(defaultResponse, null, null, null));
                    }
                }
            }
        }
        return responseType;
    }

    default public VirtualServiceRequest buildServiceDetails(Map.Entry<String, Class> virtualServiceEntry, Method method) throws JsonProcessingException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String rootResource = ApiResource.getResourceParent(virtualServiceEntry.getValue());
        VirtualServiceRequest virtualServiceRequest = new VirtualServiceRequest();
        virtualServiceRequest.setDesc(this.getResourceDesc(method));
        virtualServiceRequest.setResponseType(this.buildResponseType(method));
        virtualServiceRequest.setOperationId(method.getName());
        virtualServiceRequest.setHttpStatusMap(this.getHttpStatusMap());
        VirtualServiceKeyValue virtualServiceKeyValue = ApiMethod.getApiMethodParamAndURL(method);
        if (rootResource != null) {
            virtualServiceRequest.setUrl("/" + rootResource + virtualServiceKeyValue.getValue());
            virtualServiceRequest.setResource(rootResource);
        } else {
            virtualServiceRequest.setUrl(virtualServiceKeyValue.getValue());
            virtualServiceRequest.setResource(ApiResource.getResourceByURL(virtualServiceKeyValue.getValue()));
        }
        virtualServiceRequest.setMethod(virtualServiceKeyValue.getKey());
        this.buildInput(method, virtualServiceRequest);
        return virtualServiceRequest;
    }
}

