/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.controller;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.virtualan.core.InvalidMockResponseException;
import io.virtualan.core.VirtualServiceInfo;
import io.virtualan.core.VirtualServiceUtil;
import io.virtualan.core.model.MockResponse;
import io.virtualan.core.model.MockServiceRequest;
import io.virtualan.core.model.RequestType;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.model.VirtualServiceStatus;
import io.virtualan.core.util.Converter;
import io.virtualan.core.util.rule.RuleEvaluator;
import io.virtualan.core.util.rule.ScriptExecutor;
import io.virtualan.requestbody.RequestBody;
import io.virtualan.requestbody.RequestBodyTypes;
import io.virtualan.service.VirtualService;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="virtualServiceController")
public class VirtualServiceController {
    private static final Logger log = LoggerFactory.getLogger(VirtualServiceController.class);
    @Autowired
    private RuleEvaluator ruleEvaluator;
    @Autowired
    private ScriptExecutor scriptExecutor;
    @Autowired
    private Converter converter;
    @Autowired
    private VirtualService virtualService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private MessageSource messageSource;
    Locale locale = LocaleContextHolder.getLocale();
    @Autowired
    private VirtualServiceUtil virtualServiceUtil;
    @Value(value="${virtualan.application.name:Mock Service}")
    private String applicationName;

    private ObjectMapper getObjectMapper() {
        this.objectMapper.findAndRegisterModules();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return this.objectMapper.enable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    public VirtualService getVirtualService() {
        return this.virtualService;
    }

    public void setVirtualService(VirtualService virtualService) {
        this.virtualService = virtualService;
    }

    public VirtualServiceInfo getVirtualServiceInfo() {
        return this.virtualServiceUtil.getVirtualServiceInfo();
    }

    @RequestMapping(value={"/virtualservices/app-name"}, method={RequestMethod.GET})
    public String applicationName() {
        return "{\"appName\":\"" + this.applicationName + "\"}";
    }

    @RequestMapping(value={"/virtualservices/load"}, method={RequestMethod.GET})
    public Map<String, Map<String, VirtualServiceRequest>> listAllMockLoadRequest() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        return this.virtualServiceUtil.getVirtualServiceInfo() != null ? this.virtualServiceUtil.getVirtualServiceInfo().loadVirtualServices() : new HashMap();
    }

    @RequestMapping(value={"/virtualservices"}, method={RequestMethod.GET})
    public ResponseEntity<List<VirtualServiceRequest>> listAllMockLoadRequests() {
        List<VirtualServiceRequest> mockRestLoadRequests = this.virtualService.findAllMockRequests();
        if (mockRestLoadRequests.isEmpty()) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        List response = mockRestLoadRequests.stream().map(x -> this.converter.convertAsJson((VirtualServiceRequest)x)).collect(Collectors.toList());
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/virtualservices/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<VirtualServiceRequest> getMockLoadRequest(@PathVariable(value="id") long id) throws JsonProcessingException {
        VirtualServiceRequest mockLoadRequest = this.virtualService.findById(id);
        if (mockLoadRequest == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        mockLoadRequest = this.converter.convertAsJson(mockLoadRequest);
        return new ResponseEntity((Object)mockLoadRequest, HttpStatus.OK);
    }

    @RequestMapping(value={"/virtualservices"}, method={RequestMethod.POST})
    public ResponseEntity createMockRequest(@org.springframework.web.bind.annotation.RequestBody VirtualServiceRequest virtualServiceRequest) {
        try {
            this.converter.convertJsonAsString(virtualServiceRequest);
            virtualServiceRequest.setRequestType(RequestType.REST.toString());
            this.validateExpectedInput(virtualServiceRequest);
            this.virtualServiceUtil.findOperationIdForService(virtualServiceRequest);
            ResponseEntity responseEntity = this.validateRequestBody(virtualServiceRequest);
            if (responseEntity != null) {
                return responseEntity;
            }
            responseEntity = this.validateResponseBody(virtualServiceRequest);
            if (responseEntity != null) {
                return responseEntity;
            }
            responseEntity = this.virtualServiceUtil.checkIfServiceDataAlreadyExists(virtualServiceRequest);
            if (responseEntity != null) {
                return responseEntity;
            }
            VirtualServiceRequest mockTransferObject = this.virtualService.saveMockRequest(virtualServiceRequest);
            mockTransferObject = this.converter.convertAsJson(mockTransferObject);
            mockTransferObject.setMockStatus(new VirtualServiceStatus(this.messageSource.getMessage("VS_SUCCESS", null, this.locale)));
            return new ResponseEntity((Object)mockTransferObject, HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage("VS_UNEXPECTED_ERROR", null, this.locale) + e.getMessage()), HttpStatus.BAD_REQUEST);
        }
    }

    private ResponseEntity validateResponseBody(VirtualServiceRequest mockLoadRequest) {
        try {
            this.virtualServiceUtil.isMockResponseBodyValid(mockLoadRequest);
        }
        catch (InvalidMockResponseException | NoSuchMessageException e) {
            return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage("VS_RESPONSE_BODY_MISMATCH", null, this.locale) + e.getMessage()), HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    private ResponseEntity validateRequestBody(VirtualServiceRequest virtualServiceRequest) throws IllegalAccessException, InstantiationException {
        if (this.virtualServiceUtil.getVirtualServiceInfo() != null) {
            Class inputObjectType = this.virtualServiceUtil.getVirtualServiceInfo().getInputType(virtualServiceRequest);
            if (inputObjectType == null && (virtualServiceRequest.getInput() == null || virtualServiceRequest.getInput().toString().length() == 0)) {
                return null;
            }
            if (virtualServiceRequest.getInput() != null && virtualServiceRequest.getInput().toString().length() > 0 && inputObjectType != null) {
                RequestBody requestBody = new RequestBody();
                requestBody.setObjectMapper(this.getObjectMapper());
                requestBody.setInputRequest(virtualServiceRequest.getInput().toString());
                requestBody.setInputObjectType(inputObjectType);
                Object object = null;
                try {
                    object = RequestBodyTypes.fromString(inputObjectType.getTypeName()).getValidMockRequestBody(requestBody);
                }
                catch (IOException | NoSuchMessageException e) {
                    e.printStackTrace();
                    object = null;
                }
                if (object == null) {
                    return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage("VS_REQUEST_BODY_MISMATCH", null, this.locale)), HttpStatus.BAD_REQUEST);
                }
                if ("RULE".equalsIgnoreCase(virtualServiceRequest.getType())) {
                    try {
                        MockServiceRequest mockServiceRequest = new MockServiceRequest();
                        try {
                            object = RequestBodyTypes.fromString(inputObjectType.getTypeName()).getValidMockRequestBody(requestBody);
                        }
                        catch (IOException | NoSuchMessageException e) {
                            e.printStackTrace();
                            object = null;
                        }
                        mockServiceRequest.setInput(object);
                        mockServiceRequest.setParams(Converter.converter(virtualServiceRequest.getAvailableParams()));
                        this.ruleEvaluator.expressionEvaluatorForMockCreation(mockServiceRequest, virtualServiceRequest.getRule());
                    }
                    catch (Exception e) {
                        return new ResponseEntity((Object)new VirtualServiceStatus(e.getMessage(), this.messageSource.getMessage("VS_REQUEST_BODY_MISMATCH", null, this.locale)), HttpStatus.BAD_REQUEST);
                    }
                }
                if ("SCRIPT".equalsIgnoreCase(virtualServiceRequest.getType())) {
                    try {
                        MockServiceRequest mockServiceRequest = new MockServiceRequest();
                        try {
                            object = RequestBodyTypes.fromString(inputObjectType.getTypeName()).getValidMockRequestBody(requestBody);
                        }
                        catch (IOException | NoSuchMessageException e) {
                            e.printStackTrace();
                            object = null;
                        }
                        mockServiceRequest.setInput(object);
                        mockServiceRequest.setParams(Converter.converter(virtualServiceRequest.getAvailableParams()));
                        MockResponse mockResponse = new MockResponse();
                        mockResponse = this.scriptExecutor.executeScript(mockServiceRequest, mockResponse, virtualServiceRequest.getRule());
                        if (mockResponse == null) {
                            return new ResponseEntity((Object)new VirtualServiceStatus("Its not a valid mock response setup!!! Verify the script? ", this.messageSource.getMessage("VS_REQUEST_BODY_MISMATCH", null, this.locale)), HttpStatus.BAD_REQUEST);
                        }
                    }
                    catch (Exception e) {
                        return new ResponseEntity((Object)new VirtualServiceStatus(e.getMessage(), this.messageSource.getMessage("VS_REQUEST_BODY_MISMATCH", null, this.locale)), HttpStatus.BAD_REQUEST);
                    }
                }
            }
        }
        return null;
    }

    private ResponseEntity validateExpectedInput(VirtualServiceRequest mockLoadRequest) {
        if (mockLoadRequest.getHttpStatusCode() == null || mockLoadRequest.getMethod() == null || mockLoadRequest.getType() == null || mockLoadRequest.getUrl() == null) {
            return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage("VS_CREATE_MISSING_INFO", null, this.locale)), HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    @RequestMapping(value={"/virtualservices/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<VirtualServiceRequest> updateMockRequest(@PathVariable(value="id") long id, @org.springframework.web.bind.annotation.RequestBody VirtualServiceRequest mockLoadRequest) {
        VirtualServiceRequest currentMockLoadRequest = this.virtualService.findById(id);
        if (currentMockLoadRequest == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.virtualServiceUtil.findOperationIdForService(mockLoadRequest);
        currentMockLoadRequest.setInput(mockLoadRequest.getInput());
        currentMockLoadRequest.setOutput(mockLoadRequest.getOutput());
        currentMockLoadRequest.setOperationId(mockLoadRequest.getOperationId());
        this.virtualService.updateMockRequest(currentMockLoadRequest);
        return new ResponseEntity((Object)currentMockLoadRequest, HttpStatus.OK);
    }

    @RequestMapping(value={"/virtualservices/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<VirtualServiceRequest> deleteMockRequest(@PathVariable(value="id") long id) {
        VirtualServiceRequest MockLoadRequest = this.virtualService.findById(id);
        if (MockLoadRequest == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.virtualService.deleteMockRequestById(id);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/api-catalogs"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> readCatalog() {
        HashSet<String> fileList = new HashSet<String>();
        List<String> lists = Arrays.asList("classpath:META-INF/resources/yaml/*/", "classpath:META-INF/resources/wsdl/*/");
        fileList.add("VirtualService");
        for (String pathName : lists) {
            try {
                Resource[] resources;
                for (Resource file : resources = this.getCatalogList(pathName)) {
                    String[] names = file.toString().split("/");
                    if (names.length <= 1) continue;
                    fileList.add(names[names.length - 2]);
                }
            }
            catch (Exception e) {
                log.error("api-catalogs : " + e.getMessage());
            }
        }
        if (fileList.isEmpty()) {
            log.error("Api-catalogs List was not available : ");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(new LinkedList(fileList.stream().sorted().collect(Collectors.toList())), HttpStatus.OK);
    }

    @RequestMapping(value={"/api-catalogs/{name}"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> readCatalog(@PathVariable(value="name") String name) {
        LinkedList<String> fileList = new LinkedList<String>();
        try {
            if ("VirtualService".equalsIgnoreCase(name)) {
                fileList.add("virtualservices.yaml");
            }
            for (Resource file : this.getCatalogs(name)) {
                fileList.add(file.getFilename());
            }
        }
        catch (IOException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        if (fileList.isEmpty()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(fileList, HttpStatus.OK);
    }

    private Resource[] getCatalogs(String name) throws IOException {
        ClassLoader classLoader = MethodHandles.lookup().getClass().getClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        return resolver.getResources("classpath:META-INF/resources/**/" + name + "/*.*");
    }

    private Resource[] getCatalogList(String path) throws IOException {
        ClassLoader classLoader = MethodHandles.lookup().getClass().getClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        return resolver.getResources(path);
    }
}

