/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util.rule;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import io.virtualan.core.model.MockResponse;
import io.virtualan.core.model.MockServiceRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="scriptExecutor")
public class ScriptExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptExecutor.class);
    private final GroovyClassLoader loader = new GroovyClassLoader(this.getClass().getClassLoader());
    private final GroovyShell shell = new GroovyShell((ClassLoader)this.loader, new Binding());

    public MockResponse executeScript(MockServiceRequest mockServiceRequest, MockResponse mockResponse, String scriptText) throws IOException {
        Script script = this.shell.parse(scriptText);
        LOG.info("Executing {}", (Object)mockServiceRequest);
        MockResponse result = (MockResponse)script.invokeMethod("executeScript", (Object)new Object[]{mockServiceRequest, mockResponse});
        return result;
    }

    public static void main(String[] args) throws InstantiationException, IllegalAccessException, ResourceException, ScriptException, IOException, javax.script.ScriptException {
        ScriptExecutor scriptExecutor = new ScriptExecutor();
        LOG.info("Example mock Groovy scripts integration with Java.: ");
        MockServiceRequest mockServiceRequest = new MockServiceRequest();
        mockServiceRequest.setInput("Elan");
        MockResponse mockResponse = new MockResponse();
        System.out.println(scriptExecutor.executeScript(mockServiceRequest, mockResponse, "def executeScript(mockServiceRequest) {mockServiceRequest.getInput()}"));
    }
}

