/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import io.virtualan.core.model.MockRequest;
import io.virtualan.core.model.MockServiceRequest;
import io.virtualan.core.model.VirtualServiceKeyValue;
import io.virtualan.core.util.ReturnMockResponse;
import io.virtualan.params.Param;
import io.virtualan.params.ParamTypes;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="virtualServiceParamComparator")
public class VirtualServiceParamComparator {
    public boolean isAllParamPresent(MockServiceRequest mockServiceRequest, ReturnMockResponse rMockResponse) {
        for (VirtualServiceKeyValue virtualServiceKeyValue : rMockResponse.getMockRequest().getAvailableParams()) {
            if (mockServiceRequest.getParams().containsKey(virtualServiceKeyValue.getKey()) && mockServiceRequest.getParams().get(virtualServiceKeyValue.getKey()).equals(virtualServiceKeyValue.getValue())) {
                mockServiceRequest.getParams().remove(virtualServiceKeyValue.getKey());
                continue;
            }
            if (mockServiceRequest.getHeaderParams() == null || mockServiceRequest.getHeaderParams().get(virtualServiceKeyValue.getKey().toLowerCase()) == null || mockServiceRequest.getHeaderParams().get(virtualServiceKeyValue.getKey().toLowerCase()).contains(virtualServiceKeyValue.getValue())) continue;
            return false;
        }
        return mockServiceRequest.getParams().size() == 0;
    }

    private int isParameterMatch(MockRequest mockRequest, MockServiceRequest mockServiceRequest) {
        int numberOfMatch = 0;
        for (VirtualServiceKeyValue mockKeyValueParams : mockRequest.getAvailableParams()) {
            Class type = null;
            if (mockServiceRequest.getParamsType() != null) {
                type = mockServiceRequest.getParamsType().get(mockKeyValueParams.getKey());
            }
            Param param = new Param();
            if (mockServiceRequest.getParams().containsKey(mockKeyValueParams.getKey())) {
                param.setActualValue(mockServiceRequest.getParams().get(mockKeyValueParams.getKey()));
            } else {
                param.setActualValue(mockServiceRequest.getHeaderParams().get(mockKeyValueParams.getKey().toLowerCase()));
            }
            param.setExpectedValue(mockKeyValueParams.getValue());
            param.setName(mockKeyValueParams.getKey());
            if (mockRequest.getExcludeSet() != null && mockRequest.getExcludeSet().contains(mockKeyValueParams.getKey())) continue;
            if (type == null) {
                if (!ParamTypes.DEFAULT.compareParam(param)) continue;
                ++numberOfMatch;
                continue;
            }
            if (!ParamTypes.fromString(type.getCanonicalName()).compareParam(param)) continue;
            ++numberOfMatch;
        }
        return numberOfMatch;
    }

    public int isParameterMatch(MockRequest mockRequest, Map<String, String> actualQueryMap) {
        HashMap<String, String> filteredActualQueryMap = new HashMap<String, String>();
        int noumberOfMatch = 0;
        for (Map.Entry<String, String> mapEntry : actualQueryMap.entrySet()) {
            if (mapEntry.getValue() == null || "null".equals(mapEntry.getValue())) continue;
            filteredActualQueryMap.put(mapEntry.getKey(), mapEntry.getValue());
        }
        if (mockRequest.getAvailableParams().size() == filteredActualQueryMap.size()) {
            for (VirtualServiceKeyValue vsKeyValueParams : mockRequest.getAvailableParams()) {
                if (mockRequest.getExcludeSet() != null && mockRequest.getExcludeSet().contains(vsKeyValueParams.getKey())) continue;
                if (vsKeyValueParams.getValue().equals(filteredActualQueryMap.get(vsKeyValueParams.getKey()))) {
                    ++noumberOfMatch;
                    continue;
                }
                return noumberOfMatch;
            }
        }
        return noumberOfMatch;
    }

    public int compareQueryParams(MockRequest mockRequest, MockServiceRequest mockServiceRequest) {
        if (mockRequest.getAvailableParams() == null || mockRequest.getAvailableParams().isEmpty()) {
            return this.isEmptyRequest(mockServiceRequest.getParams());
        }
        return this.isParameterMatch(mockRequest, mockServiceRequest);
    }

    public int compareQueryParams(MockRequest mockRequest, Map<String, String> actualQueryMap) {
        if (mockRequest.getAvailableParams() == null || mockRequest.getAvailableParams().isEmpty()) {
            return this.isEmptyRequest(actualQueryMap);
        }
        return this.isParameterMatch(mockRequest, actualQueryMap);
    }

    public int isEmptyRequest(Map<String, String> actualQueryMap) {
        if (actualQueryMap != null) {
            for (Map.Entry<String, String> checkEmpty : actualQueryMap.entrySet()) {
                if ("null".equals(checkEmpty.getValue())) continue;
                return 0;
            }
        }
        return 1;
    }
}

