/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import io.virtualan.controller.VirtualServiceController;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
public class ApiDocumentGeneration {
    @Autowired
    private VirtualServiceController virtualServiceController;
    @Value(value="${virtualan.api.contact.name:Elan Thangamani}")
    private String contactName;
    @Value(value="${virtualan.api.contact.url:http://www.virtualan.io}")
    private String contactUrl;
    @Value(value="${virtualan.api.contact.email:elans3.java@gmail.com}")
    private String contactEmail;
    @Value(value="${virtualan.api.title:Virtualan API Catalog}")
    private String apiTitle;

    @Bean
    public Docket customImplementation(ServletContext servletContext) {
        Docket docket = new Docket(DocumentationType.SWAGGER_2);
        ApiSelectorBuilder selector = docket.select();
        for (Map.Entry<String, Class> virtualServices : this.virtualServiceController.getVirtualServiceInfo().findVirtualServices().entrySet()) {
            selector.apis(RequestHandlerSelectors.basePackage((String)virtualServices.getValue().getPackage().getName()));
        }
        selector.build().directModelSubstitute(LocalDate.class, java.sql.Date.class).directModelSubstitute(OffsetDateTime.class, Date.class).apiInfo(this.apiInfo());
        return docket;
    }

    ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.apiTitle).description("Virtualan API Catalog").license("Apache-2.0").licenseUrl("http://www.apache.org/licenses/LICENSE-2.0.html").termsOfServiceUrl("").version("1.0.0").contact(new Contact(this.contactName, this.contactUrl, this.contactEmail)).build();
    }
}

