/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.model;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ResourceMapper {
    String resource;
    String actualResource;
    Set<ResourceMapper> resourceMapperList = new LinkedHashSet<ResourceMapper>();
    Map<String, String> operationIdMap = new HashMap<String, String>();

    public ResourceMapper(String resource, Set<ResourceMapper> resourceMapperList) {
        this.resource = resource;
        this.resourceMapperList = resourceMapperList;
    }

    public ResourceMapper(String resource) {
        this.resource = resource;
    }

    public Map<String, String> getOperationIdMap() {
        return this.operationIdMap;
    }

    public void setOperationIdMap(Map<String, String> operationIdMap) {
        this.operationIdMap = operationIdMap;
    }

    public void setResourceMapperList(Set<ResourceMapper> resourceMapperList) {
        this.resourceMapperList = resourceMapperList;
    }

    public String toString() {
        return "ResourceMapper [resource=" + this.resource + ", actualResource=" + this.actualResource + ", resourceMapperList=" + this.resourceMapperList + ", operationId=" + this.operationIdMap + "]";
    }

    public ResourceMapper findResource(String resource) {
        if (this.resourceMapperList != null) {
            for (ResourceMapper mapper : this.resourceMapperList) {
                if (!mapper.getResource().equalsIgnoreCase(resource)) continue;
                return mapper;
            }
        }
        return null;
    }

    public void addResourceMapper(ResourceMapper resourceMapper) {
        if (this.resourceMapperList != null && resourceMapper != null) {
            this.resourceMapperList.add(resourceMapper);
        }
    }

    public String getActualResource() {
        return this.actualResource;
    }

    public void setActualResource(String actualResource) {
        this.actualResource = actualResource;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Set<ResourceMapper> getResourceMapperList() {
        return this.resourceMapperList;
    }

    public void setResourceMapper(Set<ResourceMapper> resourceMapperList) {
        this.resourceMapperList = resourceMapperList;
    }

    public String getOperationId(String httpVerb) {
        return this.operationIdMap.get(httpVerb);
    }

    public void setOperationId(String httpVerb, String operationId) {
        this.operationIdMap.put(httpVerb, operationId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actualResource == null ? 0 : this.actualResource.hashCode());
        result = 31 * result + (this.operationIdMap == null ? 0 : this.operationIdMap.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.resourceMapperList == null ? 0 : this.resourceMapperList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceMapper other = (ResourceMapper)obj;
        if (this.actualResource == null ? other.actualResource != null : !this.actualResource.equals(other.actualResource)) {
            return false;
        }
        if (this.operationIdMap == null ? other.operationIdMap != null : !this.operationIdMap.equals(other.operationIdMap)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        if (this.resourceMapperList == null) {
            return other.resourceMapperList == null;
        }
        return this.resourceMapperList.equals(other.resourceMapperList);
    }
}

