/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.controller;

import io.virtualan.core.model.RequestType;
import io.virtualan.core.model.SoapService;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.model.VirtualServiceStatus;
import io.virtualan.core.soap.WSEndpointConfiguration;
import io.virtualan.message.core.MessageUtil;
import io.virtualan.service.VirtualService;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="virtualSoapController")
public class VirtualSoapController {
    private static final Logger log = LoggerFactory.getLogger(VirtualSoapController.class);
    Locale locale = LocaleContextHolder.getLocale();
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private VirtualService virtualService;
    @Autowired(required=false)
    private WSEndpointConfiguration wsEndpointConfiguration;

    public ResponseEntity checkIfServiceDataAlreadyExists(VirtualServiceRequest virtualServiceRequest) throws Exception {
        Long id = this.messageUtil.isMockAlreadyExists(virtualServiceRequest);
        if (id != null && id != 0L) {
            VirtualServiceStatus virtualServiceStatus = new VirtualServiceStatus(this.messageSource.getMessage("VS_DATA_ALREADY_EXISTS", null, this.locale));
            virtualServiceRequest.setId(id);
            virtualServiceStatus.setVirtualServiceRequest(virtualServiceRequest);
            return new ResponseEntity((Object)virtualServiceStatus, HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    @RequestMapping(value={"/virtualservices/soap/services"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, List<SoapService>>> listAvailableSoapService() {
        if (this.wsEndpointConfiguration == null) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        Map<String, SoapService> soapServiceMap = this.wsEndpointConfiguration.getWsServiceMockList();
        if (soapServiceMap != null && !soapServiceMap.isEmpty()) {
            Map<String, List<SoapService>> soapServicesByNs = soapServiceMap.values().stream().sorted(Comparator.comparing(s -> s.getMethod())).collect(Collectors.groupingBy(SoapService::getNs));
            return new ResponseEntity(soapServicesByNs, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/virtualservices/soap/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<VirtualServiceRequest> deleteMockRequest(@PathVariable(value="id") long id) {
        VirtualServiceRequest MockLoadRequest = this.virtualService.findById(id);
        if (MockLoadRequest == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.virtualService.deleteMockRequestById(id);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/virtualservices/soap"}, method={RequestMethod.GET})
    public ResponseEntity<List<VirtualServiceRequest>> listAllMockMessageLoadRequests() {
        List<VirtualServiceRequest> mockLoadRequests = this.virtualService.findAllMockRequests();
        List mockRestLoadRequests = mockLoadRequests.stream().filter(x -> RequestType.SOAP.toString().equalsIgnoreCase(x.getRequestType()) || x.getRequestType() == null).collect(Collectors.toList());
        if (mockRestLoadRequests.isEmpty()) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(mockRestLoadRequests, HttpStatus.OK);
    }

    @RequestMapping(value={"/virtualservices/soap"}, method={RequestMethod.POST})
    public ResponseEntity createMockRequest(@RequestBody VirtualServiceRequest virtualServiceRequest) {
        try {
            this.wsEndpointConfiguration.getWsServiceMockList().entrySet().stream().filter(x -> ((SoapService)x.getValue()).getMethod().equalsIgnoreCase(virtualServiceRequest.getMethod()) && ((SoapService)x.getValue()).getNs().equalsIgnoreCase(virtualServiceRequest.getUrl())).forEach(y -> {
                try {
                    Class<?> reqClazzz = Class.forName(((SoapService)y.getValue()).getRequestClassName());
                    virtualServiceRequest.setInputObjectType(reqClazzz);
                }
                catch (ClassNotFoundException e) {
                    log.warn("return Class not found : " + e.getMessage());
                }
            });
            if (virtualServiceRequest.getResource() == null) {
                virtualServiceRequest.setResource(virtualServiceRequest.getUrl());
            }
            virtualServiceRequest.setRequestType(RequestType.SOAP.toString());
            ResponseEntity responseEntity = this.checkIfServiceDataAlreadyExists(virtualServiceRequest);
            if (responseEntity != null) {
                return responseEntity;
            }
            VirtualServiceRequest mockTransferObject = this.virtualService.saveMockRequest(virtualServiceRequest);
            mockTransferObject.setMockStatus(new VirtualServiceStatus(this.messageSource.getMessage("VS_SUCCESS", null, this.locale)));
            return new ResponseEntity((Object)mockTransferObject, HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new VirtualServiceStatus(this.messageSource.getMessage("VS_UNEXPECTED_ERROR", null, this.locale) + e.getMessage()), HttpStatus.BAD_REQUEST);
        }
    }
}

