/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.aop;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.virtualan.annotation.VirtualService;
import io.virtualan.api.ApiResource;
import io.virtualan.api.VirtualServiceType;
import io.virtualan.api.WSResource;
import io.virtualan.core.VirtualServiceInfo;
import io.virtualan.core.VirtualServiceUtil;
import io.virtualan.core.model.MockServiceRequest;
import io.virtualan.core.model.RequestType;
import io.virtualan.custom.message.ResponseException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.xml.bind.JAXBException;
import javax.xml.soap.SOAPException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.ws.server.endpoint.annotation.RequestPayload;

@Aspect
@Component
public class ApiVirtualAspect {
    private static Logger log = LoggerFactory.getLogger(VirtualServiceInfo.class);
    @Autowired
    HttpServletRequest request;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private VirtualServiceUtil virtualServiceUtil;

    public VirtualServiceUtil getVirtualServiceUtil() {
        return this.virtualServiceUtil;
    }

    public String addQueryParamValue(Object value) {
        return String.join((CharSequence)",", (List)value);
    }

    @Pointcut(value="@annotation(io.virtualan.annotation.ApiVirtual)")
    public void apiVirtualServicePointcut() {
    }

    @Around(value="apiVirtualServicePointcut()")
    public Object aroundAddAdvice(ProceedingJoinPoint thisJoinPoint) throws ResponseException, IOException, SOAPException, JAXBException {
        MockServiceRequest mockServiceRequest = new MockServiceRequest();
        Object[] args = thisJoinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)thisJoinPoint.getStaticPart().getSignature();
        Method method = methodSignature.getMethod();
        Class<?> targetClass = thisJoinPoint.getTarget().getClass();
        AbstractMap.SimpleEntry<Boolean, Class> isVirtualan = this.isVirtualService(targetClass);
        if (isVirtualan.getKey().booleanValue()) {
            String parentPath = null;
            if (WSResource.isExists(method)) {
                AbstractMap.SimpleEntry<String, String> path = WSResource.getResourceParent(method);
                mockServiceRequest.setResource(path.getValue());
                mockServiceRequest.setOperationId(method.getName());
                mockServiceRequest.setRequestType(RequestType.SOAP);
                this.readWSInputParam(args, methodSignature, mockServiceRequest);
            } else {
                parentPath = ApiResource.getResourceParent(isVirtualan.getValue());
                if (mockServiceRequest.getResource() == null) {
                    mockServiceRequest.setResource(ApiResource.getResource(method));
                } else {
                    mockServiceRequest.setResource(parentPath);
                }
                mockServiceRequest.setOperationId(method.getName());
                this.readInputParam(args, methodSignature, mockServiceRequest);
                Map<String, String> headersInfo = this.getHeadersInfo();
                mockServiceRequest.setHeaderParams(headersInfo);
            }
        }
        return this.getVirtualServiceUtil().returnResponse(method, mockServiceRequest);
    }

    public AbstractMap.SimpleEntry<Boolean, Class> isVirtualService(Class<?> claszzz) {
        if (claszzz.isAnnotationPresent(VirtualService.class)) {
            return new AbstractMap.SimpleEntry<Boolean, Class>(true, claszzz);
        }
        for (Class<?> clazz : claszzz.getInterfaces()) {
            if (!clazz.isAnnotationPresent(VirtualService.class)) continue;
            return new AbstractMap.SimpleEntry<Boolean, Class>(true, clazz);
        }
        return new AbstractMap.SimpleEntry<Boolean, Class>(false, Object.class);
    }

    private Map<String, String> getHeadersInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = this.request.getHeader(key);
            map.put(key, value);
        }
        return map;
    }

    private void readWSInputParam(Object[] args, MethodSignature methodSignature, MockServiceRequest mockServiceRequest) {
        Method method = methodSignature.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        assert (args.length == parameterAnnotations.length);
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            if (parameterAnnotations[argIndex] == null || parameterAnnotations[argIndex].length <= 0) continue;
            Object requestParamName = null;
            for (Annotation annotation : parameterAnnotations[argIndex]) {
                if (!(annotation instanceof RequestPayload)) continue;
                try {
                    mockServiceRequest.setInputObjectType(Class.forName(methodSignature.getParameterTypes()[argIndex].getName()));
                    mockServiceRequest.setInput(args[argIndex]);
                }
                catch (ClassNotFoundException e) {
                    log.error(e.getMessage());
                }
                mockServiceRequest.setInput(args[argIndex]);
            }
        }
    }

    private void readInputParam(Object[] args, MethodSignature methodSignature, MockServiceRequest mockServiceRequest) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, Class> paramMapType = new HashMap<String, Class>();
        Method method = methodSignature.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        assert (args.length == parameterAnnotations.length);
        block4: for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            if (parameterAnnotations[argIndex] == null || parameterAnnotations[argIndex].length <= 0) continue;
            String requestParamName = null;
            for (Annotation annotation : parameterAnnotations[argIndex]) {
                RequestParam requestParam;
                if (annotation instanceof RequestParam) {
                    requestParam = (RequestParam)annotation;
                    requestParamName = requestParam.value();
                } else if (annotation instanceof PathVariable) {
                    requestParam = (PathVariable)annotation;
                    requestParamName = requestParam.value();
                } else if (annotation instanceof RequestBody) {
                    try {
                        mockServiceRequest.setInputObjectType(Class.forName(methodSignature.getParameterTypes()[argIndex].getName()));
                        mockServiceRequest.setInput(args[argIndex]);
                    }
                    catch (ClassNotFoundException e) {
                        log.error(e.getMessage());
                    }
                    mockServiceRequest.setInput(args[argIndex]);
                } else if (annotation instanceof QueryParam) {
                    requestParam = (QueryParam)annotation;
                    requestParamName = requestParam.value();
                } else if (annotation instanceof PathParam) {
                    requestParam = (PathParam)annotation;
                    requestParamName = requestParam.value();
                } else if (annotation instanceof FormParam) {
                    requestParam = (FormParam)annotation;
                    requestParamName = requestParam.value();
                } else if (annotation instanceof HeaderParam) {
                    requestParam = (HeaderParam)annotation;
                    requestParamName = requestParam.value();
                } else if (annotation instanceof MatrixParam) {
                    requestParam = (MatrixParam)annotation;
                    requestParamName = requestParam.value();
                } else if (annotation instanceof CookieParam) {
                    requestParam = (CookieParam)annotation;
                    requestParamName = requestParam.value();
                } else if (requestParamName == null && VirtualServiceType.CXF_JAX_RS.equals((Object)this.getVirtualServiceUtil().getVirtualServiceType())) {
                    try {
                        if (mockServiceRequest.getInputObjectType() != null) continue block4;
                        mockServiceRequest.setInputObjectType(Class.forName(methodSignature.getParameterTypes()[argIndex].getName()));
                        mockServiceRequest.setInput(args[argIndex]);
                    }
                    catch (ClassNotFoundException e) {
                        log.error(e.getMessage());
                    }
                    continue block4;
                }
                if (requestParamName == null) continue;
                if (args[argIndex] instanceof List) {
                    paramMap.put(requestParamName, this.addQueryParamValue(args[argIndex]));
                    parameters.put(requestParamName, this.addQueryParamValue(args[argIndex]));
                } else {
                    paramMap.put(requestParamName, String.valueOf(args[argIndex]));
                    parameters.put(requestParamName, args[argIndex]);
                }
                if (args[argIndex] == null) continue block4;
                paramMapType.put(requestParamName, args[argIndex].getClass());
                continue block4;
            }
        }
        mockServiceRequest.setParams(paramMap);
        mockServiceRequest.setParameters(parameters);
        mockServiceRequest.setParamsType(paramMapType);
    }
}

