/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.core;

import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.virtualan.csvson.Csvson;
import io.virtualan.cucumblan.jdbc.util.StreamingJsonResultSetExtractor;
import io.virtualan.cucumblan.props.ApplicationConfiguration;
import io.virtualan.cucumblan.props.util.ScenarioContext;
import io.virtualan.cucumblan.props.util.StepDefinitionHelper;
import io.virtualan.cucumblan.props.util.UtilHelper;
import io.virtualan.cucumblan.script.ExcelAndMathHelper;
import io.virtualan.mapson.Mapson;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class DBBaseStepDefinition {
    private static final Logger LOGGER = Logger.getLogger(DBBaseStepDefinition.class.getName());
    static Map<String, JdbcTemplate> jdbcTemplateMap = new HashMap<String, JdbcTemplate>();
    String sqlJson = null;
    Scenario scenario;
    private boolean skipScenario = false;

    public static void loadAllDataSource() {
        try {
            for (String key : ApplicationConfiguration.getProperties().keySet()) {
                String source;
                if (!key.contains(".cucumblan.jdbc.driver-class-name") || jdbcTemplateMap.containsKey(source = key.replaceAll(".cucumblan.jdbc.driver-class-name", ""))) continue;
                BasicDataSource dataSource = new BasicDataSource();
                dataSource.setDriverClassName(StepDefinitionHelper.getActualValue((Object)ApplicationConfiguration.getProperty((String)(source + ".cucumblan.jdbc.driver-class-name"))));
                dataSource.setUsername(StepDefinitionHelper.getActualValue((Object)ApplicationConfiguration.getProperty((String)(source + ".cucumblan.jdbc.username"))));
                dataSource.setPassword(StepDefinitionHelper.getActualValue((Object)ApplicationConfiguration.getProperty((String)(source + ".cucumblan.jdbc.password"))));
                dataSource.setUrl(StepDefinitionHelper.getActualValue((Object)ApplicationConfiguration.getProperty((String)(source + ".cucumblan.jdbc.url"))));
                dataSource.setMaxIdle(5);
                dataSource.setInitialSize(5);
                JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
                jdbcTemplateMap.put(source, jdbcTemplate);
            }
        }
        catch (Exception e) {
            LOGGER.severe("Unable to load properties :" + e.getMessage());
        }
    }

    @Before
    public void before(Scenario scenario) {
        this.scenario = scenario;
        this.skipScenario = false;
        this.sqlJson = null;
        if (jdbcTemplateMap.isEmpty()) {
            DBBaseStepDefinition.loadAllDataSource();
        }
    }

    @Given.Givens(value={@Given(value="as a user perform query (.*) action$"), @Given(value="as a user perform sql (.*) action$")})
    public void dummyGiven(String dummy) throws Exception {
    }

    @Given.Givens(value={@Given(value="execute DDL for the given query (.*) on (.*)$"), @Given(value="execute UPDATE for the given query (.*) on (.*)$"), @Given(value="execute DELETE for the given query (.*) on (.*)$"), @Given(value="execute INSERT for the given query (.*) on (.*)$"), @Given(value="execute DDL for the given sql (.*) on (.*)$"), @Given(value="execute UPDATE for the given (.*) on (.*)$"), @Given(value="execute DELETE for the given (.*) on (.*)$"), @Given(value="execute INSERT for the given (.*) on (.*)$")})
    public void insertSql(String dummy, String resource, List<String> sqls) throws Exception {
        if (!this.skipScenario) {
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate(resource);
            for (String sql : sqls) {
                try {
                    jdbcTemplate.execute(StepDefinitionHelper.getActualValue((Object)sql));
                }
                catch (Exception e) {
                    LOGGER.warning("Unable to load " + dummy + " this sqls " + sql + " : " + e.getMessage());
                    this.scenario.log("Unable to load " + dummy + " this sqls " + sql + " : " + e.getMessage());
                    Assert.assertTrue((String)(dummy + "  sqls are not inserted : (" + e.getMessage() + ")"), (boolean)false);
                }
            }
            Assert.assertTrue((String)"All sqls are executed successfully", (boolean)true);
        }
    }

    @Given(value="^perform-db the (.*) condition to skip scenario")
    public void modifyBooleanVariable(String condition) throws Exception {
        this.skipScenario = (Boolean)ExcelAndMathHelper.evaluateWithVariables(Boolean.class, (String)condition, (Map)ScenarioContext.getContext((String)String.valueOf(Thread.currentThread().getId())));
        this.scenario.log("condition :" + condition + " : is Skipped : " + this.skipScenario);
    }

    private JdbcTemplate getJdbcTemplate(String resource) throws Exception {
        if (jdbcTemplateMap.containsKey(resource)) {
            return jdbcTemplateMap.get(resource);
        }
        Assert.assertTrue((String)("Jdbc sources are not defined in configuration for : " + resource), (boolean)false);
        throw new Exception("Jdbc sources are not defined in configuration : ");
    }

    @Given(value="^store (.*) as key and query's (.*) as value")
    public void storeSqlResponseAskeySwap(String key, String responseKey) throws Exception {
        this.storeSqlResponseAskey(responseKey, key);
    }

    @Given(value="^store-sql's (.*) value of the key as (.*)")
    public void storeSqlResponseAskey(String responseKey, String key) throws Exception {
        if (!this.skipScenario) {
            if (this.sqlJson != null) {
                Map mapson = Mapson.buildMAPsonFromJson((String)this.sqlJson);
                if (mapson.get(responseKey) != null) {
                    ScenarioContext.setContext((String)String.valueOf(Thread.currentThread().getId()), (String)key, (String)UtilHelper.getObject((String)((String)mapson.get(responseKey))));
                } else {
                    Assert.assertTrue((String)(responseKey + " not found in the sql "), (boolean)false);
                }
            } else {
                Assert.assertTrue((String)" Sql query response not found for the executed query?  ", (boolean)false);
            }
        }
    }

    @Given.Givens(value={@Given(value="verify (.*) with the given sql (.*) on (.*)$"), @Given(value="validate (.*) given (.*) on (.*)$")})
    public void verify(String dummy1, String dummy, String resource, List<String> selectSql) throws Exception {
        if (!this.skipScenario) {
            int index = 0;
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate(resource);
            if (selectSql.size() >= 1 && selectSql.get(0).toLowerCase().startsWith("select")) {
                try {
                    this.sqlJson = this.getJson(resource, StepDefinitionHelper.getActualValue((Object)selectSql.get(0)));
                    index = 1;
                }
                catch (Exception e) {
                    Assert.assertTrue((String)(" Invalid query?? " + e.getMessage()), (boolean)false);
                }
            } else if (this.sqlJson != null) {
                index = 0;
            } else {
                Assert.assertTrue((String)" select query missing ", (boolean)false);
            }
            this.scenario.attach(new JSONArray(this.sqlJson).toString(4), "application/json", "ActualQueryResponse");
            if (selectSql.size() == 1) {
                Assert.assertNull((Object)this.sqlJson);
            } else {
                List<String> csvons = selectSql.subList(index, selectSql.size());
                JSONArray expectedArray = Csvson.buildCSVson(csvons, (Map)ScenarioContext.getContext((String)String.valueOf(Thread.currentThread().getId())));
                JSONArray actualArray = new JSONArray(this.sqlJson);
                JSONCompareResult result = JSONCompare.compareJSON((JSONArray)actualArray, (JSONArray)expectedArray, (JSONCompareMode)JSONCompareMode.LENIENT);
                this.scenario.attach(expectedArray.toString(4), "application/json", "ExpectedResponse:");
                if (result.failed()) {
                    this.scenario.log(result.getMessage());
                }
                Assert.assertTrue((String)" select sql and csvson record matches", (boolean)result.passed());
            }
        }
    }

    @Given.Givens(value={@Given(value="select (.*) with the given sql (.*) on (.*)$"), @Given(value="read (.*) given (.*) on (.*)$")})
    public void select(String dummy1, String dummy, String resource, List<String> selectSql) throws Exception {
        if (!this.skipScenario) {
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate(resource);
            if (selectSql.size() >= 1) {
                try {
                    this.scenario.attach(new JSONObject("{\"sql\" : \"" + StepDefinitionHelper.getActualValue((Object)selectSql.stream().collect(Collectors.joining("\n"))) + "\", \"resource\" : \"" + resource + "\" }").toString(4), "application/json", "SelectSql:");
                    this.sqlJson = this.getJson(resource, StepDefinitionHelper.getActualValue((Object)selectSql.stream().collect(Collectors.joining("\n"))));
                    this.scenario.attach(this.sqlJson, "application/json", "SqlResponse:");
                }
                catch (Exception e) {
                    Assert.assertTrue((String)(" Invalid sql? " + e.getMessage()), (boolean)false);
                }
            } else {
                Assert.assertTrue((String)" select sql missing ", (boolean)false);
            }
        }
    }

    private String getJson(String resource, String sql) throws Exception {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate(resource);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        jdbcTemplate.query(sql, (ResultSetExtractor)new StreamingJsonResultSetExtractor(os));
        return ((Object)os).toString();
    }
}

