/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.jdbc.util;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.springframework.jdbc.core.ResultSetExtractor;

public class StreamingJsonResultSetExtractor
implements ResultSetExtractor<Void> {
    private final OutputStream os;

    public StreamingJsonResultSetExtractor(OutputStream os) {
        this.os = os;
    }

    public Void extractData(ResultSet rs) {
        ObjectMapper objectMapper = new ObjectMapper();
        try (JsonGenerator jg = objectMapper.getFactory().createGenerator(this.os, JsonEncoding.UTF8);){
            StreamingJsonResultSetExtractor.writeResultSetToJson(rs, jg);
            jg.flush();
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static void writeResultSetToJson(ResultSet rs, JsonGenerator jg) throws SQLException, IOException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        jg.writeStartArray();
        while (rs.next()) {
            jg.writeStartObject();
            for (int i = 1; i <= columnCount; ++i) {
                jg.writeObjectField(rsmd.getColumnName(i), rs.getObject(i));
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }
}

