/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.core;

import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.virtualan.csvson.Csvson;
import io.virtualan.cucumblan.jdbc.util.StreamingJsonResultSetExtractor;
import io.virtualan.cucumblan.props.ApplicationConfiguration;
import io.virtualan.cucumblan.props.util.ScenarioContext;
import io.virtualan.cucumblan.props.util.StepDefinitionHelper;
import io.virtualan.mapson.Mapson;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class DBBaseStepDefinition {
    private static final Logger LOGGER = Logger.getLogger(DBBaseStepDefinition.class.getName());
    static Map<String, JdbcTemplate> jdbcTemplateMap = new HashMap<String, JdbcTemplate>();
    String sqlJson = null;
    Scenario scenario;

    public static void loadAllDataSource() {
        try {
            for (String key : ApplicationConfiguration.getProperties().keySet()) {
                String source;
                if (!key.contains(".cucumblan.jdbc.driver-class-name") || jdbcTemplateMap.containsKey(source = key.replaceAll(".cucumblan.jdbc.driver-class-name", ""))) continue;
                BasicDataSource dataSource = new BasicDataSource();
                dataSource.setDriverClassName(ApplicationConfiguration.getProperty(source + ".cucumblan.jdbc.driver-class-name"));
                dataSource.setUsername(ApplicationConfiguration.getProperty(source + ".cucumblan.jdbc.username"));
                dataSource.setPassword(ApplicationConfiguration.getProperty(source + ".cucumblan.jdbc.password"));
                dataSource.setUrl(ApplicationConfiguration.getProperty(source + ".cucumblan.jdbc.url"));
                dataSource.setMaxIdle(5);
                dataSource.setInitialSize(5);
                JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
                jdbcTemplateMap.put(source, jdbcTemplate);
            }
        }
        catch (Exception e) {
            LOGGER.severe("Unable to load properties :" + e.getMessage());
        }
    }

    @Before
    public void before(Scenario scenario) {
        this.scenario = scenario;
        this.sqlJson = null;
        if (jdbcTemplateMap.isEmpty()) {
            DBBaseStepDefinition.loadAllDataSource();
        }
    }

    @Given(value="As a user perform sql (.*) action$")
    public void dummyGiven(String dummy) throws Exception {
    }

    @Given.Givens(value={@Given(value="Execute DDL for the given sql (.*) on (.*)$"), @Given(value="Execute UPDATE for the given sql (.*) on (.*)$"), @Given(value="Execute DELETE for the given sql (.*) on (.*)$"), @Given(value="Execute INSERT for the given sql (.*) on (.*)$")})
    public void insertSql(String dummy, String resource, List<String> sqls) throws Exception {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate(resource);
        for (String sql : sqls) {
            try {
                jdbcTemplate.execute(StepDefinitionHelper.getActualValue(sql).toString());
            }
            catch (Exception e) {
                LOGGER.warning("Unable to load " + dummy + " this sqls " + sql + " : " + e.getMessage());
                this.scenario.log("Unable to load " + dummy + " this sqls " + sql + " : " + e.getMessage());
                Assert.assertTrue((String)(dummy + "  sqls are not inserted : (" + e.getMessage() + ")"), (boolean)false);
            }
        }
        Assert.assertTrue((String)"All sqls are executed successfully", (boolean)true);
    }

    private JdbcTemplate getJdbcTemplate(String resource) throws Exception {
        if (jdbcTemplateMap.containsKey(resource)) {
            return jdbcTemplateMap.get(resource);
        }
        Assert.assertTrue((String)("Jdbc sources are not defined in configuration for : " + resource), (boolean)false);
        throw new Exception("Jdbc sources are not defined in configuration : ");
    }

    @Given(value="^Store-sql's (.*) value of the key as (.*)")
    public void storeSqlResponseAskey(String responseKey, String key) throws JSONException {
        if (this.sqlJson != null) {
            Map mapson = Mapson.buildMAPsonFromJson((String)this.sqlJson);
            if (mapson.get(responseKey) != null) {
                ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), key, (String)mapson.get(responseKey));
            } else {
                Assert.assertTrue((String)(responseKey + " not found in the sql "), (boolean)false);
            }
        }
    }

    @Given(value="Verify (.*) with the given sql (.*) on (.*)$")
    public void verify(String dummy1, String dummy, String resource, List<String> selectSql) throws Exception {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate(resource);
        if (selectSql.size() >= 1) {
            try {
                this.sqlJson = this.getJson(resource, StepDefinitionHelper.getActualValue(selectSql.get(0)).toString());
            }
            catch (Exception e) {
                Assert.assertTrue((String)(" Invalid sqls?? " + e.getMessage()), (boolean)false);
            }
        } else {
            Assert.assertTrue((String)" select sqls missing ", (boolean)false);
        }
        this.scenario.attach(this.sqlJson, "application/json", "ActualSqlResponse");
        if (selectSql.size() == 1) {
            Assert.assertNull((Object)this.sqlJson);
        } else {
            List<String> csvons = selectSql.subList(1, selectSql.size());
            JSONArray expectedArray = Csvson.buildCSVson(csvons, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())));
            JSONArray actualArray = new JSONArray(this.sqlJson);
            JSONCompareResult result = JSONCompare.compareJSON((JSONArray)actualArray, (JSONArray)expectedArray, (JSONCompareMode)JSONCompareMode.LENIENT);
            this.scenario.attach(expectedArray.toString(), "application/json", "ExpectedCvsonResponse");
            if (result.failed()) {
                this.scenario.log(result.getMessage());
            }
            Assertions.assertTrue((boolean)result.passed(), (String)" select sql and cvson record matches");
        }
    }

    private String getJson(String resource, String sql) throws Exception {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate(resource);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        jdbcTemplate.query(sql, (ResultSetExtractor)new StreamingJsonResultSetExtractor(os));
        return ((Object)os).toString();
    }
}

