/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.parser;

import io.swagger.models.Swagger;
import io.swagger.parser.Swagger20Parser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.virtualan.cucumblan.exception.ParserError;
import io.virtualan.cucumblan.props.ApplicationConfiguration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.logging.Logger;

public class OpenAPIParser {
    private static final Logger LOGGER = Logger.getLogger(OpenAPIParser.class.getName());

    public static void loader() throws ParserError {
        Map properties = ApplicationConfiguration.getProperties();
        for (Map.Entry property : properties.entrySet()) {
            if (((String)property.getKey()).indexOf(".api.spec.") == -1) continue;
            OpenAPIParser.init(((String)property.getKey()).substring(((String)property.getKey()).indexOf(".api.spec.") + 10), (String)property.getValue());
        }
    }

    public static void init(String system, String url) throws ParserError {
        block17: {
            try {
                if (new File("conf/endpoint." + system + ".properties").exists()) break block17;
                OpenAPI openAPI = null;
                try {
                    openAPI = new OpenAPIV3Parser().read(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (openAPI == null) {
                    Swagger swagger = new Swagger20Parser().read(url, null);
                    Map path2s = swagger.getPaths();
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("conf/endpoint." + system + ".properties"), "utf-8"));){
                        for (Map.Entry mapPath : path2s.entrySet()) {
                            writer.write(((String)mapPath.getKey()).substring(1).replaceAll("/", "_").replace("-", "_").replace("{", "").replace("}", "") + "=" + (String)mapPath.getKey());
                            writer.write("\n");
                        }
                        break block17;
                    }
                }
                Paths paths = openAPI.getPaths();
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("conf/endpoint." + system + ".properties"), "utf-8"));){
                    for (Map.Entry mapPath : paths.entrySet()) {
                        writer.write(((String)mapPath.getKey()).substring(1).replaceAll("/", "_").replace("-", "_").replace("{", "").replace("}", "") + "=" + (String)mapPath.getKey());
                        writer.write("\n");
                    }
                }
            }
            catch (Exception e) {
                LOGGER.fine("Unable to create endpoint mapping url mapping : " + e.getMessage());
                throw new ParserError("Unable to create endpoint mapping url mapping : " + e.getMessage());
            }
        }
    }
}

