/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.props;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExcludeConfiguration {
    static Properties excludeProperties = new Properties();
    static List<String> excludeList = new ArrayList<String>();
    static String excludes = null;
    private static final Logger LOGGER = Logger.getLogger(ExcludeConfiguration.class.getName());

    public static void reload() {
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("exclude-response.properties");
            if (stream == null) {
                stream = ExcludeConfiguration.class.getClassLoader().getResourceAsStream("exclude-response.properties");
            }
            if (stream != null) {
                excludeProperties.load(stream);
            } else {
                LOGGER.warning("exclude-response.properties is not configured yet? Do you need?");
            }
        }
        catch (Exception e) {
            LOGGER.warning("exclude-response.properties is not loaded");
        }
    }

    private static boolean findMatch(Map<String, String> excludeProperties, String actual) {
        for (Map.Entry<String, String> entry : excludeProperties.entrySet()) {
            if (!actual.matches(entry.getKey().toString())) continue;
            return entry.getValue().toString().equalsIgnoreCase("IGNORE");
        }
        return false;
    }

    private static boolean findMatch(String actual) {
        for (Map.Entry<Object, Object> entry : excludeProperties.entrySet()) {
            if (!actual.matches(entry.getKey().toString())) continue;
            return entry.getValue().toString().equalsIgnoreCase("IGNORE");
        }
        return false;
    }

    public static boolean shouldSkip(String resource, String keyName) {
        String excludes = excludeProperties.getProperty(resource);
        if (excludes != null && excludes.equalsIgnoreCase("IGNORE")) {
            LOGGER.info(" Skipping response comparison for resource : " + resource);
            return true;
        }
        if (excludes != null && keyName != null && !excludes.trim().isEmpty()) {
            excludeList = Stream.of(excludes.split(",")).collect(Collectors.toList());
            return excludeList.contains(keyName) || excludeList.stream().anyMatch(x -> keyName.contains((CharSequence)x));
        }
        if (excludes == null && ExcludeConfiguration.findMatch(resource)) {
            LOGGER.info(" Skipping comparison for resource based on pattern : " + resource);
            return true;
        }
        return false;
    }

    public static boolean shouldSkip(Map<String, String> excludeProperties, String resource, String keyName) {
        String excludes = excludeProperties.get(resource);
        if (excludes != null && excludes.equalsIgnoreCase("IGNORE")) {
            LOGGER.info(" Skipping response comparison for resource : " + resource);
            return true;
        }
        if (excludes != null && keyName != null && !excludes.trim().isEmpty()) {
            List excludeList = Stream.of(excludes.split(",")).collect(Collectors.toList());
            return excludeList.contains(keyName) || excludeList.stream().anyMatch(x -> keyName.contains((CharSequence)x));
        }
        if (excludes == null && ExcludeConfiguration.findMatch(excludeProperties, resource)) {
            LOGGER.info(" Skipping comparison for resource based on pattern : " + resource);
            return true;
        }
        return false;
    }

    public static Map<String, String> getProperties() {
        ExcludeConfiguration.reload();
        return excludeProperties;
    }

    static {
        ExcludeConfiguration.reload();
    }
}

