/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.props.util;

import io.virtualan.cucumblan.props.ApplicationConfiguration;
import io.virtualan.cucumblan.props.EndpointConfiguration;
import io.virtualan.cucumblan.props.util.StepDefinitionHelper;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiHelper {
    private static final Logger log = LoggerFactory.getLogger(ApiHelper.class);

    public static String getHostName(String resourceKey, String system) {
        if (ApplicationConfiguration.getProperty("service.api." + system) == null) {
            if (ApplicationConfiguration.getProperty("service.api") != null) {
                return ApplicationConfiguration.getProperty("service.api");
            }
            return resourceKey;
        }
        return ApplicationConfiguration.getProperty("service.api." + system);
    }

    public static String getActualResource(String resourceKey, String system) {
        Properties props = EndpointConfiguration.getInstance().getProperty(system);
        if (ApplicationConfiguration.getProperty("service.api." + system) == null) {
            if (ApplicationConfiguration.getProperty("service.api") != null) {
                String url = ApplicationConfiguration.getProperty("service.api") + (props != null && props.getProperty(resourceKey) != null ? props.getProperty(resourceKey) : resourceKey);
                return url;
            }
            log.warn("service.api : configuration is missing.. Unable to proceed");
            System.exit(-1);
        }
        String url = ApplicationConfiguration.getProperty("service.api." + system) + (props != null && props.getProperty(resourceKey) != null ? props.getProperty(resourceKey) : resourceKey);
        return StepDefinitionHelper.getActualValue(url);
    }
}

