/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.core;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.And;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.http.ContentType;
import io.restassured.http.Cookie;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import io.virtualan.csvson.Csvson;
import io.virtualan.cucumblan.exception.ParserError;
import io.virtualan.cucumblan.parser.OpenAPIParser;
import io.virtualan.cucumblan.props.ApplicationConfiguration;
import io.virtualan.cucumblan.props.EndpointConfiguration;
import io.virtualan.cucumblan.props.ExcludeConfiguration;
import io.virtualan.cucumblan.props.util.ApiHelper;
import io.virtualan.cucumblan.props.util.HelperUtil;
import io.virtualan.cucumblan.props.util.ScenarioContext;
import io.virtualan.cucumblan.props.util.StepDefinitionHelper;
import io.virtualan.cucumblan.script.ExcelAndMathHelper;
import io.virtualan.cucumblan.standard.StandardProcessing;
import io.virtualan.mapson.Mapson;
import io.virtualan.util.Helper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.xmlbeans.impl.util.Base64;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;

public class BaseStepDefinition {
    private static final Logger LOGGER = Logger.getLogger(BaseStepDefinition.class.getName());
    private static Map<String, StandardProcessing> stdProcessorMap = new HashMap<String, StandardProcessing>();
    private Response response;
    private ValidatableResponse validatableResponse;
    private String jsonBody;
    private RequestSpecification request = RestAssured.given();
    private Scenario scenario;
    private int sequence;
    private String acceptContentType;
    private boolean skipScenario = false;

    public static void loadStandardProcessors() {
        Reflections reflections = new Reflections(ApplicationConfiguration.getStandardPackage(), new Scanner[]{new SubTypesScanner(false)});
        Set classes = reflections.getSubTypesOf(StandardProcessing.class);
        classes.stream().forEach(x -> {
            StandardProcessing action = null;
            try {
                action = (StandardProcessing)x.newInstance();
                stdProcessorMap.put(action.getType(), action);
            }
            catch (InstantiationException e) {
                LOGGER.warning("Unable to process this action (" + action.getType() + ") class: " + action);
            }
            catch (IllegalAccessException e) {
                LOGGER.warning("Unable to process this action (" + action.getType() + ") class: " + action);
            }
        });
    }

    @Given(value="^(.*) with an path param (.*) of (.*)")
    public void readRequestByPathParam(String dummy, String identifier, String value) {
        if (!this.skipScenario) {
            this.request = RestAssured.given().pathParam(identifier, (Object)StepDefinitionHelper.getActualValue(value));
        }
    }

    @Given(value="^enable cert for (.*) of (.*)")
    public void cert(String identifier, String value) {
        if (!this.skipScenario) {
            RestAssured.authentication = RestAssured.certificate((String)identifier, (String)value);
        }
    }

    @Given(value="^basic authentication with (.*) and (.*)")
    public void auth(String username, String password) {
        if (!this.skipScenario) {
            byte[] authBasic = Base64.encode((byte[])String.format("%s:%s", StepDefinitionHelper.getActualValue(username), StepDefinitionHelper.getActualValue(password)).getBytes());
            this.request.header("Authorization", (Object)String.format("Basic %s", new String(authBasic)), new Object[0]);
        }
    }

    @Given(value="^(.*) auth with (.*) token$")
    public void bearer(String auth, String token) {
        if (!this.skipScenario) {
            this.request.header("Authorization", (Object)String.format("%s %s", auth, Helper.getActualValueForAll((Object)token, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())))), new Object[0]);
        }
    }

    @Given(value="^(.*) perform a api action")
    public void readRequestByPathParam(String dummy) {
        if (!this.skipScenario) {
            this.request = RestAssured.given();
        }
    }

    @Given(value="^(.*) with an header param (.*) of (.*)")
    public void readRequestByHeaderParam(String dummy, String identifier, String value) {
        if (!this.skipScenario) {
            if ("Accept".equalsIgnoreCase(identifier)) {
                this.acceptContentType = value;
            }
            this.request = this.request.header(identifier, (Object)StepDefinitionHelper.getActualValue(value), new Object[0]);
        }
    }

    @Given(value="add (.*) with given header params$")
    public void readAllHeaderParams(String nameIgnore, Map<String, String> parameterMap) {
        if (!this.skipScenario) {
            for (Map.Entry<String, String> params : parameterMap.entrySet()) {
                if ("Accept".equalsIgnoreCase(params.getKey())) {
                    this.acceptContentType = StepDefinitionHelper.getActualValue(params.getValue());
                }
                this.request = this.request.header(params.getKey(), (Object)StepDefinitionHelper.getActualValue(params.getValue()), new Object[0]);
            }
        }
    }

    @Given(value="add (.*) with given cookie params$")
    public void readAllCookieParams(String nameIgnore, Map<String, String> parameterMap) {
        if (!this.skipScenario) {
            for (Map.Entry<String, String> params : parameterMap.entrySet()) {
                this.request = this.request.cookie(new Cookie.Builder(params.getKey(), StepDefinitionHelper.getActualValue(params.getValue())).build());
            }
        }
    }

    @Given(value="^(.*) with an query param (.*) of (.*)")
    public void readRequestByQueryParam(String dummy, String identifier, String value) {
        if (!this.skipScenario) {
            this.request = RestAssured.given().queryParam(identifier, new Object[]{StepDefinitionHelper.getActualValue(value)});
        }
    }

    @Given(value="^Provided all the feature level parameters$")
    public void loadGlobalParam(Map<String, String> globalParams) throws IOException {
        if (!this.skipScenario) {
            ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), globalParams);
            this.scenario.attach(new JSONObject(ScenarioContext.getPrintableContextObject(String.valueOf(Thread.currentThread().getId()))).toString(), "application/json", "requestData :  ContextId" + String.valueOf(Thread.currentThread().getId()));
        }
    }

    @Given(value="^Provided all the feature level parameters from file$")
    public void loadGlobalParamFromFile() throws IOException {
        if (!this.skipScenario) {
            Properties properties = new Properties();
            InputStream stream = ApplicationConfiguration.class.getClassLoader().getResourceAsStream("cucumblan-env.properties");
            if (stream != null) {
                properties.load(stream);
                ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), properties);
                this.scenario.attach(new JSONObject(ScenarioContext.getPrintableContextObject(String.valueOf(Thread.currentThread().getId()))).toString(), "application/json", "ContextId" + String.valueOf(Thread.currentThread().getId()));
            } else {
                LOGGER.warning("cucumblan-env.properties is not configured. Need to add if default data loaded");
            }
        }
    }

    @Then(value="^Verify all the feature level parameters exists")
    public void validateGlobalParam() {
        if (!this.skipScenario) {
            Assert.assertTrue((String)"Valid Global Parameters are present ", (boolean)ScenarioContext.hasContextValues(String.valueOf(Thread.currentThread().getId())));
        }
    }

    @Given(value="^Add the (.*) value of the key as (.*)")
    public void addVariable(String responseValue, String key) {
        if (!this.skipScenario) {
            if (responseValue.startsWith("[") && responseValue.endsWith("]")) {
                ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), key, Helper.getActualValueForAll((Object)responseValue, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId()))).toString());
            } else {
                ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), key, responseValue);
            }
        }
    }

    @Given(value="^evaluate the (.*) decimal value of the key as (.*)")
    public void modifyDecimalVariable(String responseValue, String key) throws IOException {
        if (!this.skipScenario) {
            ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), key, ExcelAndMathHelper.evaluateWithVariables(Double.class, responseValue, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId()))).toString());
        }
    }

    @Given(value="^evaluate the (.*) integer value of the key as (.*)")
    public void modifyIntVariable(String responseValue, String key) throws IOException {
        if (!this.skipScenario) {
            ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), key, ExcelAndMathHelper.evaluateWithVariables(Integer.class, responseValue, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId()))).toString());
        }
    }

    @Given(value="^perform the (.*) condition to skip scenario")
    public void modifyBooleanVariable(String condition) throws IOException {
        this.skipScenario = (Boolean)ExcelAndMathHelper.evaluateWithVariables(Boolean.class, condition, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())));
        this.scenario.log("condition :" + condition + " : is Skipped : " + this.skipScenario);
    }

    @Given(value="^evaluate the (.*) condition success$")
    public void evaluateVariable(String condition) throws IOException {
        if (!this.skipScenario) {
            boolean flag = (Boolean)ExcelAndMathHelper.evaluateWithVariables(Boolean.class, condition, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())));
            this.scenario.log("Success condition :" + condition + " >>> status " + flag);
            Assert.assertTrue((String)("Valid success" + condition + " is met "), (boolean)flag);
        }
    }

    @Given(value="^evaluate the (.*) condition fail$")
    public void evaluateVariableFail(String condition) throws IOException {
        if (!this.skipScenario) {
            boolean flag = (Boolean)ExcelAndMathHelper.evaluateWithVariables(Boolean.class, condition, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())));
            this.scenario.log("Failure condition :" + condition + " >>> status " + flag);
            Assert.assertTrue((String)("Valid Failure" + condition + " is met "), (boolean)flag);
        }
    }

    @Given(value="^evaluate the (.*) boolean value of the key as (.*)")
    public void modifyBooleanVariable(String responseValue, String key) throws IOException {
        if (!this.skipScenario) {
            ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), key, ExcelAndMathHelper.evaluateWithVariables(Boolean.class, responseValue, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId()))).toString());
        }
    }

    @Given(value="^Modify the (.*) value of the key as (.*)")
    public void modifyStringVariable(String responseValue, String key) throws IOException {
        if (!this.skipScenario) {
            ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), key, Helper.getActualValueForAll((Object)responseValue, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId()))).toString());
        }
    }

    @Given(value="^Store the (.*) value of the key as (.*)")
    public void storeResponseAskey(String responseKey, String key) {
        if (!this.skipScenario) {
            String value = this.validatableResponse.extract().body().jsonPath().getString(responseKey);
            if (value != null) {
                ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), key, this.validatableResponse.extract().body().jsonPath().getString(responseKey));
            } else if (this.response.getCookie(responseKey) != null) {
                ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), key, this.response.getCookie(responseKey));
            } else if (this.response.getHeader(responseKey) != null) {
                ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), key, this.response.getHeader(responseKey));
            } else {
                LOGGER.warning(responseKey + " :  for " + key + " not found");
                this.scenario.log(responseKey + " :  for " + key + " not found");
            }
        }
    }

    @Given(value="^add (.*) with given path params$")
    public void readParamsRequest(String nameIgnore, Map<String, String> parameterMap) {
        if (!this.skipScenario) {
            this.request = this.request.contentType("application/json");
            for (Map.Entry<String, String> params : parameterMap.entrySet()) {
                this.request = this.request.pathParam(params.getKey(), (Object)StepDefinitionHelper.getActualValue(params.getValue()));
            }
        }
    }

    @Given(value="^add (.*) with (.*) given form params$")
    public void readMultiParamsRequest(String nameIgnore, String contentType, Map<String, String> parameterMap) {
        if (!this.skipScenario) {
            this.request = this.request.config(RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs(contentType, ContentType.fromContentType((String)contentType))));
            for (Map.Entry<String, String> params : parameterMap.entrySet()) {
                this.request = this.request.param(params.getKey(), new Object[]{StepDefinitionHelper.getActualValue(params.getValue())});
            }
        }
    }

    @Given(value="^add (.*) with (.*) given multipart-form params$")
    public void readPathParamsRequest(String nameIgnore, String contentType, Map<String, String> parameterMap) {
        if (!this.skipScenario) {
            this.request = this.request.config(RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs(contentType, ContentType.fromContentType((String)contentType))));
            for (Map.Entry<String, String> params : parameterMap.entrySet()) {
                if (params.getKey().contains("MULTI-PART")) {
                    if (params.getValue() == null) continue;
                    String fileAndType = StepDefinitionHelper.getActualValue(params.getValue());
                    if (params.getKey().split("=").length == 2 && fileAndType.split("=").length == 2) {
                        this.request = this.request.multiPart(params.getKey().split("=")[1], new File(BaseStepDefinition.class.getClassLoader().getResource(fileAndType.split("=")[0]).getFile()), fileAndType.split("=")[1]);
                        continue;
                    }
                    this.scenario.log("MULTI-PART was not set up correctly. should be like key => MULTI-PART => MULTI-PART=uploadtext.txt  value => filename.txt=plain/txt");
                    LOGGER.warning("MULTI-PART was not set up correctly. should be like key => MULTI-PART => MULTI-PART=uploadtext.txt  value => filename.txt=plain/txt");
                    continue;
                }
                this.request = this.request.param(params.getKey(), new Object[]{StepDefinitionHelper.getActualValue(params.getValue())});
            }
        }
    }

    @Given(value="add (.*) with given query params$")
    public void readRequest(String nameIgnore, Map<String, String> parameterMap) {
        if (!this.skipScenario) {
            this.request = this.request.contentType("application/json");
            for (Map.Entry<String, String> params : parameterMap.entrySet()) {
                this.request = this.request.queryParam(params.getKey(), new Object[]{StepDefinitionHelper.getActualValue(params.getValue())});
            }
        }
    }

    @Given(value="add (.*) with contentType (.*) given query params$")
    public void readRequest(String nameIgnore, String contentType, Map<String, String> parameterMap) {
        if (!this.skipScenario) {
            this.request = this.request.contentType(contentType);
            for (Map.Entry<String, String> params : parameterMap.entrySet()) {
                this.request = this.request.queryParam(params.getKey(), new Object[]{StepDefinitionHelper.getActualValue(params.getValue())});
            }
        }
    }

    @Given(value="^Populate (.*) with contentType(.*) given input$")
    public void loadRequest(String nameIgnore, String contentType, Map<String, String> parameterMap) {
        if (!this.skipScenario) {
            this.request = this.request.contentType(contentType);
            for (Map.Entry<String, String> params : parameterMap.entrySet()) {
                this.request = this.request.queryParam(params.getKey(), new Object[]{StepDefinitionHelper.getActualValue(params.getValue())});
            }
        }
    }

    @Given(value="^Populate (.*) with given input$")
    public void loadRequest(String nameIgnore, Map<String, String> parameterMap) {
        if (!this.skipScenario) {
            this.request = this.request.contentType("application/json");
            for (Map.Entry<String, String> params : parameterMap.entrySet()) {
                this.request = this.request.queryParam(params.getKey(), new Object[]{StepDefinitionHelper.getActualValue(params.getValue())});
            }
        }
    }

    @Given(value="^add (.*) data with (.*) given input$")
    public void createRequest(String body, String contentType) {
        if (!this.skipScenario) {
            this.request = this.request.contentType(contentType).body(body);
        }
    }

    @Given(value="add (.*) data file with (.*) given input$")
    public void createFileRequest(String fileBody, String contentType) throws IOException {
        if (!this.skipScenario) {
            String body = HelperUtil.readFileAsString(fileBody);
            if (body != null) {
                HashMap<String, String> mapHeader = new HashMap<String, String>();
                mapHeader.put("content-type", contentType);
                this.request = this.request.headers(mapHeader).contentType(contentType).body(body);
            } else {
                Assert.assertTrue((String)(fileBody + " input file is missing "), (boolean)false);
            }
        }
    }

    @Given(value="add (.*) data inline with (.*) given input$")
    public void createInlineRequest(String fileBody, String contentType, List<String> input) throws IOException {
        if (!this.skipScenario) {
            if (input != null && !input.isEmpty()) {
                HashMap<String, String> mapHeader = new HashMap<String, String>();
                mapHeader.put("content-type", contentType);
                String listString = input.stream().map(Object::toString).collect(Collectors.joining());
                this.request = this.request.headers(mapHeader).contentType(contentType).body(listString);
            } else {
                Assert.assertTrue((String)(fileBody + " input inline is missing "), (boolean)false);
            }
        }
    }

    @Given(value="^Create (.*) with contentType (.*) given input$")
    public void createRequest(String nameIgnore, String contentType, Map<String, String> parameterMap) throws Exception {
        if (!this.skipScenario) {
            this.jsonBody = Mapson.buildMAPsonAsJson(parameterMap, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())));
            this.scenario.attach(this.jsonBody, contentType, "requestData :  ");
            this.request = this.request.contentType(contentType).body(this.jsonBody);
        }
    }

    @Given(value="^Create (.*) with given input$")
    public void createRequest(String nameIgnore, Map<String, String> parameterMap) throws Exception {
        if (!this.skipScenario) {
            this.jsonBody = Mapson.buildMAPsonAsJson(parameterMap, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())));
            if (StepDefinitionHelper.getJSON(this.jsonBody) instanceof JSONArray) {
                this.scenario.attach(new JSONArray(this.jsonBody).toString(4), "application/json", "requestData :  ");
            } else {
                this.scenario.attach(new JSONObject(this.jsonBody).toString(4), "application/json", "requestData :  ");
            }
            this.request = this.request.contentType("application/json").body(this.jsonBody);
        }
    }

    @Given(value="^Update (.*) with given input$")
    public void updateRequest(String nameIgnore, Map<String, String> parameterMap) throws Exception {
        if (!this.skipScenario) {
            this.jsonBody = Mapson.buildMAPsonAsJson(parameterMap, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())));
            this.scenario.attach(this.jsonBody, "application/json", "requestData :  ");
            this.request = this.request.contentType("application/json").body(this.jsonBody);
        }
    }

    @Given(value="^Update (.*) with contentType (.*) given input$")
    public void updateRequest(String nameIgnore, String contentType, Map<String, String> parameterMap) throws Exception {
        if (!this.skipScenario) {
            this.jsonBody = Mapson.buildMAPsonAsJson(parameterMap, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())));
            this.scenario.attach(this.jsonBody, "application/json", "requestData :  ");
            this.request = this.request.contentType(contentType).body(this.jsonBody);
        }
    }

    @When(value="^(.*) post (.*) in (.*) resource on (.*)")
    public void createRequest(String dummyString, String acceptContentType, String resource, String system) {
        resource = StepDefinitionHelper.getActualValue(resource);
        if (!this.skipScenario) {
            String url = ApiHelper.getHostName(resource, system);
            acceptContentType = this.acceptContentType != null ? this.acceptContentType : acceptContentType;
            String resourceDetails = ApiHelper.getActualResource(resource, system);
            JSONObject object = new JSONObject();
            object.put("url", (Object)url);
            object.put("AcceptContentType", (Object)acceptContentType);
            object.put("resource", (Object)resourceDetails);
            object.put("context", (Object)new JSONObject(ScenarioContext.getPrintableContextObject(String.valueOf(Thread.currentThread().getId()))));
            this.scenario.attach(object.toString(4), "application/json", "requestData :  ");
            this.response = (Response)((RequestSpecification)this.request.baseUri(url).when().log().all()).accept(acceptContentType).post(resourceDetails, new Object[0]);
        }
    }

    @When(value="^(.*) get (.*) in (.*) resource on (.*)")
    public void readRequest(String dummyString, String acceptContentType, String resource, String system) {
        resource = StepDefinitionHelper.getActualValue(resource);
        if (!this.skipScenario) {
            String url = ApiHelper.getHostName(resource, system);
            String contentType = this.acceptContentType != null ? this.acceptContentType : acceptContentType;
            String resourceDetails = ApiHelper.getActualResource(resource, system);
            JSONObject object = new JSONObject();
            object.put("url", (Object)url);
            object.put("AcceptContentType", (Object)contentType);
            object.put("resource", (Object)resourceDetails);
            object.put("context", (Object)new JSONObject(ScenarioContext.getPrintableContextObject(String.valueOf(Thread.currentThread().getId()))));
            this.scenario.attach(object.toString(4), "application/json", "requestData :  ");
            this.response = (Response)((RequestSpecification)this.request.baseUri(ApiHelper.getHostName(resource, system)).when().log().all()).accept(acceptContentType).get(ApiHelper.getActualResource(resource, system), new Object[0]);
        }
    }

    @When(value="^(.*) put (.*) in (.*) resource on (.*)")
    public void modifyRequest(String dummyString, String acceptContentType, String resource, String system) {
        resource = StepDefinitionHelper.getActualValue(resource);
        if (!this.skipScenario) {
            String url = ApiHelper.getHostName(resource, system);
            acceptContentType = this.acceptContentType != null ? this.acceptContentType : acceptContentType;
            String resourceDetails = ApiHelper.getActualResource(resource, system);
            JSONObject object = new JSONObject();
            object.put("url", (Object)url);
            object.put("AcceptContentType", (Object)acceptContentType);
            object.put("resource", (Object)resourceDetails);
            object.put("context", (Object)new JSONObject(ScenarioContext.getPrintableContextObject(String.valueOf(Thread.currentThread().getId()))));
            this.scenario.attach(object.toString(4), "application/json", "requestData :  ");
            this.response = (Response)((RequestSpecification)this.request.baseUri(ApiHelper.getHostName(resource, system)).when().log().all()).accept(acceptContentType).put(ApiHelper.getActualResource(resource, system), new Object[0]);
        }
    }

    @When(value="^(.*) patch (.*) in (.*) resource on (.*)")
    public void patchRequest(String dummyString, String acceptContentType, String resource, String system) {
        resource = StepDefinitionHelper.getActualValue(resource);
        if (!this.skipScenario) {
            String url = ApiHelper.getHostName(resource, system);
            acceptContentType = this.acceptContentType != null ? this.acceptContentType : acceptContentType;
            String resourceDetails = ApiHelper.getActualResource(resource, system);
            JSONObject object = new JSONObject();
            object.put("url", (Object)url);
            object.put("AcceptContentType", (Object)acceptContentType);
            object.put("resource", (Object)resourceDetails);
            object.put("context", (Object)new JSONObject(ScenarioContext.getPrintableContextObject(String.valueOf(Thread.currentThread().getId()))));
            this.scenario.attach(object.toString(4), "application/json", "requestData :  ");
            this.response = (Response)((RequestSpecification)this.request.baseUri(ApiHelper.getHostName(resource, system)).when().log().all()).accept(acceptContentType).patch(ApiHelper.getActualResource(resource, system), new Object[0]);
        }
    }

    @When(value="^(.*) delete (.*) in (.*) resource on (.*)")
    public void deleteById(String dummyString, String acceptContentType, String resource, String system) {
        resource = StepDefinitionHelper.getActualValue(resource);
        if (!this.skipScenario) {
            String url = ApiHelper.getHostName(resource, system);
            acceptContentType = this.acceptContentType != null ? this.acceptContentType : acceptContentType;
            String resourceDetails = ApiHelper.getActualResource(resource, system);
            JSONObject object = new JSONObject();
            object.put("url", (Object)url);
            object.put("AcceptContentType", (Object)acceptContentType);
            object.put("resource", (Object)resourceDetails);
            object.put("context", (Object)new JSONObject(ScenarioContext.getPrintableContextObject(String.valueOf(Thread.currentThread().getId()))));
            this.scenario.attach(object.toString(4), "application/json", "requestData :  ");
            this.response = (Response)((RequestSpecification)this.request.baseUri(ApiHelper.getHostName(resource, system)).when().log().all()).accept(acceptContentType).delete(ApiHelper.getActualResource(resource, system), new Object[0]);
        }
    }

    @Before
    public void before(Scenario scenario) {
        this.scenario = scenario;
        System.out.println("scenario ID:: " + scenario.getId());
        this.sequence = 1;
        this.acceptContentType = null;
        this.skipScenario = false;
    }

    @Then(value="^Verify the status code is (\\d+)")
    public void verifyStatusCode(int statusCode) {
        if (!this.skipScenario) {
            ScenarioContext.setContext(String.valueOf(Thread.currentThread().getId()), "STATUS_CODE", String.valueOf(this.response.getStatusCode()));
            this.validatableResponse = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)this.response.then()).log().ifValidationFails()).statusCode(statusCode);
            LOGGER.info(ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())).toString());
            LOGGER.info(this.validatableResponse.extract().body().asString());
            this.scenario.attach(new JSONObject(ScenarioContext.getPrintableContextObject(String.valueOf(Thread.currentThread().getId()))).toString(4), "application/json", "contextual-dataset ");
        }
    }

    private void attachResponse(ValidatableResponse validatableResponse) {
        if (validatableResponse != null && validatableResponse.extract().body() != null) {
            String xmlType = this.response.getContentType().contains("xml") ? "text/xml" : this.response.getContentType();
            this.scenario.attach(validatableResponse.extract().body().asString(), xmlType, "actual-response ");
        }
    }

    private void attachActualResponse(String actual) {
        String xmlType = this.response.getContentType().contains("xml") ? "text/xml" : this.response.getContentType();
        this.scenario.attach(actual, xmlType, "expected-response ");
    }

    @And(value="^Verify-standard (.*) all inline (.*) api includes following in the response$")
    public void verifyFormatedMapson(String type, String resource, List<String> readData) throws Throwable {
        if (!this.skipScenario) {
            this.attachResponse(this.validatableResponse);
            StandardProcessing processing = stdProcessorMap.get(type);
            if (processing != null) {
                if (this.validatableResponse != null && this.validatableResponse.extract().body().asString() != null) {
                    String readXML = readData.stream().map(Object::toString).collect(Collectors.joining());
                    String jsonRequestActual = processing.postResponseProcessing(this.validatableResponse.extract().body().asString());
                    String jsonRequestExpected = processing.postResponseProcessing(readXML);
                    if (jsonRequestExpected != null && jsonRequestActual != null) {
                        Map mapson = Mapson.buildMAPsonFromJson((String)jsonRequestExpected);
                        Map mapsonActual = Mapson.buildMAPsonFromJson((String)jsonRequestActual);
                        if (this.areEqualKeyValues(resource, mapsonActual, mapson, true)) {
                            Assert.assertTrue((String)"Comparison success", (boolean)true);
                        } else {
                            Assert.assertTrue((String)"Comparison failed refer Comparison Failure", (boolean)false);
                        }
                    } else {
                        Assert.assertTrue((String)("Standard " + type + " has no response validation "), (boolean)false);
                    }
                } else {
                    Assert.assertTrue((String)"Api Response was not received ", (boolean)false);
                }
            } else {
                Assert.assertTrue((String)("Standard " + type + " is not implemented for response "), (boolean)false);
            }
        }
    }

    @Given(value="^Verify-standard (.*) all (.*) file (.*) api includes following in the response$")
    public void verifyFormatedMapson(String type, String file, String resource) throws Throwable {
        if (!this.skipScenario) {
            this.attachResponse(this.validatableResponse);
            StandardProcessing processing = stdProcessorMap.get(type);
            if (processing != null) {
                if (this.validatableResponse != null && this.validatableResponse.extract().body().asString() != null) {
                    String body = HelperUtil.readFileAsString(file);
                    String jsonRequestActual = processing.postResponseProcessing(this.validatableResponse.extract().body().asString());
                    String jsonRequestExpected = processing.postResponseProcessing(body);
                    if (jsonRequestExpected != null && jsonRequestActual != null) {
                        Map mapsonExpected;
                        Map mapson = Mapson.buildMAPsonFromJson((String)jsonRequestExpected);
                        if (this.areEqualKeyValues(resource, mapson, mapsonExpected = Mapson.buildMAPsonFromJson((String)jsonRequestActual), true)) {
                            Assert.assertTrue((String)"Comparison success", (boolean)true);
                        } else {
                            Assert.assertTrue((String)"Comparison failed refer Comparison Failure", (boolean)false);
                        }
                    } else {
                        Assert.assertTrue((String)("Standard " + type + " has no response validation "), (boolean)false);
                    }
                } else {
                    Assert.assertTrue((String)"Api Response was not received ", (boolean)false);
                }
            } else {
                Assert.assertTrue((String)("Standard " + type + " is not implemented for response "), (boolean)false);
            }
        }
    }

    @And(value="^Verify-all (.*) api includes following in the response$")
    public void verifyResponseMapson(String resource, DataTable data) throws Throwable {
        if (!this.skipScenario) {
            this.attachResponse(this.validatableResponse);
            Map mapson = Mapson.buildMAPsonFromJson((String)this.validatableResponse.extract().body().asString());
            if (this.areEqualKeyValues(resource, data.asMap(String.class, String.class), mapson, false)) {
                Assert.assertTrue((String)"Comparison success", (boolean)true);
            } else {
                Assert.assertTrue((String)"Comparison failed refer Comparison Failure", (boolean)false);
            }
        }
    }

    private boolean areEqualKeyValues(String resource, Map<String, String> first, Map<String, String> second, boolean isActual) {
        String actual = isActual ? "expected" : "actual";
        String expected = isActual ? "actual" : "expected";
        Map<String, JSONObject> result = first.entrySet().stream().filter(y -> !ExcludeConfiguration.shouldSkip(resource, (String)y.getKey())).filter(e -> (e.getValue() == null || second.get(e.getKey()) == null || !StepDefinitionHelper.getActualValue(((String)e.getValue()).trim()).equals(((String)second.get(e.getKey())).trim())) && (e.getValue() != null || e.getValue() != second.get(e.getKey()) && !"".equals(second.get(e.getKey())))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> {
            JSONObject object = new JSONObject();
            object.put(expected, e.getValue() != null ? StepDefinitionHelper.getActualValue(((String)e.getValue()).trim()) : null);
            object.put(actual, second.get(e.getKey()));
            return object;
        }));
        if (!result.isEmpty()) {
            List values = result.values().stream().filter(x -> !x.optString("expected").replace("\\r", "\r").equals(x.optString("actual"))).collect(Collectors.toList());
            if (!values.isEmpty()) {
                JSONArray array = new JSONArray();
                result.entrySet().forEach(x -> {
                    JSONObject object = new JSONObject();
                    object.put((String)x.getKey(), x.getValue());
                    array.put((Object)object);
                });
                this.scenario.attach(array.toString(4), "application/json", "Comparison Failure");
            } else {
                return values.isEmpty();
            }
        }
        return result.isEmpty();
    }

    @And(value="^Verify (.*) response inline includes in the response$")
    public void verifyFileResponse(String resource, List<String> xmlString) throws Throwable {
        if (!this.skipScenario) {
            this.attachResponse(this.validatableResponse);
            String listString = xmlString.stream().map(Object::toString).collect(Collectors.joining());
            HelperUtil.assertXMLEquals(listString, this.response.asString());
        }
    }

    @And(value="^Verify (.*) response XML File (.*) includes in the response$")
    public void verifyXMLResponse(String resource, String fileBody) throws Throwable {
        if (!this.skipScenario) {
            this.attachResponse(this.validatableResponse);
            String body = HelperUtil.readFileAsString(fileBody);
            if (body != null) {
                HelperUtil.assertXMLEquals(body, this.response.asString());
            } else {
                Assert.assertTrue((String)(fileBody + "  file is missing :"), (boolean)false);
            }
        }
    }

    @And(value="^Verify (.*) response (.*) include byPath (.*) includes in the response$")
    public void verifyXMLByPathResponse(String resource, String contentType, String fileBody, List<String> xpaths) throws Exception {
        if (!this.skipScenario) {
            String body = HelperUtil.readFileAsString(fileBody);
            this.attachActualResponse(body);
            this.attachResponse(this.validatableResponse);
            if (body != null) {
                if (contentType.contains("xml")) {
                    HelperUtil.assertXpathsEqual(xpaths, body, this.response.asString());
                } else {
                    HelperUtil.assertJsonpathEqual(xpaths, body, this.response.asString());
                }
            } else {
                Assert.assertTrue((String)(fileBody + "  file is missing :"), (boolean)false);
            }
        }
    }

    @And(value="^Verify (.*) response with (.*) includes in the response$")
    public void verifySingleResponse(String resource, String context) {
        if (!this.skipScenario) {
            this.attachResponse(this.validatableResponse);
            String output = this.validatableResponse.extract().body().asString() != null ? this.validatableResponse.extract().body().asString().trim() : null;
            Assert.assertEquals((Object)context.trim(), (Object)output.trim());
        }
    }

    @And(value="^Verify (.*) response csvson includes in the response$")
    public void verify(String path, List<String> csvson) throws Exception {
        JSONArray expectedArray = Csvson.buildCSVson(csvson, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())));
        Object objJson = StepDefinitionHelper.getJSON(this.validatableResponse.extract().body().asString());
        JSONCompareResult result = null;
        this.scenario.attach(expectedArray.toString(), "application/json", "Expected json");
        if (objJson instanceof JSONArray) {
            JSONArray actualArray = new JSONArray(this.validatableResponse.extract().body().asString());
            result = JSONCompare.compareJSON((JSONArray)expectedArray, (JSONArray)actualArray, (JSONCompareMode)JSONCompareMode.LENIENT);
            this.scenario.attach(actualArray.toString(), "application/json", "Actual json");
        } else if (objJson instanceof JSONObject) {
            JSONObject actualArray = new JSONObject(this.validatableResponse.extract().body().asString());
            result = actualArray.optJSONArray(path) != null && actualArray.optJSONArray(path).length() > 0 ? JSONCompare.compareJSON((JSONArray)expectedArray, (JSONArray)actualArray.getJSONArray(path), (JSONCompareMode)JSONCompareMode.LENIENT) : JSONCompare.compareJSON((JSONObject)expectedArray.getJSONObject(0), (JSONObject)actualArray, (JSONCompareMode)JSONCompareMode.LENIENT);
            this.scenario.attach(actualArray.toString(), "application/json", "Actual json");
        }
        if (result == null) {
            Assert.assertTrue((String)"Actual input is not a valid JSON Object", (boolean)false);
        } else if (result.failed()) {
            this.scenario.attach(result.getMessage(), "text/plain", "Unmatched csvson");
            Assert.assertTrue((String)"Csvson record does not match", (boolean)result.passed());
        } else {
            Assert.assertTrue((String)"Csvson record matches", (boolean)result.passed());
        }
    }

    @And(value="^Verify (.*) includes following in the response$")
    public void verifyResponse(String dummyString, DataTable data) throws Throwable {
        if (!this.skipScenario) {
            this.attachResponse(this.validatableResponse);
            data.asMap(String.class, String.class).forEach((k, v) -> {
                LOGGER.info(v + " : " + this.validatableResponse.extract().body().jsonPath().getString((String)k));
                Assert.assertEquals((Object)StepDefinitionHelper.getActualValue((String)v), (Object)this.validatableResponse.extract().body().jsonPath().getString((String)k));
            });
        }
    }

    static {
        try {
            OpenAPIParser.loader();
            EndpointConfiguration.getInstance().loadEndpoints();
            BaseStepDefinition.loadStandardProcessors();
        }
        catch (ParserError parserError) {
            LOGGER.warning("Unable to start the process - see if conf folder and endpoints are generated");
            System.exit(-1);
        }
    }
}

