/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.props.util;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.cucumber.java.Scenario;
import io.restassured.response.ValidatableResponse;
import io.virtualan.csvson.Csvson;
import io.virtualan.cucumblan.props.ApplicationConfiguration;
import io.virtualan.cucumblan.props.ExcludeConfiguration;
import io.virtualan.cucumblan.props.util.ScenarioContext;
import io.virtualan.cucumblan.props.util.StepDefinitionHelper;
import io.virtualan.jassert.VirtualJSONAssert;
import io.virtualan.mapson.Mapson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class HelperApiUtil {
    private static final Logger log = LoggerFactory.getLogger(HelperApiUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
            }
            finally {
                is.close();
            }
            return sb.toString().trim();
        }
        return null;
    }

    public static String readFileAsString(String fileBody) {
        String body = null;
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileBody);
        if (stream == null) {
            stream = ApplicationConfiguration.class.getClassLoader().getResourceAsStream(fileBody);
        }
        if (stream != null) {
            try {
                body = HelperApiUtil.convertStreamToString(stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return body;
    }

    private static Document getDocument(String xmlData) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(xmlData));
        Document doc = builder.parse(inputSource);
        return doc;
    }

    public static void assertXpathsEqual(List<String> xpaths, String expectedXML, String actualXML) throws Exception {
        Document expectedDoc = HelperApiUtil.getDocument(expectedXML);
        Document actualDoc = HelperApiUtil.getDocument(actualXML);
        for (String xpathStr : xpaths) {
            XpathEngine xpath = XMLUnit.newXpathEngine();
            Assert.assertEquals((String)xpathStr, (Object)xpath.evaluate(xpathStr, expectedDoc), (Object)xpath.evaluate(xpathStr, actualDoc));
        }
    }

    public static Object getJSON(String jsonString, String path) {
        DocumentContext docCtx = JsonPath.parse((String)jsonString);
        JsonPath jsonPath = JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
        Object value = docCtx.read(jsonPath);
        return value;
    }

    public static void assertJSONObject(String resource, String jsonRequestExpected, String jsonRequestActual) {
        if (jsonRequestExpected != null && jsonRequestActual != null) {
            Map mapson = Mapson.buildMAPsonFromJson((String)jsonRequestExpected);
            Map mapsonExpected = Mapson.buildMAPsonFromJson((String)jsonRequestActual);
            mapsonExpected.forEach((k, v) -> {
                if (!ExcludeConfiguration.shouldSkip(resource, k)) {
                    if (v == null) {
                        if (mapson.get(k) == null) {
                            Assert.assertNull(mapson.get(k));
                        } else {
                            Assert.assertEquals((Object)" ", mapson.get(k));
                        }
                    } else {
                        Assert.assertEquals((String)("Key: " + k + "  Expected : " + v + " ==> Actual " + (String)mapson.get(k)), (Object)v, mapson.get(k));
                    }
                }
            });
        } else {
            Assert.assertTrue((String)"JSON missing in the expected or actual  ", (boolean)false);
        }
    }

    public static void assertJsonpathEqual(List<String> jsonPath, String expectedjson, String actualjson) {
        for (String jpath : jsonPath) {
            Object expected = HelperApiUtil.getJSON(expectedjson, jpath);
            Object actual = HelperApiUtil.getJSON(actualjson, jpath);
            if (expected instanceof JSONObject) {
                Assert.assertTrue((String)jpath, (boolean)VirtualJSONAssert.jAssertObject((JSONObject)((JSONObject)expected), (JSONObject)((JSONObject)actual), (JSONCompareMode)JSONCompareMode.LENIENT));
                continue;
            }
            if (expected instanceof JSONArray) {
                Assert.assertTrue((String)jpath, (boolean)VirtualJSONAssert.jAssertArray((JSONArray)((JSONArray)expected), (JSONArray)((JSONArray)actual), (JSONCompareMode)JSONCompareMode.LENIENT));
                continue;
            }
            Assert.assertEquals((String)jpath, (Object)expected.toString(), (Object)actual.toString());
        }
    }

    public static void assertXMLEquals(String expectedXML, String actualXML) throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        DetailedDiff diff = new DetailedDiff(XMLUnit.compareXML((String)expectedXML, (String)actualXML));
        List allDifferences = diff.getAllDifferences();
        Assert.assertEquals((String)("Differences found: " + diff.toString()), (long)0L, (long)allDifferences.size());
    }

    public static void verifyCSVSON(ValidatableResponse validatableResponse, String path, List<String> csvson, JSONCompareMode mode, Scenario scenario) throws Exception {
        JSONArray expectedArray = Csvson.buildCSVson(csvson, ScenarioContext.getContext(String.valueOf(Thread.currentThread().getId())));
        Object objJson = StepDefinitionHelper.getJSON(validatableResponse.extract().body().asString());
        JSONCompareResult result = null;
        scenario.attach(expectedArray.toString(), "application/json", "Expected json");
        JSONArray notFoundArray = null;
        if (objJson instanceof JSONArray) {
            JSONArray actualArray = new JSONArray(validatableResponse.extract().body().asString());
            scenario.attach(actualArray.toString(), "application/json", "Actual json");
            if (expectedArray.length() == actualArray.length()) {
                result = JSONCompare.compareJSON((JSONArray)expectedArray, (JSONArray)actualArray, (JSONCompareMode)mode);
            } else {
                notFoundArray = HelperApiUtil.getUnmatchedElement(mode, expectedArray, actualArray);
            }
        } else if (objJson instanceof JSONObject) {
            JSONObject actualArray = new JSONObject(validatableResponse.extract().body().asString());
            if (actualArray.optJSONArray(path) != null && actualArray.optJSONArray(path).length() > 0) {
                if (expectedArray.length() == actualArray.getJSONArray(path).length()) {
                    result = JSONCompare.compareJSON((JSONArray)expectedArray, (JSONArray)actualArray.getJSONArray(path), (JSONCompareMode)mode);
                } else {
                    notFoundArray = HelperApiUtil.getUnmatchedElement(mode, expectedArray, actualArray.getJSONArray(path));
                }
            } else {
                result = JSONCompare.compareJSON((JSONObject)expectedArray.getJSONObject(0), (JSONObject)actualArray, (JSONCompareMode)mode);
            }
            scenario.attach(actualArray.toString(), "application/json", "Actual json");
        }
        if (result == null && notFoundArray == null) {
            Assert.assertTrue((String)"Actual input is not a valid JSON Object", (boolean)false);
        } else if (result != null && result.failed()) {
            scenario.attach(result.getMessage(), "text/plain", "Unmatched csvson");
            Assert.assertTrue((String)"Csvson record does not match", (boolean)result.passed());
        } else if (notFoundArray != null && notFoundArray.length() > 0) {
            scenario.attach(notFoundArray.toString(2), "application/json", "Unmatched csvson");
            Assert.assertTrue((String)"Csvson record does not match and see unmatched records", (boolean)false);
        } else {
            Assert.assertTrue((String)"Csvson record matches", (boolean)true);
        }
    }

    private static boolean isMatchNotFound(JSONObject actual, JSONArray expectedArray, JSONCompareMode mode) {
        for (int j = 0; j < expectedArray.length(); ++j) {
            JSONCompareResult result = JSONCompare.compareJSON((JSONObject)actual, (JSONObject)expectedArray.getJSONObject(j), (JSONCompareMode)mode);
            if (!result.passed()) continue;
            return false;
        }
        return true;
    }

    private static JSONArray getUnmatchedElement(JSONCompareMode mode, JSONArray expectedArray, JSONArray actualArray) {
        JSONArray notFoundArray = new JSONArray();
        for (int i = 0; i < expectedArray.length(); ++i) {
            if (!HelperApiUtil.isMatchNotFound(expectedArray.getJSONObject(i), actualArray, mode)) continue;
            notFoundArray.put((Object)expectedArray.getJSONObject(i));
        }
        return notFoundArray;
    }
}

