/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.props;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ApplicationConfiguration {
    private static final Logger LOGGER = Logger.getLogger(ApplicationConfiguration.class.getName());
    private static Properties properties = new Properties();

    public static void reload() {
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("cucumblan.properties");
            if (stream == null) {
                stream = ApplicationConfiguration.class.getClassLoader().getResourceAsStream("cucumblan.properties");
            }
            if (stream != null) {
                properties.load(stream);
            } else {
                LOGGER.warning("unable to load cucumblan.properties");
            }
        }
        catch (Exception e) {
            LOGGER.warning("cucumblan.properties not found");
        }
    }

    public static void setProperty(String key, String value) {
        properties.put(key, value);
    }

    public static boolean getInline() {
        return properties.getProperty("data-inline") != null ? properties.getProperty("data-inline").equalsIgnoreCase("true") : true;
    }

    public static boolean isProdMode() {
        return properties.getProperty("prod-mode") != null ? properties.getProperty("prod-mode").equalsIgnoreCase("true") : false;
    }

    public static String getStandardPackage() {
        return properties.getProperty("standard-package") != null ? properties.getProperty("standard-package") : "io.virtualan.cucumblan.standard";
    }

    public static String getMessageTypePackage() {
        return properties.getProperty("message-package") != null ? properties.getProperty("message-package") : "io.virtualan.cucumblan.message.typeimpl";
    }

    public static String getActionPackage() {
        return properties.getProperty("action-package") != null ? properties.getProperty("action-package") : "io.virtualan.cucumblan.ui.actionimpl";
    }

    public static boolean getBoolean(String keyName) {
        return properties.getProperty(keyName) != null ? properties.getProperty(keyName).equalsIgnoreCase("true") : false;
    }

    public static Map<String, String> getProperties() {
        return properties;
    }

    public static String getProperty(String keyName) {
        return properties.getProperty(keyName);
    }

    static {
        ApplicationConfiguration.reload();
    }
}

