/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.props.util;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.virtualan.cucumblan.props.ApplicationConfiguration;
import io.virtualan.cucumblan.props.ExcludeConfiguration;
import io.virtualan.jassert.VirtualJSONAssert;
import io.virtualan.mapson.Mapson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class HelperUtil {
    private static final Logger log = LoggerFactory.getLogger(HelperUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        return null;
    }

    public static String readFileAsString(String fileBody) {
        String body = null;
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileBody);
        if (stream == null) {
            stream = ApplicationConfiguration.class.getClassLoader().getResourceAsStream(fileBody);
        }
        if (stream != null) {
            try {
                body = HelperUtil.convertStreamToString(stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return body;
    }

    private static Document getDocument(String xmlData) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(xmlData));
        Document doc = builder.parse(inputSource);
        return doc;
    }

    public static void assertXpathsEqual(List<String> xpaths, String expectedXML, String actualXML) throws Exception {
        Document expectedDoc = HelperUtil.getDocument(expectedXML);
        Document actualDoc = HelperUtil.getDocument(actualXML);
        for (String xpathStr : xpaths) {
            XpathEngine xpath = XMLUnit.newXpathEngine();
            Assert.assertEquals((String)xpathStr, (Object)xpath.evaluate(xpathStr, expectedDoc), (Object)xpath.evaluate(xpathStr, actualDoc));
        }
    }

    public static Object getJSON(String jsonString, String path) {
        DocumentContext docCtx = JsonPath.parse((String)jsonString);
        JsonPath jsonPath = JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
        Object value = docCtx.read(jsonPath);
        return value;
    }

    public static void assertJSONObject(String resource, String jsonRequestExpected, String jsonRequestActual) {
        if (jsonRequestExpected != null && jsonRequestActual != null) {
            Map mapson = Mapson.buildMAPsonFromJson((String)jsonRequestExpected);
            Map mapsonExpected = Mapson.buildMAPsonFromJson((String)jsonRequestActual);
            mapsonExpected.forEach((k, v) -> {
                if (!ExcludeConfiguration.shouldSkip(resource, k)) {
                    if (v == null) {
                        if (mapson.get(k) == null) {
                            Assert.assertNull(mapson.get(k));
                        } else {
                            Assert.assertEquals((Object)" ", mapson.get(k));
                        }
                    } else {
                        Assert.assertEquals((String)("Key: " + k + "  Expected : " + v + " ==> Actual " + (String)mapson.get(k)), (Object)v, mapson.get(k));
                    }
                }
            });
        } else {
            Assert.assertTrue((String)"JSON missing in the expected or actual  ", (boolean)false);
        }
    }

    public static void assertJsonpathEqual(List<String> jsonPath, String expectedjson, String actualjson) {
        for (String jpath : jsonPath) {
            Object expected = HelperUtil.getJSON(expectedjson, jpath);
            Object actual = HelperUtil.getJSON(actualjson, jpath);
            if (expected instanceof JSONObject) {
                Assert.assertTrue((String)jpath, (boolean)VirtualJSONAssert.jAssertObject((JSONObject)((JSONObject)expected), (JSONObject)((JSONObject)actual), (JSONCompareMode)JSONCompareMode.LENIENT));
                continue;
            }
            if (expected instanceof JSONArray) {
                Assert.assertTrue((String)jpath, (boolean)VirtualJSONAssert.jAssertArray((JSONArray)((JSONArray)expected), (JSONArray)((JSONArray)actual), (JSONCompareMode)JSONCompareMode.LENIENT));
                continue;
            }
            Assert.assertEquals((String)jpath, (Object)expected.toString(), (Object)actual.toString());
        }
    }

    public static void assertXMLEquals(String expectedXML, String actualXML) throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        DetailedDiff diff = new DetailedDiff(XMLUnit.compareXML((String)expectedXML, (String)actualXML));
        List allDifferences = diff.getAllDifferences();
        Assert.assertEquals((String)("Differences found: " + diff.toString()), (long)0L, (long)allDifferences.size());
    }
}

