/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.props;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfiguration.class);
    private static Properties properties = new Properties();

    public static void reload() {
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("cucumblan.properties");
            if (stream == null) {
                stream = ApplicationConfiguration.class.getClassLoader().getResourceAsStream("cucumblan.properties");
            }
            if (stream != null) {
                properties.load(stream);
            } else {
                log.warn("unable to load cucumblan.properties");
            }
        }
        catch (Exception e) {
            log.warn("cucumblan.properties not found");
        }
    }

    public static void setProperty(String key, String value) {
        properties.put(key, value);
    }

    public static boolean getInline() {
        return properties.getProperty("data-inline") != null ? properties.getProperty("data-inline").equalsIgnoreCase("true") : true;
    }

    public static boolean getBoolean(String keyName) {
        return properties.getProperty(keyName) != null ? properties.getProperty(keyName).equalsIgnoreCase("true") : false;
    }

    public static Map<String, String> getProperties() {
        return properties;
    }

    public static String getProperty(String keyName) {
        return properties.getProperty(keyName);
    }

    static {
        ApplicationConfiguration.reload();
    }
}

