/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.props.util;

import io.virtualan.cucumblan.props.ApplicationConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperUtil {
    private static final Logger log = LoggerFactory.getLogger(HelperUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        return null;
    }

    public static String readFileAsString(String fileBody) {
        String body = null;
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileBody);
        if (stream == null) {
            stream = ApplicationConfiguration.class.getClassLoader().getResourceAsStream(fileBody);
        }
        if (stream != null) {
            try {
                body = HelperUtil.convertStreamToString(stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return body;
    }

    public static void assertXMLEquals(String expectedXML, String actualXML) throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        DetailedDiff diff = new DetailedDiff(XMLUnit.compareXML((String)expectedXML, (String)actualXML));
        List allDifferences = diff.getAllDifferences();
        Assert.assertEquals((String)("Differences found: " + diff.toString()), (long)0L, (long)allDifferences.size());
    }
}

