/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.cucumblan.props;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class EndpointConfiguration {
    private static EndpointConfiguration endpointConfiguration = null;
    private static Map<String, Properties> propertiesMap = new HashMap<String, Properties>();

    private EndpointConfiguration() {
    }

    public static EndpointConfiguration getInstance() {
        if (endpointConfiguration == null) {
            endpointConfiguration = new EndpointConfiguration();
        }
        return endpointConfiguration;
    }

    public void loadEndpoints() {
        File directory = new File("conf/");
        String[] myFiles = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File directory, String fileName) {
                return fileName.matches("endpoint.*.properties");
            }
        });
        boolean i = false;
        for (String file : myFiles) {
            Properties resourceEndPoint = new Properties();
            try {
                resourceEndPoint.load(new InputStreamReader(new FileInputStream("conf/" + file)));
                propertiesMap.put(file.substring(file.indexOf(".") + 1, file.lastIndexOf(".")), resourceEndPoint);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Properties getProperty(String keyName) {
        return propertiesMap.get(keyName);
    }
}

