/**
 * vertigo - application development platform
 *
 * Copyright (C) 2013-2020, Vertigo.io, team@vertigo.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.vertigo.social.impl.mail;

import javax.inject.Inject;

import io.vertigo.core.lang.Assertion;
import io.vertigo.core.locale.LocaleManager;
import io.vertigo.social.mail.Mail;
import io.vertigo.social.mail.MailManager;

/**
 * This class is the standard impl of the mailManager.
 * This class have a single plugin to parameterize the way that mails are sent.
 *
 * @author npiedeloup
 */
public final class MailManagerImpl implements MailManager {
	private final SendMailPlugin sendMailPlugin;

	/**
	 * Constructor.
	 * @param localeManager the manager of the localized messages
	 * @param sendMailPlugin the plugin that sends mails
	 */
	@Inject
	public MailManagerImpl(final LocaleManager localeManager, final SendMailPlugin sendMailPlugin) {
		Assertion.check()
				.isNotNull(localeManager)
				.isNotNull(sendMailPlugin);
		//-----
		localeManager.add("io.vertigo.social.impl.mail.Mail", io.vertigo.social.impl.mail.Resources.values());
		this.sendMailPlugin = sendMailPlugin;
	}

	/** {@inheritDoc} */
	@Override
	public void sendMail(final Mail mail) {
		Assertion.check().isNotNull(mail);
		//-----
		sendMailPlugin.sendMail(mail);
	}
}
